/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import jmri.jmrit.logixng.util.parser.Bundle;
import jmri.jmrit.logixng.util.parser.InvalidSyntaxException;
import jmri.jmrit.logixng.util.parser.Token;
import jmri.jmrit.logixng.util.parser.TokenType;

public class Tokenizer {
    private Tokenizer() {
    }

    private static void addToken(Token currentToken, List<Token> tokens) {
        if (currentToken._tokenType == TokenType.FLOATING_NUMBER && Tokenizer.isIntegerNumber(currentToken._string)) {
            currentToken._tokenType = TokenType.INTEGER_NUMBER;
        }
        tokens.add(currentToken);
    }

    public static List<Token> getTokens(String expression) throws InvalidSyntaxException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Token currentToken = new Token();
        AtomicInteger eatNextChar = new AtomicInteger(0);
        char ch = ' ';
        int i = 0;
        while (i < expression.length()) {
            char lastChar = ch;
            ch = expression.charAt(i);
            char nextChar = ' ';
            if (i + 1 < expression.length()) {
                nextChar = expression.charAt(i + 1);
            }
            if (ch == '\"') {
                if (Character.isLetterOrDigit(lastChar)) {
                    throw new InvalidSyntaxException(Bundle.getMessage("InvalidSyntaxAtIndex", i));
                }
                if (currentToken._tokenType == TokenType.SPACE) {
                    currentToken = new Token();
                } else if (currentToken._tokenType != TokenType.NONE) {
                    Tokenizer.addToken(currentToken, tokens);
                    currentToken = new Token();
                }
                currentToken._tokenType = TokenType.STRING;
                boolean done = false;
                while (!done) {
                    if (++i >= expression.length()) {
                        throw new InvalidSyntaxException(Bundle.getMessage("UnexpectedEndOfString"));
                    }
                    ch = expression.charAt(i);
                    nextChar = ' ';
                    if (i + 1 < expression.length()) {
                        nextChar = expression.charAt(i + 1);
                    }
                    if (ch == '\\' && (nextChar == '\\' || nextChar == '\"')) {
                        currentToken._string = String.valueOf(currentToken._string) + nextChar;
                        ++i;
                    } else if (ch != '\"') {
                        currentToken._string = String.valueOf(currentToken._string) + ch;
                    }
                    boolean bl = done = ch == '\"';
                }
                if (Character.isLetterOrDigit(nextChar)) {
                    throw new InvalidSyntaxException(Bundle.getMessage("InvalidSyntaxAtIndex", i));
                }
                Tokenizer.addToken(currentToken, tokens);
                currentToken = new Token();
            } else {
                TokenType nextToken;
                char nextNextChar = ' ';
                char nextNextNextChar = ' ';
                if (i + 2 < expression.length()) {
                    nextNextChar = expression.charAt(i + 2);
                }
                if (i + 3 < expression.length()) {
                    nextNextNextChar = expression.charAt(i + 3);
                }
                if ((nextToken = Tokenizer.getTokenType(currentToken, ch, nextChar, nextNextChar, nextNextNextChar, eatNextChar)) == TokenType.SAME_AS_LAST) {
                    currentToken._string = String.valueOf(currentToken._string) + ch;
                } else {
                    switch (nextToken) {
                        case ERROR: {
                            throw new InvalidSyntaxException(Bundle.getMessage("InvalidSyntaxAtIndex", i));
                        }
                        case NONE: 
                        case SPACE: 
                        case COMMA: 
                        case DOT_DOT: 
                        case DOT: 
                        case ASSIGN: 
                        case ASSIGN_ADD: 
                        case ASSIGN_SUBTRACKT: 
                        case ASSIGN_MULTIPLY: 
                        case ASSIGN_DIVIDE: 
                        case ASSIGN_MODULO: 
                        case ASSIGN_AND: 
                        case ASSIGN_OR: 
                        case ASSIGN_XOR: 
                        case ASSIGN_SHIFT_LEFT: 
                        case ASSIGN_SHIFT_RIGHT: 
                        case ASSIGN_UNSIGNED_SHIFT_RIGHT: 
                        case TERNARY_QUESTION_MARK: 
                        case TERNARY_COLON: 
                        case BOOLEAN_OR: 
                        case BOOLEAN_AND: 
                        case BINARY_OR: 
                        case BINARY_XOR: 
                        case BINARY_AND: 
                        case EQUAL: 
                        case NOT_EQUAL: 
                        case LESS_THAN: 
                        case LESS_OR_EQUAL: 
                        case GREATER_THAN: 
                        case GREATER_OR_EQUAL: 
                        case SHIFT_LEFT: 
                        case SHIFT_RIGHT: 
                        case UNSIGNED_SHIFT_RIGHT: 
                        case ADD: 
                        case SUBTRACKT: 
                        case MULTIPLY: 
                        case DIVIDE: 
                        case MODULO: 
                        case BOOLEAN_NOT: 
                        case BINARY_NOT: 
                        case INCREMENT: 
                        case DECREMENT: 
                        case LEFT_PARENTHESIS: 
                        case RIGHT_PARENTHESIS: 
                        case LEFT_SQUARE_BRACKET: 
                        case RIGHT_SQUARE_BRACKET: 
                        case LEFT_CURLY_BRACKET: 
                        case RIGHT_CURLY_BRACKET: 
                        case IDENTIFIER: {
                            if (currentToken._tokenType != TokenType.NONE && currentToken._tokenType != TokenType.SPACE) {
                                Tokenizer.addToken(currentToken, tokens);
                                currentToken = new Token();
                            }
                            currentToken._tokenType = nextToken;
                            break;
                        }
                        case FLOATING_NUMBER: {
                            if (currentToken._tokenType == TokenType.FLOATING_NUMBER && !currentToken._string.isEmpty() && !Tokenizer.isFloatingNumber(currentToken._string)) {
                                throw new InvalidSyntaxException(Bundle.getMessage("InvalidSyntaxAtIndex", i));
                            }
                            if (currentToken._tokenType != TokenType.NONE && currentToken._tokenType != TokenType.SPACE) {
                                Tokenizer.addToken(currentToken, tokens);
                                currentToken = new Token();
                            }
                            currentToken._tokenType = nextToken;
                            break;
                        }
                        case STRING: {
                            if (!currentToken._string.endsWith("\"")) {
                                throw new InvalidSyntaxException(Bundle.getMessage("InvalidSyntaxAtIndex", i));
                            }
                            if (currentToken._tokenType != TokenType.NONE && currentToken._tokenType != TokenType.SPACE) {
                                Tokenizer.addToken(currentToken, tokens);
                                currentToken = new Token();
                            }
                            currentToken._tokenType = nextToken;
                            break;
                        }
                        default: {
                            throw new RuntimeException("unknown token type: " + nextToken.name());
                        }
                    }
                    if (currentToken._tokenType != TokenType.SPACE) {
                        currentToken._string = String.valueOf(currentToken._string) + ch;
                    }
                    i += eatNextChar.get();
                }
            }
            ++i;
        }
        if (currentToken._tokenType != TokenType.NONE) {
            Tokenizer.addToken(currentToken, tokens);
        }
        return tokens;
    }

    private static TokenType getTokenType(Token currentToken, char ch, char nextChar, char nextNextChar, char nextNextNextChar, AtomicInteger eatNextChar) {
        eatNextChar.set(0);
        if (ch == '\"') {
            return TokenType.STRING;
        }
        if (Character.isSpaceChar(ch)) {
            return TokenType.SPACE;
        }
        if (currentToken._tokenType == TokenType.STRING) {
            return TokenType.SAME_AS_LAST;
        }
        if (ch == '.') {
            if (nextChar == '.') {
                if (currentToken._tokenType != TokenType.DOT_DOT) {
                    eatNextChar.set(1);
                    return TokenType.DOT_DOT;
                }
                return TokenType.ERROR;
            }
            if (currentToken._tokenType == TokenType.IDENTIFIER || currentToken._tokenType == TokenType.NONE || currentToken._tokenType == TokenType.RIGHT_PARENTHESIS || currentToken._tokenType == TokenType.RIGHT_SQUARE_BRACKET || currentToken._tokenType == TokenType.RIGHT_CURLY_BRACKET) {
                return TokenType.DOT;
            }
        }
        if (ch == '?') {
            return TokenType.TERNARY_QUESTION_MARK;
        }
        if (ch == ':') {
            return TokenType.TERNARY_COLON;
        }
        if (ch == '=' && nextChar != '=') {
            return TokenType.ASSIGN;
        }
        if (nextChar == '=') {
            switch (ch) {
                case '+': {
                    eatNextChar.set(1);
                    return TokenType.ASSIGN_ADD;
                }
                case '-': {
                    eatNextChar.set(1);
                    return TokenType.ASSIGN_SUBTRACKT;
                }
                case '*': {
                    eatNextChar.set(1);
                    return TokenType.ASSIGN_MULTIPLY;
                }
                case '/': {
                    eatNextChar.set(1);
                    return TokenType.ASSIGN_DIVIDE;
                }
                case '%': {
                    eatNextChar.set(1);
                    return TokenType.ASSIGN_MODULO;
                }
            }
        }
        if (ch == '<') {
            switch (nextChar) {
                case '=': {
                    eatNextChar.set(1);
                    return TokenType.LESS_OR_EQUAL;
                }
                case '<': {
                    if (nextNextChar == '=') {
                        eatNextChar.set(2);
                        return TokenType.ASSIGN_SHIFT_LEFT;
                    }
                    eatNextChar.set(1);
                    return TokenType.SHIFT_LEFT;
                }
            }
            return TokenType.LESS_THAN;
        }
        if (ch == '>') {
            switch (nextChar) {
                case '=': {
                    eatNextChar.set(1);
                    return TokenType.GREATER_OR_EQUAL;
                }
                case '>': {
                    if (nextNextChar == '=') {
                        eatNextChar.set(2);
                        return TokenType.ASSIGN_SHIFT_RIGHT;
                    }
                    if (nextNextChar == '>') {
                        if (nextNextNextChar == '=') {
                            eatNextChar.set(3);
                            return TokenType.ASSIGN_UNSIGNED_SHIFT_RIGHT;
                        }
                        eatNextChar.set(2);
                        return TokenType.UNSIGNED_SHIFT_RIGHT;
                    }
                    eatNextChar.set(1);
                    return TokenType.SHIFT_RIGHT;
                }
            }
            return TokenType.GREATER_THAN;
        }
        if (ch == '=') {
            if (nextChar == '=') {
                eatNextChar.set(1);
                return TokenType.EQUAL;
            }
            return TokenType.ERROR;
        }
        if (ch == '!') {
            if (nextChar == '=') {
                eatNextChar.set(1);
                return TokenType.NOT_EQUAL;
            }
            return TokenType.BOOLEAN_NOT;
        }
        if (ch == '|') {
            if (nextChar == '|') {
                eatNextChar.set(1);
                return TokenType.BOOLEAN_OR;
            }
            if (nextChar == '=') {
                eatNextChar.set(1);
                return TokenType.ASSIGN_OR;
            }
            return TokenType.BINARY_OR;
        }
        if (ch == '&') {
            if (nextChar == '&') {
                eatNextChar.set(1);
                return TokenType.BOOLEAN_AND;
            }
            if (nextChar == '=') {
                eatNextChar.set(1);
                return TokenType.ASSIGN_AND;
            }
            return TokenType.BINARY_AND;
        }
        if (ch == '~') {
            return TokenType.BINARY_NOT;
        }
        if (ch == ',') {
            return TokenType.COMMA;
        }
        if (ch == '+') {
            if (nextChar == '+') {
                eatNextChar.set(1);
                return TokenType.INCREMENT;
            }
            return TokenType.ADD;
        }
        if (ch == '-') {
            if (nextChar == '-') {
                eatNextChar.set(1);
                return TokenType.DECREMENT;
            }
            return TokenType.SUBTRACKT;
        }
        if (ch == '*') {
            return TokenType.MULTIPLY;
        }
        if (ch == '/') {
            return TokenType.DIVIDE;
        }
        if (ch == '%') {
            return TokenType.MODULO;
        }
        if (ch == '^') {
            if (nextChar == '=') {
                eatNextChar.set(1);
                return TokenType.ASSIGN_XOR;
            }
            return TokenType.BINARY_XOR;
        }
        if (ch == '(') {
            return TokenType.LEFT_PARENTHESIS;
        }
        if (ch == ')') {
            return TokenType.RIGHT_PARENTHESIS;
        }
        if (ch == '[') {
            return TokenType.LEFT_SQUARE_BRACKET;
        }
        if (ch == ']') {
            return TokenType.RIGHT_SQUARE_BRACKET;
        }
        if (ch == '{') {
            return TokenType.LEFT_CURLY_BRACKET;
        }
        if (ch == '}') {
            return TokenType.RIGHT_CURLY_BRACKET;
        }
        if (currentToken._tokenType == TokenType.FLOATING_NUMBER && (Tokenizer.isFloatingNumber(String.valueOf(currentToken._string) + ch) || Tokenizer.isFloatingNumber(String.valueOf(currentToken._string) + ch + nextChar))) {
            return TokenType.SAME_AS_LAST;
        }
        if (currentToken._tokenType == TokenType.IDENTIFIER && (Character.isLetterOrDigit(ch) || ch == '_')) {
            return TokenType.SAME_AS_LAST;
        }
        if (Character.isDigit(ch)) {
            return TokenType.FLOATING_NUMBER;
        }
        if (currentToken._tokenType == TokenType.FLOATING_NUMBER && Character.isLetterOrDigit(ch)) {
            return TokenType.ERROR;
        }
        if (Character.isDigit(ch)) {
            return TokenType.FLOATING_NUMBER;
        }
        if (Character.isLetter(ch) || ch == '_') {
            return TokenType.IDENTIFIER;
        }
        return TokenType.ERROR;
    }

    private static boolean isIntegerNumber(String str) {
        return str.matches("\\d+");
    }

    private static boolean isFloatingNumber(String str) {
        return str.matches("\\d+") || str.matches("\\d+\\.\\d+");
    }
}

