/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.logixng.util.parser.Constant;
import jmri.jmrit.logixng.util.parser.Function;
import jmri.jmrit.logixng.util.parser.FunctionFactory;

public class FunctionManager
implements InstanceManagerAutoDefault {
    private final Map<String, Constant> _constants = new HashMap<String, Constant>();
    private final Map<String, Function> _functions = new HashMap<String, Function>();

    public FunctionManager() {
        for (FunctionFactory actionFactory : ServiceLoader.load(FunctionFactory.class)) {
            actionFactory.getConstants().forEach(constant -> {
                if (this._constants.containsKey(constant.getName())) {
                    throw new RuntimeException("Constant " + constant.getName() + " is already registered. Class: " + constant.getClass().getName());
                }
                this._constants.put(constant.getName(), (Constant)constant);
            });
            actionFactory.getFunctions().forEach(function -> {
                if (this._functions.containsKey(function.getName())) {
                    throw new RuntimeException("Function " + function.getName() + " is already registered. Class: " + function.getClass().getName());
                }
                this._functions.put(function.getName(), (Function)function);
            });
        }
    }

    public Map<String, Function> getFunctions() {
        return Collections.unmodifiableMap(this._functions);
    }

    public Function get(String name) {
        return this._functions.get(name);
    }

    public Function put(String name, Function function) {
        return this._functions.put(name, function);
    }

    public Constant getConstant(String name) {
        return this._constants.get(name);
    }

    public void put(String name, Constant constant) {
        this._constants.put(name, constant);
    }
}

