/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.Bundle;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.util.TypeConversionUtil;

public class ExpressionNodeTernaryOperator
implements ExpressionNode {
    private final ExpressionNode _leftSide;
    private final ExpressionNode _middleSide;
    private final ExpressionNode _rightSide;

    public ExpressionNodeTernaryOperator(ExpressionNode leftSide, ExpressionNode middleSide, ExpressionNode rightSide) {
        this._leftSide = leftSide;
        this._middleSide = middleSide;
        this._rightSide = rightSide;
        if (this._leftSide == null) {
            throw new IllegalArgumentException("leftSide must not be null");
        }
    }

    @Override
    public Object calculate(SymbolTable symbolTable) throws JmriException {
        boolean left;
        Object leftValue = this._leftSide.calculate(symbolTable);
        if (!(leftValue instanceof Boolean)) {
            if (TypeConversionUtil.isIntegerNumber(leftValue)) {
                leftValue = ((Number)leftValue).longValue() != 0L;
            } else {
                throw new CalculateException(Bundle.getMessage("ArithmeticNotBooleanOrIntegerNumberError", leftValue));
            }
        }
        if (left = ((Boolean)leftValue).booleanValue()) {
            return this._middleSide.calculate(symbolTable);
        }
        return this._rightSide.calculate(symbolTable);
    }

    @Override
    public String getDefinitionString() {
        return "(" + this._leftSide.getDefinitionString() + ")?(" + this._middleSide.getDefinitionString() + "):(" + this._rightSide.getDefinitionString() + ")";
    }
}

