/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.CannotCallMethodException;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ExpressionNodeWithParameter;
import jmri.jmrit.logixng.util.parser.FunctionNotExistsException;
import jmri.jmrit.logixng.util.parser.ReflectionException;
import jmri.jmrit.logixng.util.parser.Variable;

public class ExpressionNodeMethod
implements ExpressionNodeWithParameter {
    private final String _method;
    private final List<ExpressionNode> _parameterList;

    public ExpressionNodeMethod(String method, Map<String, Variable> variables, List<ExpressionNode> parameterList) throws FunctionNotExistsException {
        this._method = method;
        this._parameterList = parameterList;
    }

    private boolean isAssignableFrom(Class<?> type, Object param) {
        if (param == null) {
            return true;
        }
        if (type.isAssignableFrom(param.getClass())) {
            return true;
        }
        if (type == Byte.TYPE && param instanceof Long) {
            return true;
        }
        if (type == Short.TYPE && param instanceof Long) {
            return true;
        }
        if (type == Integer.TYPE && param instanceof Long) {
            return true;
        }
        return type == Float.TYPE && param instanceof Double;
    }

    private boolean canCall(Method m, Object[] params) {
        Class<?>[] paramTypes = m.getParameterTypes();
        if (paramTypes.length != params.length) {
            return false;
        }
        int i = 0;
        while (i < paramTypes.length) {
            if (!this.isAssignableFrom(paramTypes[i], params[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Object callMethod(Method method, Object obj, Object[] params) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] newParams = new Object[params.length];
        int i = 0;
        while (i < params.length) {
            Object newParam;
            if (params[i] == null || paramTypes[i].isAssignableFrom(params[i].getClass())) {
                newParam = params[i];
            } else if (paramTypes[i] == Byte.TYPE && params[i] instanceof Long) {
                newParam = (byte)((Long)params[i]).longValue();
            } else if (paramTypes[i] == Short.TYPE && params[i] instanceof Long) {
                newParam = (short)((Long)params[i]).longValue();
            } else if (paramTypes[i] == Integer.TYPE && params[i] instanceof Long) {
                newParam = (int)((Long)params[i]).longValue();
            } else if (paramTypes[i] == Float.TYPE && params[i] instanceof Double) {
                newParam = Float.valueOf((float)((Double)params[i]).doubleValue());
            } else {
                throw new RuntimeException(String.format("%s cannot be assigned to %s", params[i].getClass().getName(), paramTypes[i].getName()));
            }
            newParams[i] = newParam;
            ++i;
        }
        return method.invoke(obj, newParams);
    }

    @Override
    public Object calculate(Object parameter, SymbolTable symbolTable) throws JmriException {
        if (parameter == null) {
            throw new NullPointerException("Parameter is null");
        }
        Method[] methods = parameter.getClass().getMethods();
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (ExpressionNode exprNode : this._parameterList) {
            parameters.add(exprNode.calculate(symbolTable));
        }
        Object[] params = parameters.toArray();
        Exception exception = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(this._method)) {
                try {
                    if (this.canCall(m, params)) {
                        return this.callMethod(m, parameter, params);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    exception = ex;
                }
            }
            ++n2;
        }
        if (exception != null) {
            throw new ReflectionException("Reflection exception", exception);
        }
        ArrayList<String> paramList = new ArrayList<String>();
        Object[] objectArray = params;
        int n3 = params.length;
        n = 0;
        while (n < n3) {
            Object o = objectArray[n];
            paramList.add(String.format("%s:%s", o, o != null ? o.getClass().getName() : "null"));
            ++n;
        }
        throw new CannotCallMethodException(String.format("Can not call method %s(%s) on object %s", this._method, String.join((CharSequence)", ", paramList), parameter), this._method);
    }

    @Override
    public String getDefinitionString() {
        StringBuilder str = new StringBuilder();
        str.append("Method:");
        str.append(this._method);
        str.append("(");
        int i = 0;
        while (i < this._parameterList.size()) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this._parameterList.get(i).getDefinitionString());
            ++i;
        }
        str.append(")");
        return str.toString();
    }
}

