/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import java.util.Map;
import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ExpressionNodeWithParameter;
import jmri.jmrit.logixng.util.parser.FunctionNotExistsException;

public class ExpressionNodeMap
implements ExpressionNodeWithParameter {
    private final ExpressionNode _exprNode;

    public ExpressionNodeMap(ExpressionNode exprNode) throws FunctionNotExistsException {
        this._exprNode = exprNode;
    }

    @Override
    public Object calculate(Object parameter, SymbolTable symbolTable) throws JmriException {
        if (parameter == null) {
            throw new NullPointerException("Parameter is null");
        }
        if (!(parameter instanceof Map)) {
            throw new IllegalArgumentException("Parameter is not a Map");
        }
        Object index = this._exprNode.calculate(symbolTable);
        return ((Map)parameter).get(index);
    }

    @Override
    public boolean canBeAssigned() {
        return true;
    }

    @Override
    public void assignValue(Object parameter, SymbolTable symbolTable, Object value) throws JmriException {
        if (parameter == null) {
            throw new NullPointerException("Parameter is null");
        }
        if (!(parameter instanceof Map)) {
            throw new IllegalArgumentException("Parameter is not a Map");
        }
        Object index = this._exprNode.calculate(symbolTable);
        ((Map)parameter).put(index, value);
    }

    @Override
    public String getDefinitionString() {
        StringBuilder str = new StringBuilder();
        str.append("{");
        str.append(this._exprNode.getDefinitionString());
        str.append("}");
        return str.toString();
    }
}

