/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import java.lang.reflect.Field;
import java.util.Map;
import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.ExpressionNodeWithParameter;
import jmri.jmrit.logixng.util.parser.IdentifierNotExistsException;
import jmri.jmrit.logixng.util.parser.ReflectionException;
import jmri.jmrit.logixng.util.parser.Variable;

public class ExpressionNodeInstanceVariable
implements ExpressionNodeWithParameter {
    private final String _fieldName;

    public ExpressionNodeInstanceVariable(String fieldName, Map<String, Variable> variables) throws IdentifierNotExistsException {
        this._fieldName = fieldName;
    }

    @Override
    public Object calculate(Object parameter, SymbolTable symbolTable) throws JmriException {
        if (parameter == null) {
            throw new NullPointerException("Parameter is null");
        }
        try {
            Field field = parameter.getClass().getField(this._fieldName);
            return field.get(parameter);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new ReflectionException("Reflection exception", ex);
        }
    }

    @Override
    public boolean canBeAssigned() {
        return true;
    }

    @Override
    public void assignValue(Object parameter, SymbolTable symbolTable, Object value) throws JmriException {
        if (parameter == null) {
            throw new NullPointerException("Parameter is null");
        }
        try {
            Object newValue;
            Field field = parameter.getClass().getField(this._fieldName);
            Class<?> type = field.getType();
            if (type.isAssignableFrom(value.getClass())) {
                newValue = value;
            } else if (type == Byte.TYPE && value instanceof Long) {
                newValue = (byte)((Long)value).longValue();
            } else if (type == Short.TYPE && value instanceof Long) {
                newValue = (short)((Long)value).longValue();
            } else if (type == Integer.TYPE && value instanceof Long) {
                newValue = (int)((Long)value).longValue();
            } else if (type == Float.TYPE && value instanceof Double) {
                newValue = Float.valueOf((float)((Double)value).doubleValue());
            } else {
                throw new RuntimeException(String.format("%s cannot be assigned to %s", value.getClass().getName(), type.getName()));
            }
            field.set(parameter, newValue);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new ReflectionException("Reflection exception", ex);
        }
    }

    @Override
    public String getDefinitionString() {
        return "InstanceVariable:" + this._fieldName;
    }
}

