/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.Bundle;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.TokenType;
import jmri.util.TypeConversionUtil;

public class ExpressionNodeIncreaseDecreaseOperator
implements ExpressionNode {
    private final ExpressionNode _exprNode;
    private final Operator _operator;

    public ExpressionNodeIncreaseDecreaseOperator(TokenType tokenType, ExpressionNode exprNode, boolean before) {
        this._exprNode = exprNode;
        if (this._exprNode == null) {
            throw new IllegalArgumentException("exprNode must not be null for operators ++ and --");
        }
        if (!this._exprNode.canBeAssigned()) {
            throw new IllegalArgumentException("exprNode must assignable");
        }
        switch (tokenType) {
            case INCREMENT: {
                this._operator = before ? Operator.PRE_INCREMENT : Operator.POST_INCREMENT;
                break;
            }
            case DECREMENT: {
                this._operator = before ? Operator.PRE_DECREMENT : Operator.POST_DECREMENT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown arithmetic operator: " + tokenType.name());
            }
        }
    }

    @Override
    public Object calculate(SymbolTable symbolTable) throws JmriException {
        Object value = this._exprNode.calculate(symbolTable);
        if (TypeConversionUtil.isIntegerNumber(value)) {
            long result;
            long v = ((Number)value).longValue();
            switch (this._operator) {
                case PRE_INCREMENT: {
                    result = ++v;
                    break;
                }
                case PRE_DECREMENT: {
                    result = --v;
                    break;
                }
                case POST_INCREMENT: {
                    result = v++;
                    break;
                }
                case POST_DECREMENT: {
                    result = v--;
                    break;
                }
                default: {
                    throw new CalculateException("Unknown operator: " + this._operator.name());
                }
            }
            this._exprNode.assignValue(symbolTable, v);
            return result;
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", value));
    }

    @Override
    public String getDefinitionString() {
        String leftOperStr = "";
        String rightOperStr = "";
        switch (this._operator) {
            case PRE_INCREMENT: {
                leftOperStr = "++";
                break;
            }
            case PRE_DECREMENT: {
                leftOperStr = "--";
                break;
            }
            case POST_INCREMENT: {
                rightOperStr = "++";
                break;
            }
            case POST_DECREMENT: {
                rightOperStr = "--";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown operator: " + this._operator.name());
            }
        }
        String exprNodeString = this._exprNode != null ? this._exprNode.getDefinitionString() : "null";
        return String.valueOf(leftOperStr) + "(" + exprNodeString + ")" + rightOperStr;
    }

    private static enum Operator {
        PRE_INCREMENT,
        PRE_DECREMENT,
        POST_INCREMENT,
        POST_DECREMENT;

    }
}

