/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import java.util.List;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.Bundle;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.Function;
import jmri.jmrit.logixng.util.parser.FunctionManager;
import jmri.jmrit.logixng.util.parser.FunctionNotExistsException;

public class ExpressionNodeFunction
implements ExpressionNode {
    private final String _identifier;
    private final Function _function;
    private final List<ExpressionNode> _parameterList;

    public ExpressionNodeFunction(String identifier, List<ExpressionNode> parameterList) throws FunctionNotExistsException {
        this._identifier = identifier;
        this._function = InstanceManager.getDefault(FunctionManager.class).get(identifier);
        this._parameterList = parameterList;
        if (this._function == null) {
            throw new FunctionNotExistsException(Bundle.getMessage("FunctionNotExists", identifier), identifier);
        }
    }

    @Override
    public Object calculate(SymbolTable symbolTable) throws JmriException {
        return this._function.calculate(symbolTable, this._parameterList);
    }

    @Override
    public String getDefinitionString() {
        StringBuilder str = new StringBuilder();
        str.append("Function:");
        str.append(this._identifier);
        str.append("(");
        int i = 0;
        while (i < this._parameterList.size()) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this._parameterList.get(i).getDefinitionString());
            ++i;
        }
        str.append(")");
        return str.toString();
    }
}

