/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.TokenType;

public class ExpressionNodeComparingOperator
implements ExpressionNode {
    private final TokenType _tokenType;
    private final ExpressionNode _leftSide;
    private final ExpressionNode _rightSide;

    public ExpressionNodeComparingOperator(TokenType tokenType, ExpressionNode leftSide, ExpressionNode rightSide) {
        this._tokenType = tokenType;
        this._leftSide = leftSide;
        this._rightSide = rightSide;
        if (this._leftSide == null) {
            throw new IllegalArgumentException("leftSide must not be null");
        }
        if (this._rightSide == null) {
            throw new IllegalArgumentException("rightSide must not be null");
        }
        switch (this._tokenType) {
            case EQUAL: 
            case NOT_EQUAL: 
            case LESS_THAN: 
            case LESS_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_OR_EQUAL: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown comparing operator: " + this._tokenType.name());
            }
        }
    }

    public Object calculateNull(Object left, Object right) throws JmriException {
        if (left != null && right != null) {
            throw new RuntimeException("This method is only valid if left and/or right is null");
        }
        switch (this._tokenType) {
            case EQUAL: {
                if (left == right) {
                    return true;
                }
                return false;
            }
            case NOT_EQUAL: {
                if (left != right) {
                    return true;
                }
                return false;
            }
            case LESS_THAN: {
                if (left == null && right != null) {
                    return true;
                }
                return false;
            }
            case LESS_OR_EQUAL: {
                if (left == null) {
                    return true;
                }
                return false;
            }
            case GREATER_THAN: {
                if (left != null && right == null) {
                    return true;
                }
                return false;
            }
            case GREATER_OR_EQUAL: {
                if (right == null) {
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("Unknown arithmetic operator: " + this._tokenType.name());
    }

    @Override
    public Object calculate(SymbolTable symbolTable) throws JmriException {
        Object left = this._leftSide.calculate(symbolTable);
        Object right = this._rightSide.calculate(symbolTable);
        if (left == null || right == null) {
            return this.calculateNull(left, right);
        }
        if (left instanceof Boolean) {
            left = (Boolean)left != false ? 1 : 0;
        }
        if (right instanceof Boolean) {
            right = (Boolean)right != false ? 1 : 0;
        }
        if (!(left instanceof Number) && !(left instanceof String)) {
            left = left.toString();
        }
        if (!(right instanceof Number) && !(right instanceof String)) {
            right = right.toString();
        }
        if (left == null || right == null) {
            return this.calculateNull(left, right);
        }
        if (left instanceof Number && !(right instanceof Number)) {
            left = 1;
            right = 2;
        } else if (!(left instanceof Number) && right instanceof Number) {
            left = 2;
            right = 1;
        }
        if (left instanceof Double && !(right instanceof Double)) {
            right = ((Number)left).doubleValue();
        }
        if (right instanceof Double && !(left instanceof Double)) {
            left = ((Number)left).doubleValue();
        }
        if (left instanceof Long && !(right instanceof Long)) {
            right = ((Number)right).longValue();
        }
        if (right instanceof Long && !(left instanceof Long)) {
            left = ((Number)left).longValue();
        }
        if (left instanceof Number) {
            switch (this._tokenType) {
                case EQUAL: {
                    return left.equals(right);
                }
                case NOT_EQUAL: {
                    return !left.equals(right);
                }
                case LESS_THAN: {
                    if (((Number)left).doubleValue() < ((Number)right).doubleValue()) {
                        return true;
                    }
                    return false;
                }
                case LESS_OR_EQUAL: {
                    if (((Number)left).doubleValue() <= ((Number)right).doubleValue()) {
                        return true;
                    }
                    return false;
                }
                case GREATER_THAN: {
                    if (((Number)left).doubleValue() > ((Number)right).doubleValue()) {
                        return true;
                    }
                    return false;
                }
                case GREATER_OR_EQUAL: {
                    if (((Number)left).doubleValue() >= ((Number)right).doubleValue()) {
                        return true;
                    }
                    return false;
                }
            }
            throw new RuntimeException("Unknown arithmetic operator: " + this._tokenType.name());
        }
        switch (this._tokenType) {
            case EQUAL: {
                return left.equals(right);
            }
            case NOT_EQUAL: {
                return !left.equals(right);
            }
            case LESS_THAN: {
                if (((String)left).compareTo((String)right) < 0) {
                    return true;
                }
                return false;
            }
            case LESS_OR_EQUAL: {
                if (((String)left).compareTo((String)right) <= 0) {
                    return true;
                }
                return false;
            }
            case GREATER_THAN: {
                if (((String)left).compareTo((String)right) > 0) {
                    return true;
                }
                return false;
            }
            case GREATER_OR_EQUAL: {
                if (((String)left).compareTo((String)right) >= 0) {
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("Unknown comparing operator: " + this._tokenType.name());
    }

    @Override
    public String getDefinitionString() {
        String operStr;
        switch (this._tokenType) {
            case EQUAL: {
                operStr = "==";
                break;
            }
            case NOT_EQUAL: {
                operStr = "!=";
                break;
            }
            case LESS_THAN: {
                operStr = "<";
                break;
            }
            case LESS_OR_EQUAL: {
                operStr = "<=";
                break;
            }
            case GREATER_THAN: {
                operStr = ">";
                break;
            }
            case GREATER_OR_EQUAL: {
                operStr = ">=";
                break;
            }
            default: {
                throw new RuntimeException("Unknown comparing operator: " + this._tokenType.name());
            }
        }
        return "(" + this._leftSide.getDefinitionString() + ")" + operStr + "(" + this._rightSide.getDefinitionString() + ")";
    }
}

