/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import java.util.List;
import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ExpressionNodeWithParameter;
import jmri.jmrit.logixng.util.parser.FunctionNotExistsException;
import jmri.util.TypeConversionUtil;

public class ExpressionNodeArray
implements ExpressionNodeWithParameter {
    private final ExpressionNode _exprNode;

    public ExpressionNodeArray(ExpressionNode exprNode) throws FunctionNotExistsException {
        this._exprNode = exprNode;
    }

    @Override
    public Object calculate(Object parameter, SymbolTable symbolTable) throws JmriException {
        if (parameter == null) {
            throw new NullPointerException("Parameter is null");
        }
        if (!(parameter instanceof List)) {
            throw new IllegalArgumentException("Parameter is not a List");
        }
        int index = (int)TypeConversionUtil.convertToLong(this._exprNode.calculate(symbolTable));
        return ((List)parameter).get(index);
    }

    @Override
    public boolean canBeAssigned() {
        return true;
    }

    @Override
    public void assignValue(Object parameter, SymbolTable symbolTable, Object value) throws JmriException {
        if (parameter == null) {
            throw new NullPointerException("Parameter is null");
        }
        if (!(parameter instanceof List)) {
            throw new IllegalArgumentException("Parameter is not a List");
        }
        int index = (int)TypeConversionUtil.convertToLong(this._exprNode.calculate(symbolTable));
        ((List)parameter).set(index, value);
    }

    @Override
    public String getDefinitionString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this._exprNode.getDefinitionString());
        str.append("]");
        return str.toString();
    }
}

