/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.util.TypeConversionUtil;

public class ReferenceUtil {
    public static boolean isReference(String value) {
        if (value == null) {
            return false;
        }
        return value.startsWith("{") && value.endsWith("}") && value.length() > 2;
    }

    protected static String unescapeString(String value, int startIndex, int endIndex) {
        boolean escaped = false;
        StringBuilder sb = new StringBuilder();
        int i = startIndex;
        while (i < endIndex) {
            escaped = value.charAt(i) == '\\' ? !escaped : false;
            if (!escaped) {
                sb.append(value.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    protected static String getValue(String reference, int startIndex, IntRef endIndex) {
        boolean escapeFound = false;
        boolean escaped = false;
        int end = startIndex;
        while (end < reference.length() && (escaped || reference.charAt(end) != ',' && reference.charAt(end) != '[' && reference.charAt(end) != ']' && reference.charAt(end) != '{' && reference.charAt(end) != '}')) {
            if (reference.charAt(end) == '\\') {
                escaped = !escaped;
                escapeFound = true;
            } else {
                escaped = false;
            }
            ++end;
        }
        endIndex.v = end;
        if (startIndex == end) {
            throw new IllegalArgumentException("Reference '" + reference + "' is not a valid reference");
        }
        if (escapeFound) {
            return ReferenceUtil.unescapeString(reference, startIndex, end);
        }
        return reference.substring(startIndex, end);
    }

    protected static String getReferenceOrValue(SymbolTable symbolTable, String reference, int startIndex, IntRef endIndex) {
        while (startIndex < reference.length() - 1 && Character.isSpaceChar(reference.charAt(startIndex))) {
            ++startIndex;
        }
        String result = reference.charAt(startIndex) == '{' ? ReferenceUtil.getReference(symbolTable, reference, startIndex, endIndex) : ReferenceUtil.getValue(reference, startIndex, endIndex);
        while (endIndex.v < reference.length() && Character.isSpaceChar(reference.charAt(endIndex.v))) {
            ++endIndex.v;
        }
        return result;
    }

    protected static String getReference(SymbolTable symbolTable, String reference, int startIndex, IntRef endIndex) {
        if (reference.charAt(startIndex) != '{') {
            throw new IllegalArgumentException("Reference '" + reference + "' is not a valid reference");
        }
        String leftValue = ReferenceUtil.getReferenceOrValue(symbolTable, reference, ++startIndex, endIndex);
        if (endIndex.v == reference.length()) {
            throw new IllegalArgumentException("Reference '" + reference + "' is not a valid reference");
        }
        if (reference.charAt(endIndex.v) != '}' && reference.charAt(endIndex.v) != '[') {
            throw new IllegalArgumentException("Reference '" + reference + "' is not a valid reference");
        }
        ++endIndex.v;
        if (endIndex.v == reference.length() || reference.charAt(endIndex.v - 1) == '}') {
            if (symbolTable != null && symbolTable.hasValue(leftValue)) {
                return TypeConversionUtil.convertToString(symbolTable.getValue(leftValue), false);
            }
            MemoryManager memoryManager = InstanceManager.getDefault(MemoryManager.class);
            Memory m = (Memory)memoryManager.getNamedBean(leftValue.trim());
            if (m != null) {
                if (m.getValue() != null) {
                    return m.getValue().toString();
                }
                throw new IllegalArgumentException("Memory '" + leftValue + "' has no value");
            }
            throw new IllegalArgumentException("Memory '" + leftValue + "' is not found");
        }
        if (reference.charAt(endIndex.v - 1) != '[') {
            throw new IllegalArgumentException("Reference '" + reference + "' is not a valid reference");
        }
        String row = ReferenceUtil.getReferenceOrValue(symbolTable, reference, endIndex.v, endIndex);
        ++endIndex.v;
        while (endIndex.v - 2 < reference.length() && Character.isSpaceChar(reference.charAt(endIndex.v - 1))) {
            ++endIndex.v;
        }
        int lastEndIndV = endIndex.v;
        while (endIndex.v < reference.length() && Character.isSpaceChar(reference.charAt(endIndex.v))) {
            ++endIndex.v;
        }
        if (reference.charAt(lastEndIndV - 1) == ']' && reference.charAt(endIndex.v) == '}') {
            ++endIndex.v;
            NamedTableManager tableManager = InstanceManager.getDefault(NamedTableManager.class);
            NamedTable table = (NamedTable)tableManager.getNamedBean(leftValue);
            if (table != null) {
                Object cell = table.getCell(row.trim());
                return cell != null ? cell.toString() : null;
            }
            throw new IllegalArgumentException("Table '" + leftValue + "' is not found");
        }
        if (endIndex.v == reference.length() || reference.charAt(lastEndIndV - 1) != ',') {
            throw new IllegalArgumentException("Reference '" + reference + "' is not a valid reference");
        }
        String column = ReferenceUtil.getReferenceOrValue(symbolTable, reference, endIndex.v, endIndex);
        while (endIndex.v < reference.length() && Character.isSpaceChar(reference.charAt(endIndex.v))) {
            ++endIndex.v;
        }
        if (endIndex.v == reference.length() || reference.charAt(endIndex.v) != ']') {
            throw new IllegalArgumentException("Reference '" + reference + "' is not a valid reference");
        }
        if (reference.charAt(endIndex.v) == ']') {
            ++endIndex.v;
            NamedTableManager tableManager = InstanceManager.getDefault(NamedTableManager.class);
            NamedTable table = (NamedTable)tableManager.getNamedBean(leftValue);
            if (table != null) {
                Object cell = table.getCell(row.trim(), column.trim());
                while (endIndex.v < reference.length() && Character.isSpaceChar(reference.charAt(endIndex.v))) {
                    ++endIndex.v;
                }
                ++endIndex.v;
                return cell != null ? cell.toString() : null;
            }
            throw new IllegalArgumentException("Table '" + leftValue + "' is not found");
        }
        throw new IllegalArgumentException("Reference '" + reference + "' is not a valid reference");
    }

    @CheckReturnValue
    @Nonnull
    public static String getReference(SymbolTable symbolTable, String reference) {
        if (!ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("Reference '" + reference + "' is not a valid reference");
        }
        IntRef endIndex = new IntRef();
        String ref = ReferenceUtil.getReference(symbolTable, reference, 0, endIndex);
        if (endIndex.v != reference.length()) {
            throw new IllegalArgumentException("Reference '" + reference + "' is not a valid reference");
        }
        return ref;
    }

    protected static class IntRef {
        public int v;

        protected IntRef() {
        }
    }
}

