/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.swing.Timer;
import jmri.jmrit.logixng.util.Bundle;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LogixNG_Thread {
    public static final int DEFAULT_LOGIXNG_THREAD = 0;
    public static final int DEFAULT_LOGIXNG_DEBUG_THREAD = 1;
    private static final Map<Integer, LogixNG_Thread> _threads = new HashMap<Integer, LogixNG_Thread>();
    private static final Map<String, LogixNG_Thread> _threadNames = new HashMap<String, LogixNG_Thread>();
    private static int _highestThreadID = -1;
    private final int _threadID;
    private String _name;
    private volatile boolean _stopThread = false;
    private volatile boolean _threadIsStopped = false;
    private final Thread _logixNGThread;
    private boolean _threadInUse = false;
    private final BlockingQueue<ThreadEvent> _eventQueue;
    private static final Logger log = LoggerFactory.getLogger(LogixNG_Thread.class);

    public static LogixNG_Thread createNewThread(@Nonnull String name) {
        return LogixNG_Thread.createNewThread(-1, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogixNG_Thread createNewThread(int threadID, @Nonnull String name) {
        Class<LogixNG_Thread> clazz = LogixNG_Thread.class;
        synchronized (LogixNG_Thread.class) {
            if (threadID == -1) {
                threadID = ++_highestThreadID;
            } else if (threadID > _highestThreadID) {
                _highestThreadID = threadID;
            }
            if (_threads.containsKey(threadID)) {
                throw new IllegalArgumentException(String.format("Thread ID %d already exists", threadID));
            }
            if (_threadNames.containsKey(name)) {
                throw new IllegalArgumentException(String.format("Thread name %s already exists", name));
            }
            LogixNG_Thread thread = new LogixNG_Thread(threadID, name);
            _threads.put(threadID, thread);
            _threadNames.put(name, thread);
            thread._logixNGThread.start();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return thread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateNewThreadName(@Nonnull String name) {
        Class<LogixNG_Thread> clazz = LogixNG_Thread.class;
        synchronized (LogixNG_Thread.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return !_threadNames.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogixNG_Thread getThread(int threadID) {
        Class<LogixNG_Thread> clazz = LogixNG_Thread.class;
        synchronized (LogixNG_Thread.class) {
            LogixNG_Thread thread = _threads.get(threadID);
            if (thread == null) {
                switch (threadID) {
                    case 0: {
                        thread = LogixNG_Thread.createNewThread(0, Bundle.getMessage("LogixNG_Thread"));
                        break;
                    }
                    case 1: {
                        thread = LogixNG_Thread.createNewThread(1, Bundle.getMessage("LogixNG_DebugThread"));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Thread ID %d does not exists", threadID));
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return thread;
        }
    }

    public static int getThreadID(String name) {
        Class<LogixNG_Thread> clazz = LogixNG_Thread.class;
        synchronized (LogixNG_Thread.class) {
            for (LogixNG_Thread t : _threads.values()) {
                if (!name.equals(t._name)) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return t._threadID;
            }
            throw new IllegalArgumentException(String.format("Thread name \"%s\" does not exists", name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteThread(LogixNG_Thread thread) {
        Class<LogixNG_Thread> clazz = LogixNG_Thread.class;
        synchronized (LogixNG_Thread.class) {
            LogixNG_Thread aThread = _threads.get(thread._threadID);
            if (aThread == null) {
                throw new IllegalArgumentException("Thread does not exists");
            }
            if (aThread != thread) {
                throw new IllegalArgumentException("Thread ID does not match");
            }
            if (aThread._threadInUse) {
                throw new IllegalArgumentException("Thread is in use");
            }
            _threads.remove(thread._threadID);
            _threadNames.remove(thread._name);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Collection<LogixNG_Thread> getThreads() {
        return Collections.unmodifiableCollection(_threads.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogixNG_Thread(int threadID, String name) {
        this._threadID = threadID;
        this._name = name;
        Class<LogixNG_Thread> clazz = LogixNG_Thread.class;
        synchronized (LogixNG_Thread.class) {
            this._eventQueue = new ArrayBlockingQueue<ThreadEvent>(1024);
            this._logixNGThread = new Thread(() -> {
                while (!this._stopThread) {
                    try {
                        ThreadEvent event = this._eventQueue.take();
                        if (event._lock != null) {
                            Object object = event._lock;
                            synchronized (object) {
                                if (!this._stopThread) {
                                    event._threadAction.run();
                                }
                                event._lock.notify();
                                continue;
                            }
                        }
                        event._threadAction.run();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                this._threadIsStopped = true;
            }, "JMRI LogixNGThread");
            this._logixNGThread.setDaemon(true);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public Thread getThread() {
        return this._logixNGThread;
    }

    public int getThreadId() {
        return this._threadID;
    }

    public String getThreadName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadName(@Nonnull String name) {
        if (this._name.equals(name)) {
            return;
        }
        Class<LogixNG_Thread> clazz = LogixNG_Thread.class;
        synchronized (LogixNG_Thread.class) {
            if (_threadNames.containsKey(name)) {
                throw new IllegalArgumentException(String.format("Thread name %s already exists", name));
            }
            _threadNames.remove(this._name);
            _threadNames.put(name, this);
            this._name = name;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean getThreadInUse() {
        return this._threadInUse;
    }

    public void setThreadInUse() {
        this._threadInUse = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"WA_NOT_IN_LOOP", "UW_UNCOND_WAIT"}, justification="Method runOnLogixNG() doesn't have a loop. Waiting for single possible event.The thread that is going to call notify() cannot get it's hands on the lock until wait() is called,  since the caller must first fetch the event from the event queue and the event is put on the event queue in the synchronize block.")
    public void runOnLogixNG(@Nonnull ThreadingUtil.ThreadAction ta) {
        if (this._logixNGThread != null) {
            Object lock;
            Object object = lock = new Object();
            synchronized (object) {
                this._eventQueue.add(new ThreadEvent(ta, lock));
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    log.debug("Interrupted while running on LogixNG thread");
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw new RuntimeException("LogixNG thread not started. ThreadID: " + Integer.toString(this._threadID));
    }

    public void runOnLogixNGEventually(@Nonnull ThreadingUtil.ThreadAction ta) {
        if (this._logixNGThread == null) {
            throw new RuntimeException("LogixNG thread not started");
        }
        this._eventQueue.add(new ThreadEvent(ta));
    }

    @Nonnull
    public Timer runOnLogixNGDelayed(@Nonnull ThreadingUtil.ThreadAction ta, int delay) {
        if (this._logixNGThread != null) {
            Timer timer = new Timer(delay, e -> this._eventQueue.add(new ThreadEvent(ta)));
            timer.setRepeats(false);
            timer.start();
            return timer;
        }
        throw new RuntimeException("LogixNG thread not started");
    }

    public boolean isLogixNGThread() {
        if (this._logixNGThread != null) {
            return this._logixNGThread == Thread.currentThread();
        }
        throw new RuntimeException("LogixNG thread not started");
    }

    public void checkIsLogixNGThread() {
        if (log.isDebugEnabled() && !this.isLogixNGThread()) {
            LoggingUtil.warnOnce(log, "checkIsLogixNGThread() called on wrong thread", new Exception());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopLogixNGThread() {
        Class<LogixNG_Thread> clazz = LogixNG_Thread.class;
        synchronized (LogixNG_Thread.class) {
            if (this._logixNGThread != null) {
                this._stopThread = true;
                this._logixNGThread.interrupt();
                try {
                    this._logixNGThread.join(0L);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("stopLogixNGThread() was interrupted");
                }
                if (this._logixNGThread.getState() != Thread.State.TERMINATED) {
                    throw new RuntimeException("Could not stop logixNGThread. Current state: " + this._logixNGThread.getState().name());
                }
                _threads.remove(this._threadID);
                _threadNames.remove(this._name);
                this._stopThread = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAllLogixNGThreads() {
        Class<LogixNG_Thread> clazz = LogixNG_Thread.class;
        synchronized (LogixNG_Thread.class) {
            ArrayList<LogixNG_Thread> list = new ArrayList<LogixNG_Thread>(_threads.values());
            for (LogixNG_Thread thread : list) {
                thread.stopLogixNGThread();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertLogixNGThreadNotRunning() {
        Class<LogixNG_Thread> clazz = LogixNG_Thread.class;
        synchronized (LogixNG_Thread.class) {
            boolean aThreadIsRunning = false;
            for (LogixNG_Thread thread : _threads.values()) {
                if (thread._threadIsStopped) continue;
                aThreadIsRunning = true;
                thread.stopLogixNGThread();
            }
            if (aThreadIsRunning) {
                throw new RuntimeException("logixNGThread is running");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class ThreadEvent {
        private final ThreadingUtil.ThreadAction _threadAction;
        private final Object _lock;

        public ThreadEvent(ThreadingUtil.ThreadAction threadAction) {
            this._threadAction = threadAction;
            this._lock = null;
        }

        public ThreadEvent(ThreadingUtil.ThreadAction threadAction, Object lock) {
            this._threadAction = threadAction;
            this._lock = lock;
        }
    }
}

