/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.beans.Bean;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.dispatcher.TrainInfo;
import jmri.jmrit.dispatcher.TrainInfoFile;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherActiveTrainManager
extends Bean
implements InstanceManagerAutoDefault {
    private final HashMap<String, ActiveTrain> _activeTrainMap;
    private static final Logger log = LoggerFactory.getLogger(DispatcherActiveTrainManager.class);

    public DispatcherActiveTrainManager() {
        InstanceManager.setDefault(DispatcherActiveTrainManager.class, this);
        this._activeTrainMap = new HashMap();
    }

    public List<String> getTrainInfoFileNames() {
        TrainInfoFile tiFiles = new TrainInfoFile();
        return new ArrayList<String>(Arrays.asList(tiFiles.getTrainInfoFileNames()));
    }

    public ActiveTrain getActiveTrain(String fileName) {
        log.debug("1.1 -- getActiveTrain: {}", (Object)fileName);
        if (fileName == null) {
            return null;
        }
        if (!this._activeTrainMap.containsKey(fileName)) {
            return null;
        }
        ActiveTrain currentTrain = this.getDispatcherActiveTrain(fileName);
        ActiveTrain hashTrain = this._activeTrainMap.get(fileName);
        log.debug("1.2 -- getActiveTrain: found {}, current = {}", (Object)hashTrain, (Object)currentTrain);
        if (hashTrain != null && hashTrain != currentTrain) {
            log.debug("1.3 -- getActiveTrain: Remove active train");
            this._activeTrainMap.remove(fileName);
            this.firePropertyChange("ActiveTrain", fileName, "");
            hashTrain = null;
        }
        log.debug("1.4 -- getActiveTrain: return {}", (Object)hashTrain);
        return hashTrain;
    }

    public ActiveTrain createActiveTrain(String fileName) {
        if (fileName == null) {
            return null;
        }
        ActiveTrain oldTrain = this.getActiveTrain(fileName);
        if (oldTrain != null) {
            log.warn("2.1 -- createActiveTrain: train already exists");
            return null;
        }
        DispatcherFrame df = InstanceManager.getDefault(DispatcherFrame.class);
        ActiveTrain at = null;
        int result = df.loadTrainFromTrainInfo(fileName);
        if (result == 0) {
            at = this.getDispatcherActiveTrain(fileName);
            this._activeTrainMap.put(fileName, at);
            this.firePropertyChange("ActiveTrain", "", fileName);
        }
        log.debug("2.2 -- AT is {}", (Object)at);
        return at;
    }

    public void terminateActiveTrain(String fileName) {
        if (fileName == null) {
            return;
        }
        ActiveTrain oldTrain = this.getActiveTrain(fileName);
        if (oldTrain == null) {
            return;
        }
        oldTrain.setTerminateWhenDone(true);
        oldTrain.setStatus(64);
        this._activeTrainMap.remove(fileName);
        this.firePropertyChange("ActiveTrain", fileName, "");
    }

    public ActiveTrain getDispatcherActiveTrain(String fileName) {
        log.debug("4.1 -- getDispatcherActiveTrain: {}", (Object)fileName);
        TrainInfo tif = this.getTrainInfoFile(fileName);
        if (tif == null) {
            return null;
        }
        String transitName = tif.getTransitName();
        DispatcherFrame df = InstanceManager.getDefault(DispatcherFrame.class);
        for (ActiveTrain train : df.getActiveTrainsList()) {
            if (!train.getTransitName().equals(transitName)) continue;
            log.debug("4.2 -- getDispatcherActiveTrain: file = {}, train = {}", (Object)fileName, (Object)train);
            return train;
        }
        return null;
    }

    public TrainInfo getTrainInfoFile(String fileName) {
        if (fileName == null) {
            return null;
        }
        TrainInfoFile tiFiles = new TrainInfoFile();
        try {
            return tiFiles.readTrainInfo(fileName);
        }
        catch (IOException | JDOMException throwable) {
            log.warn("Unable to read the train info file for {}", (Object)fileName);
            return null;
        }
    }
}

