/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import jmri.jmrit.logixng.tools.swing.swing.Bundle;
import jmri.util.swing.JComboBoxUtil;

public class ModuleParametersTableModel
extends AbstractTableModel {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_IS_INPUT = 1;
    public static final int COLUMN_IS_OUTPUT = 2;
    public static final int COLUMN_MENU = 3;
    private final List<DefaultSymbolTable.DefaultParameter> _parameters = new ArrayList<DefaultSymbolTable.DefaultParameter>();

    public ModuleParametersTableModel(@Nonnull Module module) {
        for (Module.Parameter v : module.getParameters()) {
            this._parameters.add(new DefaultSymbolTable.DefaultParameter(v));
        }
    }

    @Override
    public int getRowCount() {
        return this._parameters.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ColumnParameterName");
            }
            case 1: {
                return Bundle.getMessage("ColumnParameterIsInput");
            }
            case 2: {
                return Bundle.getMessage("ColumnParameterIsOutput");
            }
            case 3: {
                return Bundle.getMessage("ColumnParameterMenu");
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return Menu.class;
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex >= this._parameters.size()) {
            return;
        }
        DefaultSymbolTable.DefaultParameter parameter = this._parameters.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                parameter.setName((String)value);
                break;
            }
            case 1: {
                parameter.setIsInput((Boolean)value);
                break;
            }
            case 2: {
                parameter.setIsOutput((Boolean)value);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column");
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this._parameters.size()) {
            throw new IllegalArgumentException("Invalid row");
        }
        switch (columnIndex) {
            case 0: {
                return this._parameters.get(rowIndex).getName();
            }
            case 1: {
                return this._parameters.get(rowIndex).isInput();
            }
            case 2: {
                return this._parameters.get(rowIndex).isOutput();
            }
            case 3: {
                return Menu.Select;
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    public void setColumnForMenu(JTable table) {
        JComboBox comboBox = new JComboBox();
        table.setRowHeight(comboBox.getPreferredSize().height);
        table.getColumnModel().getColumn(3).setPreferredWidth(comboBox.getPreferredSize().width + 4);
    }

    public void add() {
        int row = this._parameters.size();
        this._parameters.add(new DefaultSymbolTable.DefaultParameter("", false, false));
        this.fireTableRowsInserted(row, row);
    }

    public List<DefaultSymbolTable.DefaultParameter> getParameters() {
        return this._parameters;
    }

    public static enum Menu {
        Select(Bundle.getMessage("TableMenuSelect")),
        Delete(Bundle.getMessage("TableMenuDelete")),
        MoveUp(Bundle.getMessage("TableMenuMoveUp")),
        MoveDown(Bundle.getMessage("TableMenuMoveDown"));

        private final String _descr;

        private Menu(String descr) {
            this._descr = descr;
        }

        public String toString() {
            return this._descr;
        }
    }

    public static class MenuCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JTable _table;
        ModuleParametersTableModel _tableModel;

        public MenuCellEditor(JTable table, ModuleParametersTableModel tableModel) {
            this._table = table;
            this._tableModel = tableModel;
        }

        @Override
        public Object getCellEditorValue() {
            return Menu.Select;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                value = Menu.Select;
            }
            if (!(value instanceof Menu)) {
                throw new IllegalArgumentException("value is not an Menu: " + value.getClass().getName());
            }
            JComboBox<Menu> menuComboBox = new JComboBox<Menu>();
            Menu[] menuArray = Menu.values();
            int n = menuArray.length;
            int n2 = 0;
            while (n2 < n) {
                Menu menu = menuArray[n2];
                if (!(menu == Menu.MoveUp && row == 0 || menu == Menu.MoveDown && row + 1 == this._tableModel._parameters.size())) {
                    menuComboBox.addItem(menu);
                }
                ++n2;
            }
            JComboBoxUtil.setupComboBoxMaxRows(menuComboBox);
            menuComboBox.setSelectedItem(value);
            menuComboBox.addActionListener(this);
            return menuComboBox;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!(event.getSource() instanceof JComboBox)) {
                throw new IllegalArgumentException("value is not an InitialValueType: " + event.getSource().getClass().getName());
            }
            JComboBox menuComboBox = (JComboBox)event.getSource();
            int row = this._table.getSelectedRow();
            Menu menu = (Menu)((Object)menuComboBox.getItemAt(menuComboBox.getSelectedIndex()));
            switch (menu) {
                case Delete: {
                    this.delete(row);
                    break;
                }
                case MoveUp: {
                    if (row <= 0) break;
                    this.moveUp(row);
                    break;
                }
                case MoveDown: {
                    if (row + 1 >= this._tableModel._parameters.size()) break;
                    this.moveUp(row + 1);
                }
            }
            if (this._tableModel._parameters.size() > 0) {
                this._table.editCellAt(row, 0);
            }
        }

        private void delete(int row) {
            this._tableModel._parameters.remove(row);
            this._tableModel.fireTableRowsDeleted(row, row);
        }

        private void moveUp(int row) {
            DefaultSymbolTable.DefaultParameter temp = (DefaultSymbolTable.DefaultParameter)this._tableModel._parameters.get(row - 1);
            this._tableModel._parameters.set(row - 1, (DefaultSymbolTable.DefaultParameter)this._tableModel._parameters.get(row));
            this._tableModel._parameters.set(row, temp);
            this._tableModel.fireTableRowsUpdated(row - 1, row);
        }
    }

    public static class MenuCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = Menu.Select;
            }
            if (!(value instanceof Menu)) {
                throw new IllegalArgumentException("value is not an Menu: " + value.getClass().getName());
            }
            this.setText(((Menu)((Object)value)).toString());
            return this;
        }
    }

    public static class TypeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private SymbolTable.InitialValueType _type;

        @Override
        public Object getCellEditorValue() {
            return this._type;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                value = SymbolTable.InitialValueType.None;
            }
            if (!(value instanceof SymbolTable.InitialValueType)) {
                throw new IllegalArgumentException("value is not an InitialValueType: " + value.getClass().getName());
            }
            JComboBox<SymbolTable.InitialValueType> typeComboBox = new JComboBox<SymbolTable.InitialValueType>();
            SymbolTable.InitialValueType[] initialValueTypeArray = SymbolTable.InitialValueType.values();
            int n = initialValueTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SymbolTable.InitialValueType type = initialValueTypeArray[n2];
                if (type.isValidAsParameter()) {
                    typeComboBox.addItem(type);
                }
                ++n2;
            }
            JComboBoxUtil.setupComboBoxMaxRows(typeComboBox);
            typeComboBox.setSelectedItem(value);
            typeComboBox.addActionListener(this);
            return typeComboBox;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!(event.getSource() instanceof JComboBox)) {
                throw new IllegalArgumentException("value is not an InitialValueType: " + event.getSource().getClass().getName());
            }
            JComboBox typeComboBox = (JComboBox)event.getSource();
            this._type = (SymbolTable.InitialValueType)((Object)typeComboBox.getItemAt(typeComboBox.getSelectedIndex()));
        }
    }

    public static class TypeCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = SymbolTable.InitialValueType.None;
            }
            if (!(value instanceof SymbolTable.InitialValueType)) {
                throw new IllegalArgumentException("value is not an InitialValueType: " + value.getClass().getName());
            }
            this.setText(((SymbolTable.InitialValueType)((Object)value)).toString());
            return this;
        }
    }
}

