/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.lang.invoke.LambdaMetafactory;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanHandleManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.Clipboard;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketOperation;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.LogixNG_UserPreferences;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.swing.SwingTools;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.jmrit.logixng.tools.swing.ClipboardEditor;
import jmri.jmrit.logixng.tools.swing.EditCommentDialog;
import jmri.jmrit.logixng.tools.swing.LocalVariableTableModel;
import jmri.jmrit.logixng.tools.swing.TreeViewer;
import jmri.jmrit.logixng.util.LogixNG_Thread;
import jmri.jmrit.logixng.util.parser.swing.FunctionsHelpDialog;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JComboBoxUtil;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeEditor
extends TreeViewer {
    private final LogixNGPreferences _prefs = InstanceManager.getDefault(LogixNGPreferences.class);
    ClipboardEditor _clipboardEditor = null;
    private JDialog _renameSocketDialog = null;
    private JDialog _selectItemTypeDialog = null;
    private JDialog _addItemDialog = null;
    private JDialog _editActionExpressionDialog = null;
    private JDialog _editLocalVariablesDialog = null;
    private JDialog _changeUsernameDialog = null;
    private final JTextField _socketNameTextField = new JTextField(20);
    private final JTextField _systemName = new JTextField(20);
    private final JTextField _addUserName = new JTextField(20);
    private final JTextField _usernameField = new JTextField(50);
    protected boolean _showReminder = false;
    private boolean _lockPopupMenu = false;
    private final Comparator<SwingConfiguratorInterface> _swingConfiguratorComboBoxComparator = (o1, o2) -> o1.toString().compareTo(o2.toString());
    private final SortedComboBoxModel<SwingConfiguratorInterface> _swingConfiguratorComboBoxModel = new SortedComboBoxModel<SwingConfiguratorInterface>(this._swingConfiguratorComboBoxComparator);
    private final JComboBox<Category> _categoryComboBox = new JComboBox();
    private final JComboBox<SwingConfiguratorInterface> _swingConfiguratorComboBox = new JComboBox<SwingConfiguratorInterface>(this._swingConfiguratorComboBoxModel);
    private final JLabel _renameSocketLabel = new JLabel(String.valueOf(Bundle.getMessage("SocketName")) + ":");
    private final JCheckBox _autoSystemName = new JCheckBox(Bundle.getMessage("LabelAutoSysName"));
    private final JLabel _sysNameLabel = new JLabel(String.valueOf(Bundle.getMessage("SystemName")) + ":");
    private final JLabel _userNameLabel = new JLabel(String.valueOf(Bundle.getMessage("UserName")) + ":");
    private final String _systemNameAuto = String.valueOf(TreeEditor.getClassName()) + ".AutoSystemName";
    private final JLabel _categoryLabel = new JLabel(String.valueOf(Bundle.getMessage("Category")) + ":");
    private final JLabel _typeLabel = new JLabel(String.valueOf(Bundle.getMessage("Type")) + ":");
    private JButton _create;
    private JButton _edit;
    private SwingConfiguratorInterface _addSwingConfiguratorInterface;
    private SwingConfiguratorInterface _addSwingConfiguratorInterfaceMaleSocket;
    private SwingConfiguratorInterface _editSwingConfiguratorInterface;
    private final List<Map.Entry<SwingConfiguratorInterface, Base>> _swingConfiguratorInterfaceList = new ArrayList<Map.Entry<SwingConfiguratorInterface, Base>>();
    private LocalVariableTableModel _localVariableTableModel;
    private final boolean _enableClipboard;
    private final boolean _disableRootRemoveCutCopy;
    private final boolean _disableRootPopup;
    private final boolean _enableExecuteEvaluate;
    private static final Logger log = LoggerFactory.getLogger(TreeEditor.class);

    public TreeEditor(@Nonnull FemaleSocket femaleRootSocket, EnableClipboard enableClipboard, EnableRootRemoveCutCopy enableRootRemoveCutCopy, EnableRootPopup enableRootPopup, EnableExecuteEvaluate enableExecuteEvaluate) {
        super(femaleRootSocket);
        this._enableClipboard = enableClipboard == EnableClipboard.EnableClipboard;
        this._disableRootRemoveCutCopy = enableRootRemoveCutCopy == EnableRootRemoveCutCopy.DisableRootRemoveCutCopy;
        this._disableRootPopup = enableRootPopup == EnableRootPopup.DisableRootPopup;
        this._enableExecuteEvaluate = enableExecuteEvaluate == EnableExecuteEvaluate.EnableExecuteEvaluate;
    }

    @Override
    public final void initComponents() {
        super.initComponents();
        JMenuBar menuBar = this.getJMenuBar();
        JMenu toolsMenu = new JMenu(Bundle.getMessage("MenuTools"));
        if (this._enableClipboard) {
            JMenuItem openClipboardItem = new JMenuItem(Bundle.getMessage("MenuOpenClipboard"));
            openClipboardItem.addActionListener(e -> this.openClipboard());
            toolsMenu.add(openClipboardItem);
        }
        menuBar.add(toolsMenu);
        PopupMenu popup = new PopupMenu();
        popup.init();
    }

    public final void openClipboard() {
        if (this._clipboardEditor == null) {
            this._clipboardEditor = new ClipboardEditor();
            this._clipboardEditor.initComponents();
            this._clipboardEditor.setVisible(true);
            this._clipboardEditor.addClipboardEventListener(() -> this._clipboardEditor.clipboardData.forEach((key, value) -> {
                if (key.equals("Finish")) {
                    this._clipboardEditor = null;
                }
            }));
        } else {
            this._clipboardEditor.setVisible(true);
        }
    }

    private static String getClassName() {
        return LogixNG_UserPreferences.class.getName();
    }

    private void runOnConditionalNGThreadOrGUIThreadEventually(ConditionalNG conditionalNG, ThreadingUtil.ThreadAction ta) {
        if (conditionalNG != null) {
            LogixNG_Thread thread = conditionalNG.getCurrentThread();
            thread.runOnLogixNGEventually(ta);
        } else {
            ta.run();
        }
    }

    protected final boolean isPopupMenuLocked() {
        if (this._lockPopupMenu) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("TreeEditor_PopupLockMessage"), Bundle.getMessage("TreeEditor_PopupLockTitle"), 1);
        }
        return this._lockPopupMenu;
    }

    protected final void setPopupMenuLock(boolean lock) {
        this._lockPopupMenu = lock;
    }

    protected final void renameSocketPressed(FemaleSocket femaleSocket, TreePath path) {
        this.setPopupMenuLock(true);
        this._renameSocketDialog = new JDialog(this, Bundle.getMessage("RenameSocketDialogTitle", femaleSocket.getLongDescription()), false);
        this._renameSocketDialog.setLocation(50, 30);
        Container contentPanel = this._renameSocketDialog.getContentPane();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        p.add((Component)this._renameSocketLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        p.add((Component)this._socketNameTextField, c);
        this._socketNameTextField.setText(femaleSocket.getName());
        contentPanel.add(p);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(cancel);
        cancel.addActionListener(e -> this.cancelRenameSocketPressed(null));
        cancel.setToolTipText("CancelLogixButtonHint");
        this._renameSocketDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TreeEditor.this.cancelRenameSocketPressed(null);
            }
        });
        this._create = new JButton(Bundle.getMessage("ButtonOK"));
        panel5.add(this._create);
        this._create.addActionListener(e -> {
            if (femaleSocket.validateName(this._socketNameTextField.getText())) {
                femaleSocket.setName(this._socketNameTextField.getText());
                this.cancelRenameSocketPressed(null);
                for (TreeModelListener l : this._treePane.femaleSocketTreeModel.listeners) {
                    TreeModelEvent tme = new TreeModelEvent((Object)femaleSocket, path.getPath());
                    l.treeNodesChanged(tme);
                }
                this._treePane._tree.updateUI();
                this.setPopupMenuLock(false);
            } else {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("ValidateFemaleSocketMessage", this._socketNameTextField.getText()), Bundle.getMessage("ValidateFemaleSocketTitle"), 0);
            }
        });
        contentPanel.add(panel5);
        this._renameSocketDialog.setLocationRelativeTo(null);
        this._renameSocketDialog.pack();
        this._renameSocketDialog.setVisible(true);
    }

    protected final void addPressed(FemaleSocket femaleSocket, TreePath path) {
        this.setPopupMenuLock(true);
        Map<Category, List<Class<? extends Base>>> connectableClasses = femaleSocket.getConnectableClasses();
        this._categoryComboBox.removeAllItems();
        ArrayList<Category> list = new ArrayList<Category>(connectableClasses.keySet());
        Collections.sort(list);
        for (Category item : list) {
            this._categoryComboBox.addItem(item);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._categoryComboBox);
        ItemListener[] itemListenerArray = this._categoryComboBox.getItemListeners();
        int n = itemListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemListener l = itemListenerArray[n2];
            this._categoryComboBox.removeItemListener(l);
            ++n2;
        }
        this._categoryComboBox.addItemListener(e -> {
            Category category = this._categoryComboBox.getItemAt(this._categoryComboBox.getSelectedIndex());
            this._swingConfiguratorComboBox.removeAllItems();
            List classes = (List)connectableClasses.get(category);
            if (classes != null) {
                for (Class clazz : classes) {
                    SwingConfiguratorInterface sci = SwingTools.getSwingConfiguratorForClass(clazz);
                    if (sci != null) {
                        this._swingConfiguratorComboBox.addItem(sci);
                        continue;
                    }
                    log.error("Class {} has no swing configurator interface", (Object)clazz.getName());
                }
                JComboBoxUtil.setupComboBoxMaxRows(this._swingConfiguratorComboBox);
            }
        });
        this._categoryComboBox.setSelectedIndex(-1);
        if (this._categoryComboBox.getItemCount() > 0) {
            this._categoryComboBox.setSelectedIndex(0);
        }
        this._selectItemTypeDialog = new JDialog(this, Bundle.getMessage("AddMaleSocketDialogTitle", femaleSocket.getLongDescription()), false);
        this._selectItemTypeDialog.setLocation(50, 30);
        Container contentPanel = this._selectItemTypeDialog.getContentPane();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        p.add((Component)this._categoryLabel, c);
        c.gridy = 1;
        p.add((Component)this._typeLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        p.add(this._categoryComboBox, c);
        c.gridy = 1;
        p.add(this._swingConfiguratorComboBox, c);
        this._categoryComboBox.setToolTipText(Bundle.getMessage("CategoryNamesHint"));
        this._swingConfiguratorComboBox.setToolTipText(Bundle.getMessage("TypeNamesHint"));
        contentPanel.add(p);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        contentPanel.add(panel3);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(cancel);
        cancel.addActionListener(e -> {
            this.cancelAddPressed(null);
            this.setPopupMenuLock(false);
        });
        cancel.setToolTipText("CancelLogixButtonHint");
        this._selectItemTypeDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TreeEditor.this.cancelAddPressed(null);
                TreeEditor.this.setPopupMenuLock(false);
            }
        });
        this._create = new JButton(Bundle.getMessage("ButtonCreate"));
        panel5.add(this._create);
        this._create.addActionListener(e -> {
            this.cancelAddPressed(null);
            SwingConfiguratorInterface swingConfiguratorInterface = this._swingConfiguratorComboBox.getItemAt(this._swingConfiguratorComboBox.getSelectedIndex());
            this.createAddFrame(femaleSocket, path, swingConfiguratorInterface);
        });
        contentPanel.add(panel5);
        this._autoSystemName.addItemListener(e -> this.autoSystemName());
        this._selectItemTypeDialog.setLocationRelativeTo(null);
        this._selectItemTypeDialog.pack();
        this._selectItemTypeDialog.setVisible(true);
    }

    protected final void createAddFrame(FemaleSocket femaleSocket, TreePath path, SwingConfiguratorInterface swingConfiguratorInterface) {
        this._showReminder = true;
        if (this._addItemDialog == null) {
            MutableObject commentStr = new MutableObject();
            this._addSwingConfiguratorInterface = swingConfiguratorInterface;
            this._create = new JButton(Bundle.getMessage("ButtonCreate"));
            this._create.addActionListener(e -> {
                this._treePane._femaleRootSocket.unregisterListeners();
                this.runOnConditionalNGThreadOrGUIThreadEventually(this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    boolean isValid = true;
                    if (!this._prefs.getShowSystemUserNames() || this._systemName.getText().isEmpty() && this._autoSystemName.isSelected()) {
                        this._systemName.setText(this._addSwingConfiguratorInterface.getAutoSystemName());
                    }
                    if (this._addSwingConfiguratorInterface.getManager().validSystemNameFormat(this._systemName.getText()) != Manager.NameValidity.VALID) {
                        isValid = false;
                        errorMessages.add(Bundle.getMessage("InvalidSystemName", this._systemName.getText()));
                    }
                    if (isValid &= this._addSwingConfiguratorInterface.validate(errorMessages)) {
                        MaleSocket socket = this._addUserName.getText().isEmpty() ? this._addSwingConfiguratorInterface.createNewObject(this._systemName.getText(), null) : this._addSwingConfiguratorInterface.createNewObject(this._systemName.getText(), this._addUserName.getText());
                        this._addSwingConfiguratorInterfaceMaleSocket.updateObject(socket);
                        socket.setComment((String)commentStr.getValue());
                        try {
                            femaleSocket.connect(socket);
                        }
                        catch (SocketAlreadyConnectedException ex) {
                            throw new RuntimeException(ex);
                        }
                        femaleSocket.forEntireTree(b -> b.addPropertyChangeListener(this._treePane));
                        ThreadingUtil.runOnGUIEventually(() -> {
                            this._addSwingConfiguratorInterface.dispose();
                            this._addItemDialog.dispose();
                            this._addItemDialog = null;
                            for (TreeModelListener l : this._treePane.femaleSocketTreeModel.listeners) {
                                TreeModelEvent tme = new TreeModelEvent((Object)femaleSocket, path.getPath());
                                l.treeNodesChanged(tme);
                            }
                            this._treePane._tree.expandPath(path);
                            this._treePane._tree.updateUI();
                            InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setCheckboxPreferenceState(this._systemNameAuto, this._autoSystemName.isSelected()));
                        });
                        this.setPopupMenuLock(false);
                    } else {
                        StringBuilder errorMsg = new StringBuilder();
                        for (String s : errorMessages) {
                            if (errorMsg.length() > 0) {
                                errorMsg.append("<br>");
                            }
                            errorMsg.append(s);
                        }
                        JOptionPane.showMessageDialog(null, Bundle.getMessage("ValidateErrorMessage", errorMsg), Bundle.getMessage("ValidateErrorTitle"), 0);
                    }
                    ThreadingUtil.runOnGUIEventually(() -> {
                        if (this._treePane._femaleRootSocket.isActive()) {
                            this._treePane._femaleRootSocket.registerListeners();
                        }
                    });
                });
            });
            this._create.setToolTipText(Bundle.getMessage("CreateButtonHint"));
            if (this._addSwingConfiguratorInterface != null) {
                this.makeAddEditFrame(true, femaleSocket, this._create, (MutableObject<String>)commentStr);
            }
        }
    }

    protected final void editPressed(FemaleSocket femaleSocket, TreePath path) {
        this.setPopupMenuLock(true);
        this._showReminder = true;
        if (this._editActionExpressionDialog == null) {
            Base object = femaleSocket.getConnectedSocket().getObject();
            MutableObject commentStr = new MutableObject((Object)object.getComment());
            this._edit = new JButton(Bundle.getMessage("ButtonOK"));
            this._edit.addActionListener(e -> this.runOnConditionalNGThreadOrGUIThreadEventually(this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                ArrayList<String> errorMessages = new ArrayList<String>();
                boolean isValid = true;
                if (this._editSwingConfiguratorInterface.getManager() != null) {
                    if (this._editSwingConfiguratorInterface.getManager().validSystemNameFormat(this._systemName.getText()) != Manager.NameValidity.VALID) {
                        isValid = false;
                        errorMessages.add(Bundle.getMessage("InvalidSystemName", this._systemName.getText()));
                    }
                } else {
                    log.debug("_editSwingConfiguratorInterface.getManager() returns null");
                }
                if (isValid &= this._editSwingConfiguratorInterface.validate(errorMessages)) {
                    ThreadingUtil.runOnGUIEventually(() -> {
                        femaleSocket.unregisterListeners();
                        if (this._addUserName.getText().isEmpty()) {
                            ((NamedBean)((Object)object)).setUserName(null);
                        } else {
                            ((NamedBean)((Object)object)).setUserName(this._addUserName.getText());
                        }
                        ((NamedBean)((Object)object)).setComment((String)commentStr.getValue());
                        for (Map.Entry<SwingConfiguratorInterface, Base> entry : this._swingConfiguratorInterfaceList) {
                            entry.getKey().updateObject(entry.getValue());
                            entry.getKey().dispose();
                        }
                        for (TreeModelListener l : this._treePane.femaleSocketTreeModel.listeners) {
                            TreeModelEvent tme = new TreeModelEvent((Object)femaleSocket, path.getPath());
                            l.treeNodesChanged(tme);
                        }
                        this._editActionExpressionDialog.dispose();
                        this._editActionExpressionDialog = null;
                        this._treePane._tree.updateUI();
                        if (this._treePane._femaleRootSocket.isActive()) {
                            this._treePane._femaleRootSocket.registerListeners();
                        }
                    });
                    this.setPopupMenuLock(false);
                } else {
                    StringBuilder errorMsg = new StringBuilder();
                    for (String s : errorMessages) {
                        if (errorMsg.length() > 0) {
                            errorMsg.append("<br>");
                        }
                        errorMsg.append(s);
                    }
                    ThreadingUtil.runOnGUIEventually(() -> JOptionPane.showMessageDialog(null, Bundle.getMessage("ValidateErrorMessage", errorMsg), Bundle.getMessage("ValidateErrorTitle"), 0));
                }
            }));
            this._edit.setToolTipText(Bundle.getMessage("EditButtonHint"));
            this.makeAddEditFrame(false, femaleSocket, this._edit, (MutableObject<String>)commentStr);
        }
    }

    protected final void makeAddEditFrame(final boolean addOrEdit, FemaleSocket femaleSocket, JButton button, MutableObject<String> commentStr) {
        JDialog frame = new JDialog(this, Bundle.getMessage(addOrEdit ? "AddMaleSocketDialogTitle" : "EditMaleSocketDialogTitle", femaleSocket.getLongDescription()), false);
        Container contentPanel = frame.getContentPane();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        if (this._prefs.getShowSystemUserNames()) {
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 13;
            p.add((Component)this._sysNameLabel, c);
            c.gridy = 1;
            p.add((Component)this._userNameLabel, c);
            c.gridy = 2;
            c.gridx = 1;
            c.gridy = 0;
            c.anchor = 17;
            c.weightx = 1.0;
            c.fill = 2;
            p.add((Component)this._systemName, c);
            c.gridy = 1;
            p.add((Component)this._addUserName, c);
            if (!femaleSocket.isConnected()) {
                c.gridx = 2;
                c.gridy = 1;
                c.anchor = 17;
                c.weightx = 1.0;
                c.fill = 2;
                c.gridy = 0;
                p.add((Component)this._autoSystemName, c);
            }
            if (addOrEdit) {
                this._systemName.setToolTipText(Bundle.getMessage("SystemNameHint", this._addSwingConfiguratorInterface.getExampleSystemName()));
                this._addUserName.setToolTipText(Bundle.getMessage("UserNameHint"));
            }
        } else {
            c.gridx = 0;
            c.gridy = 0;
        }
        contentPanel.add(p);
        if (femaleSocket.isConnected()) {
            this._systemName.setText(femaleSocket.getConnectedSocket().getSystemName());
            this._systemName.setEnabled(false);
            this._addUserName.setText(femaleSocket.getConnectedSocket().getUserName());
        } else {
            this._systemName.setText("");
            this._systemName.setEnabled(true);
            this._addUserName.setText("");
        }
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        Base object = null;
        this._swingConfiguratorInterfaceList.clear();
        ArrayList<JPanel> panels = new ArrayList<JPanel>();
        if (femaleSocket.isConnected()) {
            object = femaleSocket.getConnectedSocket();
            while (object instanceof MaleSocket) {
                SwingConfiguratorInterface swi = SwingTools.getSwingConfiguratorForClass(object.getClass());
                panels.add(swi.getConfigPanel(object, panel5));
                this._swingConfiguratorInterfaceList.add(new AbstractMap.SimpleEntry<SwingConfiguratorInterface, MaleSocket>(swi, (MaleSocket)object));
                object = object.getObject();
            }
            if (object != null) {
                this._editSwingConfiguratorInterface = SwingTools.getSwingConfiguratorForClass(object.getClass());
                panels.add(this._editSwingConfiguratorInterface.getConfigPanel(object, panel5));
                this._swingConfiguratorInterfaceList.add(new AbstractMap.SimpleEntry<SwingConfiguratorInterface, MaleSocket>(this._editSwingConfiguratorInterface, (MaleSocket)object));
            } else {
                JPanel panel = new JPanel();
                panel.add(new JLabel("Error: femaleSocket.getConnectedSocket().getObject().getObject()....getObject() doesn't return a non MaleSocket"));
                panels.add(panel);
                log.error("femaleSocket.getConnectedSocket().getObject().getObject()....getObject() doesn't return a non MaleSocket");
            }
        } else {
            Class<MaleSocket> maleSocketClass = this._addSwingConfiguratorInterface.getManager().getMaleSocketClass();
            this._addSwingConfiguratorInterfaceMaleSocket = SwingTools.getSwingConfiguratorForClass(maleSocketClass);
            panels.add(this._addSwingConfiguratorInterfaceMaleSocket.getConfigPanel(panel5));
            panels.add(this._addSwingConfiguratorInterface.getConfigPanel(panel5));
        }
        JPanel panel34 = new JPanel();
        panel34.setLayout(new BoxLayout(panel34, 1));
        int i = panels.size() - 1;
        while (i >= 0) {
            JPanel panel = (JPanel)panels.get(i);
            if (panel.getComponentCount() > 0) {
                panel34.add(Box.createVerticalStrut(30));
                panel34.add(panel);
            }
            --i;
        }
        panel3.add(panel34);
        contentPanel.add(panel3);
        JButton editComment = new JButton(Bundle.getMessage("ButtonEditComment"));
        panel5.add(editComment);
        String comment = object != null ? object.getComment() : "";
        editComment.addActionListener(e -> commentStr.setValue((Object)new EditCommentDialog().showDialog(comment)));
        JButton showFunctionHelp = new JButton(Bundle.getMessage("ButtonFunctionHelp"));
        panel5.add(showFunctionHelp);
        showFunctionHelp.addActionListener(e -> InstanceManager.getDefault(FunctionsHelpDialog.class).showDialog());
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(cancel);
        cancel.addActionListener(e -> {
            if (!femaleSocket.isConnected()) {
                this.cancelCreateItem(null);
            } else {
                this.cancelEditPressed(null);
            }
        });
        cancel.setToolTipText("CancelLogixButtonHint");
        panel5.add(button);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (addOrEdit) {
                    TreeEditor.this.cancelCreateItem(null);
                } else {
                    TreeEditor.this.cancelEditPressed(null);
                }
            }
        });
        contentPanel.add(panel5);
        this._autoSystemName.addItemListener(e -> this.autoSystemName());
        frame.pack();
        frame.setLocationRelativeTo(null);
        if (addOrEdit) {
            this._addItemDialog = frame;
        } else {
            this._editActionExpressionDialog = frame;
        }
        this._autoSystemName.setSelected(true);
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> this._autoSystemName.setSelected(prefMgr.getCheckboxPreferenceState(this._systemNameAuto, true)));
        frame.setVisible(true);
    }

    protected final void editLocalVariables(FemaleSocket femaleSocket, TreePath path) {
        this._showReminder = true;
        this.setPopupMenuLock(true);
        if (this._editLocalVariablesDialog == null) {
            MaleSocket maleSocket = femaleSocket.getConnectedSocket();
            this._edit = new JButton(Bundle.getMessage("ButtonOK"));
            this._edit.addActionListener(e -> {
                ArrayList<String> errorMessages = new ArrayList<String>();
                boolean hasErrors = false;
                for (SymbolTable.VariableData v : this._localVariableTableModel.getVariables()) {
                    if (v.getName().isEmpty()) {
                        errorMessages.add(Bundle.getMessage("VariableNameIsEmpty", v.getName()));
                        hasErrors = true;
                    }
                    if (SymbolTable.validateName(v.getName())) continue;
                    errorMessages.add(Bundle.getMessage("VariableNameIsNotValid", v.getName()));
                    hasErrors = true;
                }
                if (hasErrors) {
                    StringBuilder errorMsg = new StringBuilder();
                    for (String s : errorMessages) {
                        if (errorMsg.length() > 0) {
                            errorMsg.append("<br>");
                        }
                        errorMsg.append(s);
                    }
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("ValidateErrorMessage", errorMsg), Bundle.getMessage("ValidateErrorTitle"), 0);
                } else {
                    this._treePane._femaleRootSocket.unregisterListeners();
                    this.runOnConditionalNGThreadOrGUIThreadEventually(this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                        maleSocket.clearLocalVariables();
                        for (SymbolTable.VariableData variableData : this._localVariableTableModel.getVariables()) {
                            maleSocket.addLocalVariable(variableData);
                        }
                        ThreadingUtil.runOnGUIEventually(() -> {
                            this._editLocalVariablesDialog.dispose();
                            this._editLocalVariablesDialog = null;
                            if (this._treePane._femaleRootSocket.isActive()) {
                                this._treePane._femaleRootSocket.registerListeners();
                            }
                            for (TreeModelListener l : this._treePane.femaleSocketTreeModel.listeners) {
                                TreeModelEvent tme = new TreeModelEvent((Object)femaleSocket, path.getPath());
                                l.treeNodesChanged(tme);
                            }
                            this._treePane._tree.updateUI();
                        });
                        this.setPopupMenuLock(false);
                    });
                }
            });
            this._editLocalVariablesDialog = new JDialog(this, Bundle.getMessage("EditLocalVariablesDialogTitle", femaleSocket.getLongDescription()), false);
            Container contentPanel = this._editLocalVariablesDialog.getContentPane();
            contentPanel.setLayout(new BoxLayout(contentPanel, 1));
            JPanel tablePanel = new JPanel();
            JTable table = new JTable();
            this._localVariableTableModel = new LocalVariableTableModel(maleSocket);
            table.setModel(this._localVariableTableModel);
            table.setDefaultRenderer(SymbolTable.InitialValueType.class, new LocalVariableTableModel.TypeCellRenderer());
            table.setDefaultEditor(SymbolTable.InitialValueType.class, new LocalVariableTableModel.TypeCellEditor());
            table.setDefaultRenderer(LocalVariableTableModel.Menu.class, new LocalVariableTableModel.MenuCellRenderer());
            table.setDefaultEditor(LocalVariableTableModel.Menu.class, new LocalVariableTableModel.MenuCellEditor(table, this._localVariableTableModel));
            this._localVariableTableModel.setColumnForMenu(table);
            JScrollPane scrollpane = new JScrollPane(table);
            scrollpane.setPreferredSize(new Dimension(400, 200));
            tablePanel.add((Component)scrollpane, "Center");
            contentPanel.add(tablePanel);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout());
            JButton showFunctionHelp = new JButton(Bundle.getMessage("ButtonFunctionHelp"));
            buttonPanel.add(showFunctionHelp);
            showFunctionHelp.addActionListener(e -> InstanceManager.getDefault(FunctionsHelpDialog.class).showDialog());
            JButton add = new JButton(Bundle.getMessage("TableAddVariable"));
            buttonPanel.add(add);
            add.addActionListener(e -> this._localVariableTableModel.add());
            JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
            buttonPanel.add(cancel);
            cancel.addActionListener(e -> {
                this._editLocalVariablesDialog.setVisible(false);
                this._editLocalVariablesDialog.dispose();
                this._editLocalVariablesDialog = null;
                this.setPopupMenuLock(false);
            });
            cancel.setToolTipText("CancelLogixButtonHint");
            buttonPanel.add(this._edit);
            this._editLocalVariablesDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TreeEditor.this._editLocalVariablesDialog.setVisible(false);
                    TreeEditor.this._editLocalVariablesDialog.dispose();
                    TreeEditor.this._editLocalVariablesDialog = null;
                    TreeEditor.this.setPopupMenuLock(false);
                }
            });
            contentPanel.add(buttonPanel);
            this._autoSystemName.addItemListener(e -> this.autoSystemName());
            this._editLocalVariablesDialog.pack();
            this._editLocalVariablesDialog.setLocationRelativeTo(null);
            this._editLocalVariablesDialog.setVisible(true);
        }
    }

    protected final void changeUsername(FemaleSocket femaleSocket, TreePath path) {
        this._showReminder = true;
        this.setPopupMenuLock(true);
        if (this._changeUsernameDialog == null) {
            MaleSocket maleSocket = femaleSocket.getConnectedSocket();
            this._edit = new JButton(Bundle.getMessage("ButtonOK"));
            this._edit.addActionListener(e -> {
                boolean hasErrors = false;
                if (hasErrors) {
                    String errorMsg = "";
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("ValidateErrorMessage", errorMsg), Bundle.getMessage("ValidateErrorTitle"), 0);
                } else {
                    this._treePane._femaleRootSocket.unregisterListeners();
                    this.runOnConditionalNGThreadOrGUIThreadEventually(this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                        String username = this._usernameField.getText();
                        if (username.equals("")) {
                            username = null;
                        }
                        if (username == null && maleSocket.getUserName() != null || username != null && !username.equals(maleSocket.getUserName())) {
                            String msg;
                            int optionPane;
                            Object nB;
                            if (username != null && (nB = maleSocket.getManager().getByUserName(username)) != null) {
                                String uname = username;
                                ThreadingUtil.runOnGUIEventually(() -> {
                                    log.error("User name is not unique {}", (Object)uname);
                                    String msg = Bundle.getMessage("WarningUserName", uname);
                                    JOptionPane.showMessageDialog(null, msg, Bundle.getMessage("WarningTitle"), 0);
                                });
                                username = null;
                            }
                            maleSocket.setUserName(username);
                            MaleSocket m = maleSocket;
                            while (!(m instanceof NamedBean)) {
                                m = (MaleSocket)m.getObject();
                            }
                            NamedBeanHandleManager nbMan = InstanceManager.getDefault(NamedBeanHandleManager.class);
                            if (nbMan.inUse(maleSocket.getSystemName(), (NamedBean)((Object)m)) && (optionPane = JOptionPane.showConfirmDialog(null, msg = Bundle.getMessage("UpdateToUserName", maleSocket.getManager().getBeanTypeHandled(), username, maleSocket.getSystemName()), Bundle.getMessage("UpdateToUserNameTitle"), 0)) == 0) {
                                try {
                                    nbMan.updateBeanFromSystemToUser((NamedBean)((Object)m));
                                }
                                catch (JmriException ex) {
                                    log.error("Impossible exception setting user name", (Throwable)ex);
                                }
                            }
                        }
                        ThreadingUtil.runOnGUIEventually(() -> {
                            if (this._treePane._femaleRootSocket.isActive()) {
                                this._treePane._femaleRootSocket.registerListeners();
                            }
                            this._changeUsernameDialog.dispose();
                            this._changeUsernameDialog = null;
                            for (TreeModelListener l : this._treePane.femaleSocketTreeModel.listeners) {
                                TreeModelEvent tme = new TreeModelEvent((Object)femaleSocket, path.getPath());
                                l.treeNodesChanged(tme);
                            }
                            this._treePane._tree.updateUI();
                        });
                        this.setPopupMenuLock(false);
                    });
                }
            });
            this._changeUsernameDialog = new JDialog(this, Bundle.getMessage("EditLocalVariablesDialogTitle", femaleSocket.getLongDescription()), false);
            Container contentPanel = this._changeUsernameDialog.getContentPane();
            contentPanel.setLayout(new BoxLayout(contentPanel, 1));
            JLabel usernameLabel = new JLabel("Username");
            this._usernameField.setText(maleSocket.getUserName());
            contentPanel.add(usernameLabel);
            contentPanel.add(this._usernameField);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout());
            JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
            buttonPanel.add(cancel);
            cancel.addActionListener(e -> {
                this._changeUsernameDialog.setVisible(false);
                this._changeUsernameDialog.dispose();
                this._changeUsernameDialog = null;
                this.setPopupMenuLock(false);
            });
            cancel.setToolTipText("CancelLogixButtonHint");
            buttonPanel.add(this._edit);
            this._changeUsernameDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TreeEditor.this._changeUsernameDialog.setVisible(false);
                    TreeEditor.this._changeUsernameDialog.dispose();
                    TreeEditor.this._changeUsernameDialog = null;
                    TreeEditor.this.setPopupMenuLock(false);
                }
            });
            contentPanel.add(buttonPanel);
            this._autoSystemName.addItemListener(e -> this.autoSystemName());
            this._changeUsernameDialog.pack();
            this._changeUsernameDialog.setLocationRelativeTo(null);
            this._changeUsernameDialog.setVisible(true);
        }
    }

    protected final void autoSystemName() {
        if (this._autoSystemName.isSelected()) {
            this._systemName.setEnabled(false);
            this._sysNameLabel.setEnabled(false);
        } else {
            this._systemName.setEnabled(true);
            this._sysNameLabel.setEnabled(true);
        }
    }

    protected final void cancelRenameSocketPressed(ActionEvent e) {
        this._renameSocketDialog.setVisible(false);
        this._renameSocketDialog.dispose();
        this._renameSocketDialog = null;
        this.setPopupMenuLock(false);
        this.setVisible(true);
    }

    protected final void cancelAddPressed(ActionEvent e) {
        this._selectItemTypeDialog.setVisible(false);
        this._selectItemTypeDialog.dispose();
        this._selectItemTypeDialog = null;
        this.setVisible(true);
    }

    protected final void cancelCreateItem(ActionEvent e) {
        this._addItemDialog.setVisible(false);
        this._addSwingConfiguratorInterface.dispose();
        this._addItemDialog.dispose();
        this._addItemDialog = null;
        this.setPopupMenuLock(false);
        this.setVisible(true);
    }

    protected final void cancelEditPressed(ActionEvent e) {
        this._editActionExpressionDialog.setVisible(false);
        for (Map.Entry<SwingConfiguratorInterface, Base> entry : this._swingConfiguratorInterfaceList) {
            entry.getKey().dispose();
        }
        this._editActionExpressionDialog.dispose();
        this._editActionExpressionDialog = null;
        this.setPopupMenuLock(false);
        this.setVisible(true);
    }

    protected void executeEvaluate(SwingConfiguratorInterface swi, MaleSocket maleSocket) {
        swi.executeEvaluate(maleSocket);
    }

    static /* synthetic */ boolean access$1(TreeEditor treeEditor) {
        return treeEditor._disableRootPopup;
    }

    static /* synthetic */ boolean access$2(TreeEditor treeEditor) {
        return treeEditor._disableRootRemoveCutCopy;
    }

    private class DeleteBeanWorker
    extends SwingWorker<Void, Void> {
        private final FemaleSocket _currentFemaleSocket;
        private final TreePath _currentPath;
        MaleSocket _maleSocket;

        public DeleteBeanWorker(FemaleSocket currentFemaleSocket, TreePath currentPath) {
            this._currentFemaleSocket = currentFemaleSocket;
            this._currentPath = currentPath;
            this._maleSocket = this._currentFemaleSocket.getConnectedSocket();
        }

        public int getDisplayDeleteMsg() {
            return InstanceManager.getDefault(UserPreferencesManager.class).getMultipleChoiceOption(TreeEditor.getClassName(), "deleteInUse");
        }

        public void setDisplayDeleteMsg(int boo) {
            InstanceManager.getDefault(UserPreferencesManager.class).setMultipleChoiceOption(TreeEditor.getClassName(), "deleteInUse", boo);
        }

        public void doDelete() {
            try {
                this._currentFemaleSocket.disconnect();
                this._maleSocket.getManager().deleteBean(this._maleSocket, "DoDelete");
            }
            catch (PropertyVetoException e) {
                log.error(e.getMessage());
            }
        }

        @Override
        public Void doInBackground() {
            TreeEditor.this._treePane._femaleRootSocket.unregisterListeners();
            StringBuilder message = new StringBuilder();
            try {
                this._maleSocket.getManager().deleteBean(this._maleSocket, "CanDelete");
            }
            catch (PropertyVetoException e2) {
                if (e2.getPropertyChangeEvent().getPropertyName().equals("DoNotDelete")) {
                    log.warn(e2.getMessage());
                    message.append(Bundle.getMessage("VetoDeleteBean", ((NamedBean)((Object)this._maleSocket.getObject())).getBeanType(), ((NamedBean)((Object)this._maleSocket.getObject())).getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME), e2.getMessage()));
                    JOptionPane.showMessageDialog(null, message.toString(), Bundle.getMessage("WarningTitle"), 0);
                    return null;
                }
                message.append(e2.getMessage());
            }
            ArrayList<String> listenerRefs = new ArrayList<String>();
            this._maleSocket.getListenerRefsIncludingChildren(listenerRefs);
            int count = listenerRefs.size();
            log.debug("Delete with {}", (Object)count);
            if (this.getDisplayDeleteMsg() == 2 && message.toString().isEmpty()) {
                this.doDelete();
            } else {
                String prompt;
                JDialog dialog = new JDialog();
                dialog.setTitle(Bundle.getMessage("WarningTitle"));
                dialog.setDefaultCloseOperation(2);
                JPanel container = new JPanel();
                container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                container.setLayout(new BoxLayout(container, 1));
                if (count > 0) {
                    prompt = this._maleSocket.getChildCount() > 0 ? "DeleteWithChildrenPrompt" : "DeletePrompt";
                    JLabel question = new JLabel(Bundle.getMessage(prompt, ((NamedBean)((Object)this._maleSocket.getObject())).getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME)));
                    question.setAlignmentX(0.5f);
                    container.add(question);
                    ArrayList<String> tempListenerRefs = new ArrayList<String>();
                    tempListenerRefs.addAll(listenerRefs);
                    if (tempListenerRefs.size() > 0) {
                        ArrayList<String> listeners = new ArrayList<String>();
                        int i = 0;
                        while (i < tempListenerRefs.size()) {
                            if (!listeners.contains(tempListenerRefs.get(i))) {
                                listeners.add((String)tempListenerRefs.get(i));
                            }
                            ++i;
                        }
                        message.append("<br>");
                        message.append(Bundle.getMessage("ReminderInUse", count));
                        message.append("<ul>");
                        i = 0;
                        while (i < listeners.size()) {
                            message.append("<li>");
                            message.append((String)listeners.get(i));
                            message.append("</li>");
                            ++i;
                        }
                        message.append("</ul>");
                        JEditorPane pane = new JEditorPane();
                        pane.setContentType("text/html");
                        pane.setText("<html>" + message.toString() + "</html>");
                        pane.setEditable(false);
                        JScrollPane jScrollPane = new JScrollPane(pane);
                        container.add(jScrollPane);
                    }
                } else {
                    prompt = this._maleSocket.getChildCount() > 0 ? "DeleteWithChildrenPrompt" : "DeletePrompt";
                    String msg = MessageFormat.format(Bundle.getMessage(prompt), this._maleSocket.getSystemName());
                    JLabel question = new JLabel(msg);
                    question.setAlignmentX(0.5f);
                    container.add(question);
                }
                JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
                remember.setFont(remember.getFont().deriveFont(10.0f));
                remember.setAlignmentX(0.5f);
                JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
                JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
                JPanel button = new JPanel();
                button.setAlignmentX(0.5f);
                button.add(yesButton);
                button.add(noButton);
                container.add(button);
                noButton.addActionListener(e -> dialog.dispose());
                yesButton.addActionListener(e -> {
                    if (remember.isSelected()) {
                        this.setDisplayDeleteMsg(2);
                    }
                    this.doDelete();
                    dialog.dispose();
                });
                container.add(remember);
                container.setAlignmentX(0.5f);
                container.setAlignmentY(0.5f);
                dialog.getContentPane().add(container);
                dialog.pack();
                dialog.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - dialog.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - dialog.getHeight() / 2);
                dialog.setModal(true);
                dialog.setVisible(true);
            }
            if (TreeEditor.this._treePane._femaleRootSocket.isActive()) {
                TreeEditor.this._treePane._femaleRootSocket.registerListeners();
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Exception while deleting bean", (Throwable)e);
            }
            TreeEditor.this._treePane.updateTree(this._currentFemaleSocket, this._currentPath.getPath());
        }
    }

    public static enum EnableClipboard {
        EnableClipboard,
        DisableClipboard;

    }

    public static enum EnableExecuteEvaluate {
        EnableExecuteEvaluate,
        DisableExecuteEvaluate;

    }

    public static enum EnableRootPopup {
        EnableRootPopup,
        DisableRootPopup;

    }

    public static enum EnableRootRemoveCutCopy {
        EnableRootRemoveCutCopy,
        DisableRootRemoveCutCopy;

    }

    protected class PopupMenu
    extends JPopupMenu
    implements ActionListener {
        private static final String ACTION_COMMAND_RENAME_SOCKET = "rename_socket";
        private static final String ACTION_COMMAND_ADD = "add";
        private static final String ACTION_COMMAND_REMOVE = "remove";
        private static final String ACTION_COMMAND_EDIT = "edit";
        private static final String ACTION_COMMAND_CUT = "cut";
        private static final String ACTION_COMMAND_COPY = "copy";
        private static final String ACTION_COMMAND_PASTE = "paste";
        private static final String ACTION_COMMAND_ENABLE = "enable";
        private static final String ACTION_COMMAND_DISABLE = "disable";
        private static final String ACTION_COMMAND_LOCK = "lock";
        private static final String ACTION_COMMAND_UNLOCK = "unlock";
        private static final String ACTION_COMMAND_LOCAL_VARIABLES = "local_variables";
        private static final String ACTION_COMMAND_CHANGE_USERNAME = "change_username";
        private static final String ACTION_COMMAND_EXECUTE_EVALUATE = "execute_evaluate";
        private final JTree _tree;
        private FemaleSocket _currentFemaleSocket;
        private TreePath _currentPath;
        private JMenuItem menuItemRenameSocket;
        private JMenuItem menuItemAdd;
        private JMenuItem menuItemRemove;
        private JMenuItem menuItemEdit;
        private JMenuItem menuItemCut;
        private JMenuItem menuItemCopy;
        private JMenuItem menuItemPaste;
        private final Map<FemaleSocketOperation, JMenuItem> menuItemFemaleSocketOperation = new HashMap<FemaleSocketOperation, JMenuItem>();
        private JMenuItem menuItemEnable;
        private JMenuItem menuItemDisable;
        private JMenuItem menuItemLock;
        private JMenuItem menuItemUnlock;
        private JMenuItem menuItemLocalVariables;
        private JMenuItem menuItemChangeUsername;
        private JMenuItem menuItemExecuteEvaluate;

        PopupMenu() {
            if (TreeEditor.this._treePane._tree == null) {
                throw new IllegalArgumentException("_tree is null");
            }
            this._tree = TreeEditor.this._treePane._tree;
        }

        private void init() {
            this.menuItemRenameSocket = new JMenuItem(Bundle.getMessage("PopupMenuRenameSocket"));
            this.menuItemRenameSocket.addActionListener(this);
            this.menuItemRenameSocket.setActionCommand(ACTION_COMMAND_RENAME_SOCKET);
            this.add(this.menuItemRenameSocket);
            this.addSeparator();
            this.menuItemAdd = new JMenuItem(Bundle.getMessage("PopupMenuAdd"));
            this.menuItemAdd.addActionListener(this);
            this.menuItemAdd.setActionCommand(ACTION_COMMAND_ADD);
            this.add(this.menuItemAdd);
            this.addSeparator();
            this.menuItemEdit = new JMenuItem(Bundle.getMessage("PopupMenuEdit"));
            this.menuItemEdit.addActionListener(this);
            this.menuItemEdit.setActionCommand(ACTION_COMMAND_EDIT);
            this.add(this.menuItemEdit);
            this.menuItemRemove = new JMenuItem(Bundle.getMessage("PopupMenuRemove"));
            this.menuItemRemove.addActionListener(this);
            this.menuItemRemove.setActionCommand(ACTION_COMMAND_REMOVE);
            this.add(this.menuItemRemove);
            this.addSeparator();
            this.menuItemCut = new JMenuItem(Bundle.getMessage("PopupMenuCut"));
            this.menuItemCut.addActionListener(this);
            this.menuItemCut.setActionCommand(ACTION_COMMAND_CUT);
            this.add(this.menuItemCut);
            this.menuItemCopy = new JMenuItem(Bundle.getMessage("PopupMenuCopy"));
            this.menuItemCopy.addActionListener(this);
            this.menuItemCopy.setActionCommand(ACTION_COMMAND_COPY);
            this.add(this.menuItemCopy);
            this.menuItemPaste = new JMenuItem(Bundle.getMessage("PopupMenuPaste"));
            this.menuItemPaste.addActionListener(this);
            this.menuItemPaste.setActionCommand(ACTION_COMMAND_PASTE);
            this.add(this.menuItemPaste);
            this.addSeparator();
            FemaleSocketOperation[] femaleSocketOperationArray = FemaleSocketOperation.values();
            int n = femaleSocketOperationArray.length;
            int n2 = 0;
            while (n2 < n) {
                FemaleSocketOperation oper = femaleSocketOperationArray[n2];
                JMenuItem menuItem = new JMenuItem(oper.toString());
                menuItem.addActionListener(this);
                menuItem.setActionCommand(oper.name());
                this.add(menuItem);
                this.menuItemFemaleSocketOperation.put(oper, menuItem);
                ++n2;
            }
            this.addSeparator();
            this.menuItemEnable = new JMenuItem(Bundle.getMessage("PopupMenuEnable"));
            this.menuItemEnable.addActionListener(this);
            this.menuItemEnable.setActionCommand(ACTION_COMMAND_ENABLE);
            this.add(this.menuItemEnable);
            this.menuItemDisable = new JMenuItem(Bundle.getMessage("PopupMenuDisable"));
            this.menuItemDisable.addActionListener(this);
            this.menuItemDisable.setActionCommand(ACTION_COMMAND_DISABLE);
            this.add(this.menuItemDisable);
            this.menuItemLock = new JMenuItem(Bundle.getMessage("PopupMenuLock"));
            this.menuItemLock.addActionListener(this);
            this.menuItemLock.setActionCommand(ACTION_COMMAND_LOCK);
            this.add(this.menuItemLock);
            this.menuItemUnlock = new JMenuItem(Bundle.getMessage("PopupMenuUnlock"));
            this.menuItemUnlock.addActionListener(this);
            this.menuItemUnlock.setActionCommand(ACTION_COMMAND_UNLOCK);
            this.add(this.menuItemUnlock);
            this.addSeparator();
            this.menuItemLocalVariables = new JMenuItem(Bundle.getMessage("PopupMenuLocalVariables"));
            this.menuItemLocalVariables.addActionListener(this);
            this.menuItemLocalVariables.setActionCommand(ACTION_COMMAND_LOCAL_VARIABLES);
            this.add(this.menuItemLocalVariables);
            this.addSeparator();
            this.menuItemChangeUsername = new JMenuItem(Bundle.getMessage("PopupMenuChangeUsername"));
            this.menuItemChangeUsername.addActionListener(this);
            this.menuItemChangeUsername.setActionCommand(ACTION_COMMAND_CHANGE_USERNAME);
            this.add(this.menuItemChangeUsername);
            if (TreeEditor.this._enableExecuteEvaluate) {
                this.addSeparator();
                this.menuItemExecuteEvaluate = new JMenuItem();
                this.menuItemExecuteEvaluate.addActionListener(this);
                this.menuItemExecuteEvaluate.setActionCommand(ACTION_COMMAND_EXECUTE_EVALUATE);
                this.add(this.menuItemExecuteEvaluate);
            }
            this.setOpaque(true);
            this.setLightWeightPopupEnabled(true);
            final PopupMenu popupMenu = this;
            this._tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.openPopupMenu(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.openPopupMenu(e);
                }

                private void openPopupMenu(MouseEvent e) {
                    TreePath path;
                    if (TreeEditor.this.isPopupMenuLocked()) {
                        return;
                    }
                    if (e.isPopupTrigger() && !popupMenu.isVisible() && (path = PopupMenu.this._tree.getClosestPathForLocation(e.getX(), e.getY())) != null) {
                        Rectangle rect = PopupMenu.this._tree.getPathBounds(path);
                        if (e.getY() >= rect.y && e.getY() <= rect.y + rect.height) {
                            PopupMenu.this._tree.setSelectionPath(path);
                            FemaleSocket femaleSocket = (FemaleSocket)path.getLastPathComponent();
                            PopupMenu.this.showPopup(e.getX(), e.getY(), femaleSocket, path);
                        }
                    }
                }
            });
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private void showPopup(int x, int y, FemaleSocket femaleSocket, TreePath path) {
            block6: {
                this._currentFemaleSocket = femaleSocket;
                this._currentPath = path;
                clipboard = InstanceManager.getDefault(LogixNG_Manager.class).getClipboard();
                topItem = clipboard.getTopItem();
                isConnected = femaleSocket.isConnected();
                v0 = canConnectFromClipboard = topItem != null && femaleSocket.isCompatible(topItem) != false && femaleSocket.isAncestor(topItem) == false;
                if (TreeEditor.access$1(TreeEditor.this) && this._currentFemaleSocket == TreeEditor.this._treePane._femaleRootSocket) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("TreeEditor_RootHasNoPopupMenu"), Bundle.getMessage("TreeEditor_Info"), 0);
                    return;
                }
                disableForRoot = TreeEditor.access$2(TreeEditor.this) != false && this._currentFemaleSocket == TreeEditor.this._treePane._femaleRootSocket;
                isLocked = isConnected != false && femaleSocket.getConnectedSocket().isLocked() != false;
                parent = femaleSocket.getParent();
                while (parent != null && !(parent instanceof MaleSocket)) {
                    parent = parent.getParent();
                }
                parentIsLocked = parent != null && ((MaleSocket)parent).isLocked() != false;
                this.menuItemAdd.setEnabled(isConnected == false && parentIsLocked == false);
                this.menuItemRemove.setEnabled(isConnected != false && isLocked == false && parentIsLocked == false && disableForRoot == false);
                this.menuItemEdit.setEnabled(isConnected != false && isLocked == false);
                this.menuItemCut.setEnabled(isConnected != false && isLocked == false && parentIsLocked == false && disableForRoot == false);
                this.menuItemCopy.setEnabled(isConnected != false && disableForRoot == false);
                this.menuItemPaste.setEnabled(isConnected == false && parentIsLocked == false && canConnectFromClipboard != false);
                if (isConnected && !disableForRoot) {
                    this.menuItemEnable.setEnabled(femaleSocket.getConnectedSocket().isEnabled() == false && isLocked == false);
                    this.menuItemDisable.setEnabled(femaleSocket.getConnectedSocket().isEnabled() != false && isLocked == false);
                } else {
                    this.menuItemEnable.setEnabled(false);
                    this.menuItemDisable.setEnabled(false);
                }
                var16_13 = FemaleSocketOperation.values();
                var15_14 = var16_13.length;
                var14_16 = 0;
                while (var14_16 < var15_14) {
                    oper = var16_13[var14_16];
                    menuItem = this.menuItemFemaleSocketOperation.get((Object)oper);
                    menuItem.setEnabled(femaleSocket.isSocketOperationAllowed(oper) != false && parentIsLocked == false);
                    ++var14_16;
                }
                isAnyLocked = new AtomicBoolean(false);
                isAnyUnlocked = new AtomicBoolean(false);
                this._currentFemaleSocket.forEntireTree((Base.RunnableWithBase)LambdaMetafactory.metafactory(null, null, null, (Ljmri/jmrit/logixng/Base;)V, lambda$0(java.util.concurrent.atomic.AtomicBoolean java.util.concurrent.atomic.AtomicBoolean jmri.jmrit.logixng.Base ), (Ljmri/jmrit/logixng/Base;)V)((AtomicBoolean)isAnyLocked, (AtomicBoolean)isAnyUnlocked));
                this.menuItemLock.setEnabled(isAnyUnlocked.get());
                this.menuItemUnlock.setEnabled(isAnyLocked.get());
                this.menuItemLocalVariables.setEnabled(femaleSocket.isConnected() != false && isLocked == false);
                this.menuItemChangeUsername.setEnabled(femaleSocket.isConnected() != false && isLocked == false);
                if (!TreeEditor.access$0(TreeEditor.this)) break block6;
                this.menuItemExecuteEvaluate.setEnabled(femaleSocket.isConnected());
                if (!femaleSocket.isConnected()) break block6;
                object /* !! */  = this._currentFemaleSocket.getConnectedSocket();
                if (object /* !! */  != null) ** GOTO lbl52
                throw new NullPointerException("object is null");
lbl-1000:
                // 1 sources

                {
                    object /* !! */  = object /* !! */ .getObject();
lbl52:
                    // 2 sources

                    ** while (object /* !! */  instanceof MaleSocket)
                }
lbl53:
                // 1 sources

                this.menuItemExecuteEvaluate.setText(SwingTools.getSwingConfiguratorForClass(object /* !! */ .getClass()).getExecuteEvaluateMenuText());
            }
            this.show(this._tree, x, y);
        }

        private boolean abortEditAboutSystem(Base b) {
            int result = JOptionPane.showConfirmDialog(this, Bundle.getMessage("TreeEditor_ChangeSystemNode"), b.getLongDescription(), 0);
            return result == 1;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Base parent = this._currentFemaleSocket.getParent();
            while (parent != null && !(this._currentFemaleSocket.getParent() instanceof MaleSocket)) {
                parent = parent.getParent();
            }
            boolean parentIsSystem = parent != null && ((MaleSocket)parent).isSystem();
            boolean itemIsSystem = this._currentFemaleSocket.isConnected() && this._currentFemaleSocket.getConnectedSocket().isSystem();
            switch (e.getActionCommand()) {
                case "rename_socket": {
                    if (parentIsSystem && this.abortEditAboutSystem(this._currentFemaleSocket.getParent())) {
                        return;
                    }
                    TreeEditor.this.renameSocketPressed(this._currentFemaleSocket, this._currentPath);
                    return;
                }
                case "add": {
                    if (parentIsSystem && this.abortEditAboutSystem(this._currentFemaleSocket.getParent())) {
                        return;
                    }
                    TreeEditor.this.addPressed(this._currentFemaleSocket, this._currentPath);
                    return;
                }
                case "edit": {
                    if (itemIsSystem && this.abortEditAboutSystem(this._currentFemaleSocket.getConnectedSocket())) {
                        return;
                    }
                    TreeEditor.this.editPressed(this._currentFemaleSocket, this._currentPath);
                    return;
                }
                case "remove": {
                    if ((parentIsSystem || itemIsSystem) && this.abortEditAboutSystem(this._currentFemaleSocket.getConnectedSocket())) {
                        return;
                    }
                    DeleteBeanWorker worker = new DeleteBeanWorker(this._currentFemaleSocket, this._currentPath);
                    worker.execute();
                    return;
                }
                case "cut": {
                    if ((parentIsSystem || itemIsSystem) && this.abortEditAboutSystem(this._currentFemaleSocket.getConnectedSocket())) {
                        return;
                    }
                    if (this._currentFemaleSocket.isConnected()) {
                        TreeEditor.this._treePane._femaleRootSocket.unregisterListeners();
                        TreeEditor.this.runOnConditionalNGThreadOrGUIThreadEventually(TreeEditor.this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                            Clipboard clipboard = InstanceManager.getDefault(LogixNG_Manager.class).getClipboard();
                            ArrayList<String> errors = new ArrayList<String>();
                            MaleSocket maleSocket = this._currentFemaleSocket.getConnectedSocket();
                            this._currentFemaleSocket.disconnect();
                            if (!clipboard.add(maleSocket, errors)) {
                                JOptionPane.showMessageDialog(this, String.join((CharSequence)"<br>", errors), Bundle.getMessage("TitleError"), 0);
                            }
                            ThreadingUtil.runOnGUIEventually(() -> {
                                TreeEditor.this._treePane._femaleRootSocket.registerListeners();
                                TreeEditor.this._treePane.updateTree(this._currentFemaleSocket, this._currentPath.getPath());
                            });
                        });
                        return;
                    }
                    log.error("_currentFemaleSocket is not connected");
                    return;
                }
                case "copy": {
                    if ((parentIsSystem || itemIsSystem) && this.abortEditAboutSystem(this._currentFemaleSocket.getConnectedSocket())) {
                        return;
                    }
                    if (this._currentFemaleSocket.isConnected()) {
                        TreeEditor.this._treePane._femaleRootSocket.unregisterListeners();
                        TreeEditor.this.runOnConditionalNGThreadOrGUIThreadEventually(TreeEditor.this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                            Clipboard clipboard = InstanceManager.getDefault(LogixNG_Manager.class).getClipboard();
                            HashMap<String, String> systemNames = new HashMap<String, String>();
                            HashMap<String, String> userNames = new HashMap<String, String>();
                            try {
                                ArrayList<String> errors = new ArrayList<String>();
                                if (!clipboard.add((MaleSocket)this._currentFemaleSocket.getConnectedSocket().getDeepCopy(systemNames, userNames), errors)) {
                                    JOptionPane.showMessageDialog(this, String.join((CharSequence)"<br>", errors), Bundle.getMessage("TitleError"), 0);
                                }
                            }
                            catch (JmriException ex) {
                                log.error("getDeepCopy thrown exception: {}", (Object)ex, (Object)ex);
                                ThreadingUtil.runOnGUIEventually(() -> JOptionPane.showMessageDialog(null, "An exception has occured: " + ex.getMessage(), "An error has occured", 0));
                            }
                        });
                        TreeEditor.this._treePane._femaleRootSocket.registerListeners();
                        return;
                    }
                    log.error("_currentFemaleSocket is not connected");
                    return;
                }
                case "paste": {
                    if (parentIsSystem && this.abortEditAboutSystem(this._currentFemaleSocket.getParent())) {
                        return;
                    }
                    if (!this._currentFemaleSocket.isConnected()) {
                        TreeEditor.this._treePane._femaleRootSocket.unregisterListeners();
                        TreeEditor.this.runOnConditionalNGThreadOrGUIThreadEventually(TreeEditor.this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                            Clipboard clipboard = InstanceManager.getDefault(LogixNG_Manager.class).getClipboard();
                            try {
                                this._currentFemaleSocket.connect(clipboard.fetchTopItem());
                                ArrayList<String> errors = new ArrayList<String>();
                                if (!this._currentFemaleSocket.setParentForAllChildren(errors)) {
                                    JOptionPane.showMessageDialog(this, String.join((CharSequence)"<br>", errors), Bundle.getMessage("TitleError"), 0);
                                }
                            }
                            catch (SocketAlreadyConnectedException ex) {
                                log.error("item cannot be connected", (Throwable)ex);
                            }
                            ThreadingUtil.runOnGUIEventually(() -> {
                                TreeEditor.this._treePane._femaleRootSocket.registerListeners();
                                TreeEditor.this._treePane.updateTree(this._currentFemaleSocket, this._currentPath.getPath());
                            });
                        });
                        return;
                    }
                    log.error("_currentFemaleSocket is connected");
                    return;
                }
                case "enable": {
                    if (itemIsSystem && this.abortEditAboutSystem(this._currentFemaleSocket.getConnectedSocket())) {
                        return;
                    }
                    this._currentFemaleSocket.getConnectedSocket().setEnabled(true);
                    TreeEditor.this.runOnConditionalNGThreadOrGUIThreadEventually(TreeEditor.this._treePane._femaleRootSocket.getConditionalNG(), () -> ThreadingUtil.runOnGUIEventually(() -> {
                        TreeEditor.this._treePane._femaleRootSocket.unregisterListeners();
                        TreeEditor.this._treePane.updateTree(this._currentFemaleSocket, this._currentPath.getPath());
                        TreeEditor.this._treePane._femaleRootSocket.registerListeners();
                    }));
                    return;
                }
                case "disable": {
                    if (itemIsSystem && this.abortEditAboutSystem(this._currentFemaleSocket.getConnectedSocket())) {
                        return;
                    }
                    this._currentFemaleSocket.getConnectedSocket().setEnabled(false);
                    TreeEditor.this.runOnConditionalNGThreadOrGUIThreadEventually(TreeEditor.this._treePane._femaleRootSocket.getConditionalNG(), () -> ThreadingUtil.runOnGUIEventually(() -> {
                        TreeEditor.this._treePane._femaleRootSocket.unregisterListeners();
                        TreeEditor.this._treePane.updateTree(this._currentFemaleSocket, this._currentPath.getPath());
                        TreeEditor.this._treePane._femaleRootSocket.registerListeners();
                    }));
                    return;
                }
                case "lock": {
                    if (itemIsSystem && this.abortEditAboutSystem(this._currentFemaleSocket.getConnectedSocket())) {
                        return;
                    }
                    this._currentFemaleSocket.forEntireTree(item -> {
                        if (item instanceof MaleSocket) {
                            ((MaleSocket)item).setLocked(true);
                        }
                    });
                    TreeEditor.this._treePane.updateTree(this._currentFemaleSocket, this._currentPath.getPath());
                    return;
                }
                case "unlock": {
                    if (itemIsSystem && this.abortEditAboutSystem(this._currentFemaleSocket.getConnectedSocket())) {
                        return;
                    }
                    this._currentFemaleSocket.forEntireTree(item -> {
                        if (item instanceof MaleSocket) {
                            ((MaleSocket)item).setLocked(false);
                        }
                    });
                    TreeEditor.this._treePane.updateTree(this._currentFemaleSocket, this._currentPath.getPath());
                    return;
                }
                case "local_variables": {
                    if (itemIsSystem && this.abortEditAboutSystem(this._currentFemaleSocket.getConnectedSocket())) {
                        return;
                    }
                    TreeEditor.this.editLocalVariables(this._currentFemaleSocket, this._currentPath);
                    return;
                }
                case "change_username": {
                    if (itemIsSystem && this.abortEditAboutSystem(this._currentFemaleSocket.getConnectedSocket())) {
                        return;
                    }
                    TreeEditor.this.changeUsername(this._currentFemaleSocket, this._currentPath);
                    return;
                }
                case "execute_evaluate": {
                    MaleSocket maleSocket = this._currentFemaleSocket.getConnectedSocket();
                    if (maleSocket == null) {
                        throw new NullPointerException("object is null");
                    }
                    while (true) {
                        void var7_8;
                        if (!(var7_8 instanceof MaleSocket)) {
                            SwingConfiguratorInterface swi = SwingTools.getSwingConfiguratorForClass(var7_8.getClass());
                            TreeEditor.this.executeEvaluate(swi, this._currentFemaleSocket.getConnectedSocket());
                            return;
                        }
                        Base base = ((MaleSocket)var7_8).getObject();
                    }
                }
            }
            if (this.checkFemaleSocketOperation(this._currentFemaleSocket, parentIsSystem, itemIsSystem, e.getActionCommand())) return;
            log.error("e.getActionCommand() returns unknown value {}", (Object)e.getActionCommand());
        }

        private boolean checkFemaleSocketOperation(FemaleSocket femaleSocket, boolean parentIsSystem, boolean itemIsSystem, String command) {
            FemaleSocketOperation[] femaleSocketOperationArray = FemaleSocketOperation.values();
            int n = femaleSocketOperationArray.length;
            int n2 = 0;
            while (n2 < n) {
                FemaleSocketOperation oper = femaleSocketOperationArray[n2];
                if (oper.name().equals(command)) {
                    if ((parentIsSystem || itemIsSystem) && this.abortEditAboutSystem(femaleSocket.getParent())) {
                        return true;
                    }
                    femaleSocket.doSocketOperation(oper);
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private static /* synthetic */ void lambda$0(AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2, Base item) {
            if (item instanceof MaleSocket) {
                atomicBoolean.set(atomicBoolean.get() || ((MaleSocket)item).isLocked());
                atomicBoolean2.set(atomicBoolean2.get() || !((MaleSocket)item).isLocked());
            }
        }
    }

    private static final class SortedComboBoxModel<E>
    extends DefaultComboBoxModel<E> {
        private final Comparator<E> comparator;

        public SortedComboBoxModel(@Nonnull Comparator<E> comparator) {
            this.comparator = comparator;
        }

        @Override
        public void addElement(E element) {
            this.insertElementAt(element, 0);
        }

        @Override
        public void insertElementAt(E element, int index) {
            int size = this.getSize();
            int i = 0;
            while (i < size) {
                Object o = this.getElementAt(i);
                if (this.comparator.compare(o, element) > 0) break;
                ++i;
            }
            super.insertElementAt(element, i);
            if (i == 0 && element != null) {
                this.setSelectedItem(element);
            }
        }
    }
}

