/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.implementation.DefaultLogixNGPreferences;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.swing.JTitledSeparator;
import jmri.swing.PreferencesPanel;
import jmri.util.swing.JComboBoxUtil;

public class LogixNGPreferencesPanel
extends JPanel
implements PreferencesPanel {
    private final DefaultLogixNGPreferences preferences;
    JCheckBox _startLogixNGOnLoadCheckBox;
    JCheckBox _installDebuggerCheckBox;
    JCheckBox _showSystemUserNamesCheckBox;
    JCheckBox _treeEditorHighlightRow;
    private JComboBox<MaleSocket.ErrorHandlingType> _errorHandlingComboBox;

    public LogixNGPreferencesPanel() {
        LogixNGPreferences prefs = InstanceManager.getDefault(LogixNGPreferences.class);
        if (!(prefs instanceof DefaultLogixNGPreferences)) {
            throw new RuntimeException("LogixNGPreferences is not of type DefaultLogixNGPreferences");
        }
        this.preferences = (DefaultLogixNGPreferences)prefs;
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(new JTitledSeparator(Bundle.getMessage("TitleStartupSettingsPanel")));
        this.add(this.getStartupPanel());
        this.add(new JTitledSeparator(Bundle.getMessage("TitleTimeDiagramColorsPanel")));
        this.add(this.getTimeDiagramColorsPanel());
    }

    private boolean setValues() {
        boolean didSet = true;
        this.preferences.setStartLogixNGOnStartup(this._startLogixNGOnLoadCheckBox.isSelected());
        this.preferences.setInstallDebugger(this._installDebuggerCheckBox.isSelected());
        this.preferences.setShowSystemUserNames(this._showSystemUserNamesCheckBox.isSelected());
        this.preferences.setTreeEditorHighlightRow(this._treeEditorHighlightRow.isSelected());
        this.preferences.setErrorHandlingType(this._errorHandlingComboBox.getItemAt(this._errorHandlingComboBox.getSelectedIndex()));
        return didSet;
    }

    private JPanel getStartupPanel() {
        JPanel panel = new JPanel();
        this._startLogixNGOnLoadCheckBox = new JCheckBox(Bundle.getMessage("LabelStartLogixNGOnLoad"));
        this._startLogixNGOnLoadCheckBox.setToolTipText(Bundle.getMessage("ToolTipStartLogixNGOnLoad"));
        this._installDebuggerCheckBox = new JCheckBox(Bundle.getMessage("LabelInstallDebugger"));
        this._installDebuggerCheckBox.setToolTipText(Bundle.getMessage("ToolTipLabelInstallDebugger"));
        this._showSystemUserNamesCheckBox = new JCheckBox(Bundle.getMessage("LabelShowSystemUserNames"));
        this._showSystemUserNamesCheckBox.setToolTipText(Bundle.getMessage("ToolTipLabeShowSystemUserNames"));
        this._treeEditorHighlightRow = new JCheckBox(Bundle.getMessage("LabelTreeEditorHighlightRow"));
        this._treeEditorHighlightRow.setToolTipText(Bundle.getMessage("ToolTipTreeEditorHighlightRow"));
        JPanel gridPanel = new JPanel(new GridLayout(0, 1));
        gridPanel.add(this._startLogixNGOnLoadCheckBox);
        gridPanel.add(this._installDebuggerCheckBox);
        gridPanel.add(this._showSystemUserNamesCheckBox);
        gridPanel.add(this._treeEditorHighlightRow);
        this._startLogixNGOnLoadCheckBox.setSelected(this.preferences.getStartLogixNGOnStartup());
        this._installDebuggerCheckBox.setSelected(this.preferences.getInstallDebugger());
        this._showSystemUserNamesCheckBox.setSelected(this.preferences.getShowSystemUserNames());
        this._treeEditorHighlightRow.setSelected(this.preferences.getTreeEditorHighlightRow());
        this._errorHandlingComboBox = new JComboBox();
        MaleSocket.ErrorHandlingType[] errorHandlingTypeArray = MaleSocket.ErrorHandlingType.values();
        int n = errorHandlingTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MaleSocket.ErrorHandlingType type = errorHandlingTypeArray[n2];
            if (type != MaleSocket.ErrorHandlingType.Default) {
                this._errorHandlingComboBox.addItem(type);
                if (this.preferences.getErrorHandlingType() == type) {
                    this._errorHandlingComboBox.setSelectedItem((Object)type);
                }
            }
            ++n2;
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._errorHandlingComboBox);
        gridPanel.add(this._errorHandlingComboBox);
        panel.setLayout(new FlowLayout(1, 40, 0));
        panel.add(gridPanel);
        return panel;
    }

    private JPanel getTimeDiagramColorsPanel() {
        return new JPanel();
    }

    @Override
    public String getPreferencesItem() {
        return "LOGIXNG";
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("MenuLogixNG");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return this.getPreferencesItemText();
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        if (this.setValues()) {
            this.preferences.save();
        }
    }

    @Override
    public boolean isDirty() {
        return this.preferences.isDirty();
    }

    @Override
    public boolean isRestartRequired() {
        return this.preferences.isRestartRequired();
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }
}

