/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.tools.swing.Bundle;

public class DebuggerSymbolTableModel
extends AbstractTableModel {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VALUE = 1;
    private final ConditionalNG _conditionalNG;
    private final List<SymbolTable.Symbol> _symbols = new ArrayList<SymbolTable.Symbol>();

    public DebuggerSymbolTableModel(ConditionalNG conditionalNG) {
        this._conditionalNG = conditionalNG;
    }

    public void update(Map<String, SymbolTable.Symbol> symbols) {
        this._symbols.clear();
        for (SymbolTable.Symbol s : symbols.values()) {
            this._symbols.add(s);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this._symbols.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ColumnSymbolName");
            }
            case 1: {
                return Bundle.getMessage("ColumnSymbolValue");
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        SymbolTable.Symbol symbol = this._symbols.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                this._conditionalNG.getStack().setValueAtIndex(symbol.getIndex(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column");
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this._symbols.size()) {
            throw new IllegalArgumentException("Invalid row");
        }
        switch (columnIndex) {
            case 0: {
                return this._symbols.get(rowIndex).getName();
            }
            case 1: {
                return this._conditionalNG.getStack().getValueAtIndex(this._symbols.get(rowIndex).getIndex());
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }
}

