/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.util.swing.JComboBoxUtil;

public class CallModuleParameterTableModel
extends AbstractTableModel {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_INPUT_TYPE = 1;
    public static final int COLUMN_INPUT_DATA = 2;
    public static final int COLUMN_OUTPUT_TYPE = 3;
    public static final int COLUMN_OUTPUT_DATA = 4;
    private final List<Module.ParameterData> _parameterData = new ArrayList<Module.ParameterData>();

    public CallModuleParameterTableModel(Module module, List<Module.ParameterData> parameterData) {
        if (module != null) {
            HashMap<String, Module.ParameterData> parameterDataMap = new HashMap<String, Module.ParameterData>();
            for (Module.ParameterData pd : parameterData) {
                parameterDataMap.put(pd._name, new Module.ParameterData(pd));
            }
            for (Module.Parameter p : module.getParameters()) {
                if (parameterDataMap.containsKey(p.getName())) {
                    this._parameterData.add((Module.ParameterData)parameterDataMap.get(p.getName()));
                    continue;
                }
                this._parameterData.add(new Module.ParameterData(p.getName(), SymbolTable.InitialValueType.None, "", Module.ReturnValueType.None, ""));
            }
        }
    }

    @Override
    public int getRowCount() {
        return this._parameterData.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ColumnParameterName");
            }
            case 1: {
                return Bundle.getMessage("ColumnInputParameterType");
            }
            case 2: {
                return Bundle.getMessage("ColumnInputParameterData");
            }
            case 3: {
                return Bundle.getMessage("ColumnOutputParameterType");
            }
            case 4: {
                return Bundle.getMessage("ColumnOutputParameterData");
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 1: {
                return SymbolTable.InitialValueType.class;
            }
            case 3: {
                return Module.ReturnValueType.class;
            }
            case 0: 
            case 2: 
            case 4: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Module.ParameterData variable = this._parameterData.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                variable._name = (String)value;
                break;
            }
            case 1: {
                variable._initialValueType = (SymbolTable.InitialValueType)((Object)value);
                break;
            }
            case 2: {
                variable._initialValueData = (String)value;
                break;
            }
            case 3: {
                variable._returnValueType = (Module.ReturnValueType)((Object)value);
                break;
            }
            case 4: {
                variable._returnValueData = (String)value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column");
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this._parameterData.size()) {
            throw new IllegalArgumentException("Invalid row");
        }
        switch (columnIndex) {
            case 0: {
                return this._parameterData.get(rowIndex).getName();
            }
            case 1: {
                return this._parameterData.get(rowIndex).getInitialValueType();
            }
            case 2: {
                return this._parameterData.get(rowIndex).getInitialValueData();
            }
            case 3: {
                return this._parameterData.get(rowIndex).getReturnValueType();
            }
            case 4: {
                return this._parameterData.get(rowIndex).getReturnValueData();
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    public void setColumnsForComboBoxes(JTable table) {
        JComboBox initValueComboBox = new JComboBox();
        JComboBox returnValueComboBox = new JComboBox();
        table.setRowHeight(initValueComboBox.getPreferredSize().height);
        table.getColumnModel().getColumn(1).setPreferredWidth(initValueComboBox.getPreferredSize().width + 4);
        table.getColumnModel().getColumn(3).setPreferredWidth(returnValueComboBox.getPreferredSize().width + 4);
    }

    public void add() {
        int row = this._parameterData.size();
        this._parameterData.add(new Module.ParameterData("", SymbolTable.InitialValueType.None, "", Module.ReturnValueType.None, ""));
        this.fireTableRowsInserted(row, row);
    }

    public List<Module.ParameterData> getParameters() {
        return this._parameterData;
    }

    public static class InitialValueCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private SymbolTable.InitialValueType _initialValueType;

        @Override
        public Object getCellEditorValue() {
            return this._initialValueType;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                value = SymbolTable.InitialValueType.None;
            }
            if (!(value instanceof SymbolTable.InitialValueType)) {
                throw new IllegalArgumentException("value is not an InitialValueType: " + value.getClass().getName());
            }
            JComboBox<SymbolTable.InitialValueType> initialValueTypeComboBox = new JComboBox<SymbolTable.InitialValueType>();
            SymbolTable.InitialValueType[] initialValueTypeArray = SymbolTable.InitialValueType.values();
            int n = initialValueTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SymbolTable.InitialValueType type = initialValueTypeArray[n2];
                if (type.isValidAsParameter()) {
                    initialValueTypeComboBox.addItem(type);
                }
                ++n2;
            }
            JComboBoxUtil.setupComboBoxMaxRows(initialValueTypeComboBox);
            initialValueTypeComboBox.setSelectedItem(value);
            initialValueTypeComboBox.addActionListener(this);
            return initialValueTypeComboBox;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!(event.getSource() instanceof JComboBox)) {
                throw new IllegalArgumentException("value is not an JComboBox: " + event.getSource().getClass().getName());
            }
            JComboBox initialValueTypeComboBox = (JComboBox)event.getSource();
            this._initialValueType = (SymbolTable.InitialValueType)((Object)initialValueTypeComboBox.getItemAt(initialValueTypeComboBox.getSelectedIndex()));
        }
    }

    public static class ReturnValueCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private Module.ReturnValueType _returnValueType;

        @Override
        public Object getCellEditorValue() {
            return this._returnValueType;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                value = Module.ReturnValueType.None;
            }
            if (!(value instanceof Module.ReturnValueType)) {
                throw new IllegalArgumentException("value is not an ReturnValueType: " + value.getClass().getName());
            }
            JComboBox<Module.ReturnValueType> returnValueTypeComboBox = new JComboBox<Module.ReturnValueType>();
            Module.ReturnValueType[] returnValueTypeArray = Module.ReturnValueType.values();
            int n = returnValueTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Module.ReturnValueType type = returnValueTypeArray[n2];
                returnValueTypeComboBox.addItem(type);
                ++n2;
            }
            JComboBoxUtil.setupComboBoxMaxRows(returnValueTypeComboBox);
            returnValueTypeComboBox.setSelectedItem(value);
            returnValueTypeComboBox.addActionListener(this);
            return returnValueTypeComboBox;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!(event.getSource() instanceof JComboBox)) {
                throw new IllegalArgumentException("value is not an JComboBox: " + event.getSource().getClass().getName());
            }
            JComboBox returnValueTypeComboBox = (JComboBox)event.getSource();
            this._returnValueType = (Module.ReturnValueType)((Object)returnValueTypeComboBox.getItemAt(returnValueTypeComboBox.getSelectedIndex()));
        }
    }

    public static class TypeCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 1) {
                if (value == null) {
                    value = SymbolTable.InitialValueType.None;
                }
                if (!(value instanceof SymbolTable.InitialValueType)) {
                    throw new IllegalArgumentException("value is not an InitialValueType: " + value.getClass().getName());
                }
                this.setText(((SymbolTable.InitialValueType)((Object)value)).toString());
            } else if (column == 3) {
                if (value == null) {
                    value = Module.ReturnValueType.None;
                }
                if (!(value instanceof Module.ReturnValueType)) {
                    throw new IllegalArgumentException("value is not an ReturnValueType: " + value.getClass().getName());
                }
                this.setText(((Module.ReturnValueType)((Object)value)).getDescr());
            } else {
                throw new RuntimeException("Unknown column: " + Integer.toString(column));
            }
            return this;
        }
    }
}

