/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.debugger;

import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.Debugable;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.implementation.AbstractMaleSocket;
import jmri.jmrit.logixng.tools.debugger.Debugger;

public abstract class AbstractDebuggerMaleSocket
extends AbstractMaleSocket {
    private final Debugger _debugger = InstanceManager.getDefault(Debugger.class);
    private boolean _breakpointBefore = false;
    private boolean _breakpointAfter = false;
    private boolean _stepInto = true;
    private boolean _lastDoBreak = true;

    public AbstractDebuggerMaleSocket(BaseManager<? extends MaleSocket> manager, MaleSocket maleSocket) {
        super(manager, maleSocket);
    }

    public abstract String getBeforeInfo();

    public abstract String getAfterInfo();

    protected boolean isDebuggerActive() {
        return this._debugger.isDebuggerActive() && this._debugger.getDebugConditionalNG() == this.getConditionalNG();
    }

    protected void before() {
        this._lastDoBreak = this._debugger.getBreak();
        if (this.isDebuggerActive() && (this._debugger.getBreak() || this._breakpointBefore)) {
            this._debugger.firePropertyChange("StepBefore", null, this);
            this._debugger.setBreak(this._stepInto);
        }
    }

    protected void after() {
        if (this.isDebuggerActive()) {
            this._debugger.setBreak(this._lastDoBreak);
            if (this._debugger.getBreak() || this._breakpointAfter) {
                this._debugger.firePropertyChange("StepAfter", null, this);
            }
        }
    }

    public void setStepInto(boolean value) {
        this._stepInto = value;
    }

    public void setBreakpointBefore(boolean value) {
        this._breakpointBefore = value;
    }

    public boolean getBreakpointBefore() {
        return this._breakpointBefore;
    }

    public void setBreakpointAfter(boolean value) {
        this._breakpointAfter = value;
    }

    public boolean getBreakpointAfter() {
        return this._breakpointAfter;
    }

    @Override
    protected final void registerListenersForThisClass() {
        ((MaleSocket)this.getObject()).registerListeners();
    }

    @Override
    protected final void unregisterListenersForThisClass() {
        ((MaleSocket)this.getObject()).unregisterListeners();
    }

    @Override
    protected final void disposeMe() {
        ((MaleSocket)this.getObject()).dispose();
    }

    @Override
    public final void setEnabled(boolean enable) {
        ((MaleSocket)this.getObject()).setEnabled(enable);
    }

    @Override
    public void setEnabledFlag(boolean enable) {
        ((MaleSocket)this.getObject()).setEnabledFlag(enable);
    }

    @Override
    public final boolean isEnabled() {
        return ((MaleSocket)this.getObject()).isEnabled();
    }

    @Override
    public final void setDebugConfig(Debugable.DebugConfig config) {
        ((MaleSocket)this.getObject()).setDebugConfig(config);
    }

    @Override
    public final Debugable.DebugConfig getDebugConfig() {
        return ((MaleSocket)this.getObject()).getDebugConfig();
    }

    @Override
    public final Debugable.DebugConfig createDebugConfig() {
        return ((MaleSocket)this.getObject()).createDebugConfig();
    }

    @Override
    public final String getComment() {
        return ((MaleSocket)this.getObject()).getComment();
    }

    @Override
    public final void setComment(String comment) {
        ((MaleSocket)this.getObject()).setComment(comment);
    }

    @Override
    public void setParent(Base parent) {
        super.setParent(parent);
        ((MaleSocket)this.getObject()).setParent(this);
    }
}

