/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools;

import jmri.Conditional;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Logix;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.ConditionalNG_Manager;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.tools.ImportConditional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportLogix {
    private final Logix _logix;
    private final LogixNG _logixNG;
    private final boolean _dryRun;
    private static final Logger log = LoggerFactory.getLogger(ImportLogix.class);

    public ImportLogix(Logix logix) {
        this(logix, false);
    }

    public ImportLogix(Logix logix, boolean allowSystemImport) {
        this(logix, allowSystemImport, false);
    }

    public ImportLogix(Logix logix, boolean allowSystemImport, boolean dryRun) {
        this._dryRun = dryRun;
        Base logixNG = null;
        if (!this._dryRun) {
            int counter = 0;
            while (logixNG == null && counter < 100) {
                String name = counter > 0 ? " - " + Integer.toString(counter) : "";
                logixNG = InstanceManager.getDefault(LogixNG_Manager.class).createLogixNG("Logix: " + logix.getDisplayName() + name);
                ++counter;
            }
            if (logixNG == null) {
                throw new RuntimeException("Cannot create new LogixNG with name: \"Logix: " + logix.getDisplayName() + "\"");
            }
            log.debug("Import Logix {} to LogixNG {}", (Object)logix.getSystemName(), (Object)logixNG.getSystemName());
        }
        this._logix = logix;
        this._logixNG = logixNG;
    }

    public void doImport() throws JmriException {
        int i = 0;
        while (i < this._logix.getNumConditionals()) {
            ImportConditional ic;
            block5: {
                Conditional c = this._logix.getConditional(this._logix.getConditionalByNumberOrder(i));
                if (!this._dryRun) {
                    log.warn("Import Conditional '{}' to LogixNG '{}'", (Object)c.getSystemName(), (Object)this._logixNG.getSystemName());
                }
                ic = new ImportConditional(this._logix, c, this._logixNG, InstanceManager.getDefault(ConditionalNG_Manager.class).getAutoSystemName(), this._dryRun);
                try {
                    ic.doImport();
                }
                catch (SocketAlreadyConnectedException ex) {
                    if (this._dryRun) break block5;
                    log.warn("Exception during import of Conditional {} to ConditionalNG {}", new Object[]{c.getSystemName(), this._logixNG.getSystemName(), ex});
                }
            }
            if (!this._dryRun) {
                ic.getConditionalNG().setEnabled(true);
            }
            ++i;
        }
    }

    public LogixNG getLogixNG() {
        return this._logixNG;
    }
}

