/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.swing;

import java.lang.reflect.InvocationTargetException;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwingTools {
    private static final Logger log = LoggerFactory.getLogger(SwingTools.class);

    private SwingTools() {
    }

    public static String adapterNameForObject(Object o) {
        return SwingTools.adapterNameForClass(o.getClass());
    }

    public static String adapterNameForClass(Class c) {
        String className = c.getName();
        log.trace("handle object of class {}", (Object)className);
        int lastDot = className.lastIndexOf(".");
        if (lastDot > 0) {
            String result = String.valueOf(className.substring(0, lastDot)) + ".swing." + className.substring(lastDot + 1, className.length()) + "Swing";
            log.trace("adapter class name is {}", (Object)result);
            return result;
        }
        log.error("No package name found, which is not yet handled!");
        throw new RuntimeException("No package name found, which is not yet handled!");
    }

    public static SwingConfiguratorInterface getSwingConfiguratorForObject(Object object) {
        SwingConfiguratorInterface adapter = null;
        try {
            adapter = (SwingConfiguratorInterface)Class.forName(SwingTools.adapterNameForObject(object)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            log.error("Cannot load SwingConfiguratorInterface adapter for {}", (Object)object.getClass().getName(), (Object)ex);
        }
        if (adapter != null) {
            return adapter;
        }
        log.error("Cannot load SwingConfiguratorInterface for {}", (Object)object.getClass().getName());
        return null;
    }

    public static SwingConfiguratorInterface getSwingConfiguratorForClass(Class clazz) {
        SwingConfiguratorInterface adapter = null;
        try {
            adapter = (SwingConfiguratorInterface)Class.forName(SwingTools.adapterNameForClass(clazz)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            log.error("Cannot load SwingConfiguratorInterface adapter for {}", (Object)clazz.getName(), (Object)ex);
        }
        if (adapter != null) {
            return adapter;
        }
        log.error("Cannot load SwingConfiguratorInterface for {}", (Object)clazz.getName());
        return null;
    }
}

