/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.log;

import jmri.jmrit.logixng.log.LogRow;

public final class LogRowArray
implements LogRow {
    final long[] _row;
    final int _numStates;

    public LogRowArray(int numStates) {
        int sizeOfArray = numStates / 64;
        if (numStates % 64 > 0) {
            ++sizeOfArray;
        }
        this._row = new long[sizeOfArray];
        this._numStates = numStates;
    }

    public LogRowArray(long[] row, int numStates) {
        this._row = (long[])row.clone();
        this._numStates = numStates;
    }

    public LogRowArray(String rowString) {
        int numStates = rowString.length();
        int sizeOfArray = numStates / 64;
        if (numStates % 64 > 0) {
            ++sizeOfArray;
        }
        this._row = new long[sizeOfArray];
        char[] chars = rowString.toCharArray();
        int i = 0;
        while (i < numStates) {
            this.setState(i, chars[i] == '1');
            ++i;
        }
        this._numStates = rowString.length();
    }

    @Override
    public int getNumStates() {
        return this._numStates;
    }

    @Override
    public boolean getState(int index) {
        int indexInArray = index / 64;
        int indexInLong = index % 64;
        return (this._row[indexInArray] >> indexInLong & 1L) == 1L;
    }

    @Override
    public void setState(int index, boolean state) {
        int indexInArray = index / 64;
        int indexInLong = index % 64;
        long bit = (state ? 1 : 0) << indexInLong;
        int n = indexInArray;
        this._row[n] = this._row[n] | bit;
    }

    @Override
    public long[] getData() {
        return (long[])this._row.clone();
    }

    @Override
    public String getDataString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this._numStates) {
            sb.append(this.getState(i) ? (char)'1' : '0');
            ++i;
        }
        return sb.toString();
    }
}

