/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.log;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import jmri.jmrit.logixng.log.Encodings;
import jmri.jmrit.logixng.log.Log;

public class LogHeader {
    public static final int MAX_LINE_LENGTH = 2048;
    private static final int SUPPORTED_VERSION = 1;
    private final Log _logixNGLog;
    private Encodings _encoding = Encodings.ASCII_ONE_BIT_PER_CHAR;
    private String _name = "";
    private int _version = 1;

    public LogHeader(Log logixNGLog) {
        this._logixNGLog = logixNGLog;
    }

    public void setEncoding(Encodings encoding) {
        this._encoding = encoding;
    }

    public Encodings getEncoding() {
        return this._encoding;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    private void readHeaderLines(StreamReader reader) throws IOException, Log.InvalidFormatException, Log.UnsupportedVersionException {
        String line;
        block10: while ((line = reader.readLine(91)) != null) {
            String[] parts = line.split("=", 2);
            switch (parts[0]) {
                case "version": {
                    this._version = Integer.parseInt(parts[1]);
                    if (this._version <= 1) continue block10;
                    throw new Log.UnsupportedVersionException(String.format("Version %d of the log is not supported. Only versions up to and including version %d are supported.", this._version, 1));
                }
                case "name": {
                    this._name = parts[1];
                    break;
                }
                case "encoding": {
                    this._encoding = Encodings.getEncodingFromName(parts[1]);
                    break;
                }
                default: {
                    throw new Log.InvalidFormatException(String.format("String '%s' is unknown or misplaced in log", line));
                }
            }
        }
    }

    private void readItemLines(StreamReader reader) throws IOException, Log.InvalidFormatException {
        String line;
        this._logixNGLog.clearItemList();
        while ((line = reader.readLine(91)) != null) {
            this._logixNGLog.addItem(line);
        }
    }

    public void readHeader(InputStream input) throws IOException, Log.InvalidFormatException, Log.UnsupportedVersionException {
        String line;
        StreamReader reader = new StreamReader(input);
        while ((line = reader.readLine()) != null) {
            switch (line) {
                case "[header]": {
                    this.readHeaderLines(reader);
                    break;
                }
                case "[items]": {
                    this.readItemLines(reader);
                    break;
                }
                case "[data]": {
                    return;
                }
                default: {
                    throw new Log.InvalidFormatException(String.format("String '%s' is unknown or misplaced in log", line));
                }
            }
        }
        throw new Log.InvalidFormatException("Section [data] is missing. End of stream reached.");
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="the log file uses \n as new line character which simplifies parsing")
    public void writeHeader(OutputStream output) throws IOException {
        output.write("[header]\n".getBytes(StandardCharsets.UTF_8));
        output.write(String.format("version=%d\n", 1).getBytes(StandardCharsets.UTF_8));
        output.write(String.format("encoding=%s\n", this._encoding.getName()).getBytes(StandardCharsets.UTF_8));
        output.write(String.format("name=%s\n", this._name).getBytes(StandardCharsets.UTF_8));
        output.write("[items]\n".getBytes(StandardCharsets.UTF_8));
        for (String item : this._logixNGLog.getItemList()) {
            output.write(String.format("%s\n", item).getBytes(StandardCharsets.UTF_8));
        }
        output.write("[data]\n".getBytes(StandardCharsets.UTF_8));
    }

    private static class StreamReader {
        private static final int NO_CHAR = -2;
        private final InputStream _input;
        private int _ch;

        StreamReader(InputStream input) {
            this._input = input;
            this._ch = -2;
        }

        private String readLine() throws IOException {
            return this.readLine(-1);
        }

        private String readLine(int abortChar) throws IOException {
            byte[] buffer = new byte[2048];
            int length = 0;
            if (this._ch == -2) {
                this._ch = this._input.read();
            }
            while (this._ch != -1 && this._ch != 10 && this._ch != abortChar) {
                buffer[length++] = (byte)this._ch;
                this._ch = this._input.read();
            }
            if (this._ch == 10) {
                this._ch = -2;
            }
            if (length > 0) {
                return new String(buffer, 0, length, StandardCharsets.UTF_8);
            }
            return null;
        }
    }
}

