/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.log;

import java.io.IOException;
import java.io.InputStream;
import jmri.jmrit.logixng.log.Encodings;
import jmri.jmrit.logixng.log.Log;
import jmri.jmrit.logixng.log.LogReaderDecoder;
import jmri.jmrit.logixng.log.LogRow;
import jmri.jmrit.logixng.log.LogRowArray;

public class AsciiOneBitPerCharDecoder
implements LogReaderDecoder {
    private Log _logixNGLog;
    private InputStream _input;

    @Override
    public void init(Log logixNGLog, InputStream input) {
        this._logixNGLog = logixNGLog;
        this._input = input;
    }

    @Override
    public Encodings getEncoding() {
        return Encodings.ASCII_ONE_BIT_PER_CHAR;
    }

    @Override
    public LogRow read() throws IOException, Log.InvalidFormatException {
        LogRowArray row = new LogRowArray(this._logixNGLog.getNumItems());
        int i = 0;
        while (i < row.getNumStates()) {
            int ch = this._input.read();
            if (i == 0 && (ch == -1 || ch == 10)) {
                return null;
            }
            if (ch == -1) {
                throw new Log.InvalidFormatException("Unexpected end of stream");
            }
            if (ch == 10) {
                throw new Log.InvalidFormatException("Unexpected end of line");
            }
            switch (ch) {
                case 49: {
                    row.setState(i, true);
                    break;
                }
                case 48: {
                    row.setState(i, false);
                    break;
                }
                default: {
                    throw new Log.InvalidFormatException("Unknown character");
                }
            }
            ++i;
        }
        int ch = this._input.read();
        if (ch == -1) {
            throw new Log.InvalidFormatException("Unexpected end of stream");
        }
        if (ch != 10) {
            throw new Log.InvalidFormatException("New line expected");
        }
        return row;
    }
}

