/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation.swing;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.implementation.swing.Bundle;

public class ErrorHandlingDialog {
    private Base _item;
    private JDialog _errorDialog;
    private final JCheckBox _disableConditionalNGCheckBox = new JCheckBox(Bundle.getMessage("ErrorHandlingDialog_DisableConditionalNG"));
    private final JCheckBox _disableLogixNGCheckBox = new JCheckBox(Bundle.getMessage("ErrorHandlingDialog_DisableLogixNG"));
    private final JCheckBox _stopAllLogixNGCheckBox = new JCheckBox(Bundle.getMessage("ErrorHandlingDialog_StopAllLogixNGs"));
    private boolean _abortExecution = false;

    public boolean showDialog(Base item, String errorMessage) {
        this._item = item;
        this._errorDialog = new JDialog(null, Bundle.getMessage("ErrorHandlingDialog_Title"), true);
        Container contentPanel = this._errorDialog.getContentPane();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.add(new JLabel(Bundle.getMessage("ErrorHandlingDialog_Name", item.getShortDescription())));
        contentPanel.add(Box.createVerticalStrut(10));
        contentPanel.add(new JLabel(String.valueOf(errorMessage) + "     "));
        contentPanel.add(Box.createVerticalStrut(10));
        contentPanel.add(this._disableConditionalNGCheckBox);
        this._disableConditionalNGCheckBox.setAlignmentX(0.0f);
        contentPanel.add(this._disableLogixNGCheckBox);
        this._disableLogixNGCheckBox.setAlignmentX(0.0f);
        contentPanel.add(this._stopAllLogixNGCheckBox);
        this._stopAllLogixNGCheckBox.setAlignmentX(0.0f);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        contentPanel.add(panel3);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        JButton abortButton = new JButton(Bundle.getMessage("ErrorHandlingDialog_Abort"));
        panel5.add(abortButton);
        abortButton.addActionListener(e -> this.abortPressed(null));
        JButton continueButton = new JButton(Bundle.getMessage("ErrorHandlingDialog_Continue"));
        panel5.add(continueButton);
        continueButton.addActionListener(e -> this.continuePressed(null));
        this._errorDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ErrorHandlingDialog.this.continuePressed(null);
            }
        });
        contentPanel.add(panel5);
        this._errorDialog.setLocationRelativeTo(null);
        this._errorDialog.pack();
        this._errorDialog.setVisible(true);
        return this._abortExecution;
    }

    private void handleCheckBoxes() {
        if (this._disableConditionalNGCheckBox.isSelected()) {
            this._item.getConditionalNG().setEnabled(false);
        }
        if (this._disableLogixNGCheckBox.isSelected()) {
            this._item.getLogixNG().setEnabled(false);
        }
        if (this._stopAllLogixNGCheckBox.isSelected()) {
            InstanceManager.getDefault(LogixNG_Manager.class).deActivateAllLogixNGs();
        }
    }

    private void abortPressed(ActionEvent e) {
        this._errorDialog.setVisible(false);
        this._errorDialog.dispose();
        this._errorDialog = null;
        this._abortExecution = true;
        this.handleCheckBoxes();
    }

    private void continuePressed(ActionEvent e) {
        this._errorDialog.setVisible(false);
        this._errorDialog.dispose();
        this._errorDialog = null;
        this.handleCheckBoxes();
    }
}

