/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation.configurexml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.MaleStringExpressionSocket;
import jmri.jmrit.logixng.StringExpressionManager;
import jmri.jmrit.logixng.implementation.DefaultMaleStringExpressionSocket;
import jmri.jmrit.logixng.implementation.DefaultStringExpressionManager;
import jmri.jmrit.logixng.implementation.configurexml.AbstractManagerXml;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.util.ThreadingUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStringExpressionManagerXml
extends AbstractManagerXml {
    private final Map<String, Class<?>> xmlClasses = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(DefaultStringExpressionManagerXml.class);

    @Override
    public Element store(Object o) {
        Element expressions = new Element("LogixNGStringExpressions");
        this.setStoreElementClass(expressions);
        StringExpressionManager tm = (StringExpressionManager)o;
        if (tm != null) {
            if (tm.getNamedBeanSet().isEmpty()) {
                return null;
            }
            for (MaleStringExpressionSocket expression : tm.getNamedBeanSet()) {
                log.debug("expression system name is " + expression.getSystemName());
                try {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    MaleStringExpressionSocket a = expression;
                    while (!(a instanceof DefaultMaleStringExpressionSocket)) {
                        elements.add(this.storeMaleSocket(a));
                        a = (MaleStringExpressionSocket)a.getObject();
                    }
                    Element e = ConfigXmlManager.elementFromObject(a.getObject());
                    if (e != null) {
                        for (Element ee : elements) {
                            e.addContent((Content)ee);
                        }
                        expressions.addContent((Content)e);
                        continue;
                    }
                    throw new RuntimeException("Cannot load xml configurator for " + a.getObject().getClass().getName());
                }
                catch (RuntimeException e) {
                    log.error("Error storing action: {}", (Object)e, (Object)e);
                }
            }
        }
        return expressions;
    }

    public void setStoreElementClass(Element expressions) {
        expressions.setAttribute("class", this.getClass().getName());
    }

    @Override
    public boolean load(Element sharedExpression, Element perNodeExpression) {
        this.replaceExpressionManager();
        this.loadExpressions(sharedExpression);
        return true;
    }

    public void loadExpressions(Element expressions) {
        List expressionList = expressions.getChildren();
        log.debug("Found " + expressionList.size() + " actions");
        int i = 0;
        while (i < expressionList.size()) {
            block12: {
                String className = ((Element)expressionList.get(i)).getAttribute("class").getValue();
                Class<?> clazz = this.xmlClasses.get(className);
                if (clazz == null) {
                    try {
                        clazz = Class.forName(className);
                        this.xmlClasses.put(className, clazz);
                    }
                    catch (ClassNotFoundException ex) {
                        log.error("cannot load class " + className, (Throwable)ex);
                    }
                }
                if (clazz != null) {
                    Constructor<?> c = null;
                    try {
                        c = clazz.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException | SecurityException ex) {
                        log.error("cannot create constructor", (Throwable)ex);
                    }
                    if (c != null) {
                        try {
                            AbstractNamedBeanManagerConfigXML o = (AbstractNamedBeanManagerConfigXML)c.newInstance(new Object[0]);
                            MaleSocket oldLastItem = InstanceManager.getDefault(StringExpressionManager.class).getLastRegisteredMaleSocket();
                            o.load((Element)expressionList.get(i), null);
                            MaleSocket newLastItem = InstanceManager.getDefault(StringExpressionManager.class).getLastRegisteredMaleSocket();
                            if (newLastItem != oldLastItem) {
                                this.loadMaleSocket((Element)expressionList.get(i), newLastItem);
                                break block12;
                            }
                            throw new RuntimeException("No new bean has been added. This class: " + this.getClass().getName());
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                            log.error("cannot create object", (Throwable)ex);
                        }
                        catch (JmriConfigureXmlException ex) {
                            log.error("cannot load action", (Throwable)ex);
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void replaceExpressionManager() {
        ConfigureManager cmOD;
        if (InstanceManager.getDefault(StringExpressionManager.class).getClass().getName().equals(DefaultStringExpressionManager.class.getName())) {
            return;
        }
        if (InstanceManager.getNullableDefault(StringExpressionManager.class) != null && (cmOD = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            cmOD.deregister(InstanceManager.getDefault(StringExpressionManager.class));
        }
        ThreadingUtil.runOnGUI(() -> {
            DefaultStringExpressionManager pManager = DefaultStringExpressionManager.instance();
            InstanceManager.store(pManager, StringExpressionManager.class);
            ConfigureManager cmOD = InstanceManager.getNullableDefault(ConfigureManager.class);
            if (cmOD != null) {
                cmOD.registerConfig(pManager, 380);
            }
        });
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(StringExpressionManager.class).getXMLOrder();
    }
}

