/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation.configurexml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.MaleStringActionSocket;
import jmri.jmrit.logixng.StringActionManager;
import jmri.jmrit.logixng.implementation.DefaultMaleStringActionSocket;
import jmri.jmrit.logixng.implementation.DefaultStringActionManager;
import jmri.jmrit.logixng.implementation.configurexml.AbstractManagerXml;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.util.ThreadingUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStringActionManagerXml
extends AbstractManagerXml {
    private final Map<String, Class<?>> xmlClasses = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(DefaultStringActionManagerXml.class);

    @Override
    public Element store(Object o) {
        Element actions = new Element("LogixNGStringActions");
        this.setStoreElementClass(actions);
        StringActionManager tm = (StringActionManager)o;
        if (tm != null) {
            if (tm.getNamedBeanSet().isEmpty()) {
                return null;
            }
            for (MaleStringActionSocket action : tm.getNamedBeanSet()) {
                log.debug("action system name is " + action.getSystemName());
                try {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    MaleStringActionSocket a = action;
                    while (!(a instanceof DefaultMaleStringActionSocket)) {
                        elements.add(this.storeMaleSocket(a));
                        a = (MaleStringActionSocket)a.getObject();
                    }
                    Element e = ConfigXmlManager.elementFromObject(a.getObject());
                    if (e != null) {
                        for (Element ee : elements) {
                            e.addContent((Content)ee);
                        }
                        actions.addContent((Content)e);
                        continue;
                    }
                    throw new RuntimeException("Cannot load xml configurator for " + a.getObject().getClass().getName());
                }
                catch (RuntimeException e) {
                    log.error("Error storing action: {}", (Object)e, (Object)e);
                }
            }
        }
        return actions;
    }

    public void setStoreElementClass(Element actions) {
        actions.setAttribute("class", this.getClass().getName());
    }

    @Override
    public boolean load(Element sharedAction, Element perNodeAction) {
        this.replaceActionManager();
        this.loadActions(sharedAction);
        return true;
    }

    public void loadActions(Element actions) {
        List actionList = actions.getChildren();
        log.debug("Found " + actionList.size() + " actions");
        int i = 0;
        while (i < actionList.size()) {
            block12: {
                String className = ((Element)actionList.get(i)).getAttribute("class").getValue();
                Class<?> clazz = this.xmlClasses.get(className);
                if (clazz == null) {
                    try {
                        clazz = Class.forName(className);
                        this.xmlClasses.put(className, clazz);
                    }
                    catch (ClassNotFoundException ex) {
                        log.error("cannot load class " + className, (Throwable)ex);
                    }
                }
                if (clazz != null) {
                    Constructor<?> c = null;
                    try {
                        c = clazz.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException | SecurityException ex) {
                        log.error("cannot create constructor", (Throwable)ex);
                    }
                    if (c != null) {
                        try {
                            AbstractNamedBeanManagerConfigXML o = (AbstractNamedBeanManagerConfigXML)c.newInstance(new Object[0]);
                            MaleSocket oldLastItem = InstanceManager.getDefault(StringActionManager.class).getLastRegisteredMaleSocket();
                            o.load((Element)actionList.get(i), null);
                            MaleSocket newLastItem = InstanceManager.getDefault(StringActionManager.class).getLastRegisteredMaleSocket();
                            if (newLastItem != oldLastItem) {
                                this.loadMaleSocket((Element)actionList.get(i), newLastItem);
                                break block12;
                            }
                            throw new RuntimeException("No new bean has been added. This class: " + this.getClass().getName());
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                            log.error("cannot create object", (Throwable)ex);
                        }
                        catch (JmriConfigureXmlException ex) {
                            log.error("cannot load action", (Throwable)ex);
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void replaceActionManager() {
        ConfigureManager cmOD;
        if (InstanceManager.getDefault(StringActionManager.class).getClass().getName().equals(DefaultStringActionManager.class.getName())) {
            return;
        }
        if (InstanceManager.getNullableDefault(StringActionManager.class) != null && (cmOD = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            cmOD.deregister(InstanceManager.getDefault(StringActionManager.class));
        }
        ThreadingUtil.runOnGUI(() -> {
            DefaultStringActionManager pManager = DefaultStringActionManager.instance();
            InstanceManager.store(pManager, StringActionManager.class);
            ConfigureManager cmOD = InstanceManager.getNullableDefault(ConfigureManager.class);
            if (cmOD != null) {
                cmOD.registerConfig(pManager, 390);
            }
        });
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(StringActionManager.class).getXMLOrder();
    }
}

