/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.logixng.FemaleSocketManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.ModuleManager;
import jmri.jmrit.logixng.implementation.DefaultModule;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModuleXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(DefaultModuleXml.class);

    @Override
    public Element store(Object o) {
        DefaultModule p = (DefaultModule)o;
        Element element = new Element("Module");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        element.addContent((Content)new Element("rootSocketType").addContent(p.getRootSocketType().getName()));
        Element elementParameters = new Element("Parameters");
        for (Module.Parameter data : p.getParameters()) {
            Element elementParameter = new Element("Parameter");
            elementParameter.addContent((Content)new Element("name").addContent(data.getName()));
            elementParameter.addContent((Content)new Element("isInput").addContent(data.isInput() ? "yes" : "no"));
            elementParameter.addContent((Content)new Element("isOutput").addContent(data.isOutput() ? "yes" : "no"));
            elementParameters.addContent((Content)elementParameter);
        }
        element.addContent((Content)elementParameters);
        Element e2 = new Element("RootSocket");
        e2.addContent((Content)new Element("socketName").addContent(p.getChild(0).getName()));
        MaleSocket socket = p.getRootSocket().getConnectedSocket();
        String socketSystemName = socket != null ? socket.getSystemName() : p.getSocketSystemName();
        if (socketSystemName != null) {
            e2.addContent((Content)new Element("systemName").addContent(socketSystemName));
        }
        element.addContent((Content)e2);
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        String rootSocketTypeName = shared.getChild("rootSocketType").getTextTrim();
        FemaleSocketManager.SocketType socketType = InstanceManager.getDefault(FemaleSocketManager.class).getSocketTypeByType(rootSocketTypeName);
        DefaultModule h = (DefaultModule)InstanceManager.getDefault(ModuleManager.class).createModule(sys, uname, socketType);
        this.loadCommon(h, shared);
        List parameterList = shared.getChild("Parameters").getChildren();
        log.debug("Found " + parameterList.size() + " parameters");
        for (Element e : parameterList) {
            Element elementName = e.getChild("name");
            boolean isInput = "yes".equals(e.getChild("isInput").getTextTrim());
            boolean isOutput = "yes".equals(e.getChild("isOutput").getTextTrim());
            h.addParameter(elementName.getTextTrim(), isInput, isOutput);
        }
        Element socketName = shared.getChild("RootSocket").getChild("socketName");
        h.getChild(0).setName(socketName.getTextTrim());
        Element socketSystemName = shared.getChild("RootSocket").getChild("systemName");
        if (socketSystemName != null) {
            h.setSocketSystemName(socketSystemName.getTextTrim());
        }
        return true;
    }
}

