/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation.configurexml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.ConfigXmlManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Clipboard;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNG_InitializationManager;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.implementation.ClipboardMany;
import jmri.jmrit.logixng.implementation.DefaultClipboard;
import jmri.jmrit.logixng.implementation.DefaultLogixNG;
import jmri.jmrit.logixng.implementation.DefaultLogixNGManager;
import jmri.jmrit.logixng.implementation.configurexml.ClipboardManyXml;
import jmri.jmrit.logixng.util.LogixNG_Thread;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.util.ThreadingUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogixNGManagerXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(DefaultLogixNGManagerXml.class);

    @Override
    public Element store(Object o) {
        boolean hasData = false;
        Element logixNGs = new Element("LogixNGs");
        this.setStoreElementClass(logixNGs);
        LogixNG_Manager tm = (LogixNG_Manager)o;
        if (tm != null) {
            Element e;
            for (LogixNG_Thread thread : LogixNG_Thread.getThreads()) {
                Element e2 = new Element("Thread");
                e2.addContent((Content)new Element("id").addContent(Integer.toString(thread.getThreadId())));
                e2.addContent((Content)new Element("name").addContent(thread.getThreadName()));
                logixNGs.addContent((Content)e2);
            }
            for (LogixNG logixNG : tm.getNamedBeanSet()) {
                log.debug("logixng system name is " + logixNG.getSystemName());
                boolean enabled = logixNG.isEnabled();
                Element elem = new Element("LogixNG");
                elem.addContent((Content)new Element("systemName").addContent(logixNG.getSystemName()));
                this.storeCommon(logixNG, elem);
                e = new Element("ConditionalNGs");
                int i = 0;
                while (i < logixNG.getNumConditionalNGs()) {
                    e.addContent((Content)new Element("systemName").addContent(logixNG.getConditionalNG(i).getSystemName()));
                    ++i;
                }
                elem.addContent((Content)e);
                elem.setAttribute("enabled", enabled ? "yes" : "no");
                logixNGs.addContent((Content)elem);
                hasData = true;
            }
            Element elemInitializationTable = new Element("InitializationTable");
            for (LogixNG logixNG : InstanceManager.getDefault(LogixNG_InitializationManager.class).getList()) {
                Element e3 = new Element("LogixNG").addContent(logixNG.getSystemName());
                elemInitializationTable.addContent((Content)e3);
            }
            logixNGs.addContent((Content)elemInitializationTable);
            Element elemClipboard = new Element("Clipboard");
            Clipboard clipboard = tm.getClipboard();
            if (clipboard.getFemaleSocket().isConnected()) {
                Base rootObject = clipboard.getFemaleSocket().getConnectedSocket().getObject();
                try {
                    e = ConfigXmlManager.elementFromObject(rootObject);
                    if (e != null) {
                        elemClipboard.addContent((Content)e);
                    }
                }
                catch (Exception e4) {
                    log.error("Error storing action: {}", (Object)e4, (Object)e4);
                }
            }
            logixNGs.addContent((Content)elemClipboard);
        }
        return hasData ? logixNGs : null;
    }

    public void setStoreElementClass(Element logixngs) {
        logixngs.setAttribute("class", this.getClass().getName());
    }

    @Override
    public boolean load(Element sharedLogixNG, Element perNodeLogixNG) {
        this.replaceLogixNGManager();
        this.loadThreads(sharedLogixNG);
        this.loadLogixNGs(sharedLogixNG);
        this.loadInitializationTable(sharedLogixNG);
        this.loadClipboard(sharedLogixNG);
        return true;
    }

    public void loadThreads(Element sharedLogixNG) {
        List threads = sharedLogixNG.getChildren("Thread");
        log.debug("Found " + threads.size() + " threads");
        int i = 0;
        while (i < threads.size()) {
            Element threadElement = (Element)threads.get(i);
            int threadId = Integer.parseInt(threadElement.getChild("id").getTextTrim());
            String threadName = threadElement.getChild("name").getTextTrim();
            log.debug("create thread: " + Integer.toString(threadId) + ", " + threadName);
            LogixNG_Thread.createNewThread(threadId, threadName);
            ++i;
        }
    }

    public void loadLogixNGs(Element sharedLogixNG) {
        List logixNGList = sharedLogixNG.getChildren("LogixNG");
        log.debug("Found " + logixNGList.size() + " logixngs");
        LogixNG_Manager tm = InstanceManager.getDefault(LogixNG_Manager.class);
        int i = 0;
        while (i < logixNGList.size()) {
            Element logixNG_Element = (Element)logixNGList.get(i);
            String sysName = this.getSystemName(logixNG_Element);
            if (sysName == null) {
                log.warn("unexpected null in systemName " + logixNG_Element);
                break;
            }
            String userName = this.getUserName(logixNG_Element);
            String yesno = "";
            if (((Element)logixNGList.get(i)).getAttribute("enabled") != null) {
                yesno = logixNG_Element.getAttribute("enabled").getValue();
            }
            log.debug("create logixng: (" + sysName + ")(" + (userName == null ? "<null>" : userName) + ")");
            DefaultLogixNG logixNG = (DefaultLogixNG)tm.createLogixNG(sysName, userName);
            if (logixNG != null) {
                this.loadCommon(logixNG, (Element)logixNGList.get(i));
                if (yesno != null && !yesno.equals("")) {
                    if (yesno.equals("yes")) {
                        logixNG.setEnabled(true);
                    } else if (yesno.equals("no")) {
                        logixNG.setEnabled(false);
                    }
                }
                List conditionalNGList = logixNG_Element.getChild("ConditionalNGs").getChildren();
                int j = 0;
                while (j < conditionalNGList.size()) {
                    Element systemNameElement = (Element)conditionalNGList.get(j);
                    String systemName = null;
                    if (systemNameElement != null) {
                        systemName = systemNameElement.getTextTrim();
                    }
                    logixNG.setConditionalNG_SystemName(j, systemName);
                    ++j;
                }
            }
            ++i;
        }
    }

    public void loadInitializationTable(Element sharedLogixNG) {
        LogixNG_Manager tm = InstanceManager.getDefault(LogixNG_Manager.class);
        LogixNG_InitializationManager initializationManager = InstanceManager.getDefault(LogixNG_InitializationManager.class);
        List initTableList = sharedLogixNG.getChildren("InitializationTable");
        if (initTableList.isEmpty()) {
            return;
        }
        List logixNGList = ((Element)initTableList.get(0)).getChildren();
        if (logixNGList.isEmpty()) {
            return;
        }
        for (Element e : logixNGList) {
            LogixNG logixNG = tm.getBySystemName(e.getTextTrim());
            if (logixNG != null) {
                initializationManager.add(logixNG);
                continue;
            }
            log.warn("LogixNG '{}' cannot be found", (Object)e.getTextTrim());
        }
    }

    public void loadClipboard(Element sharedLogixNG) {
        Constructor<?> c;
        Class<?> clazz;
        List clipboardList = sharedLogixNG.getChildren("Clipboard");
        if (clipboardList.isEmpty()) {
            return;
        }
        List clipboardSubList = ((Element)clipboardList.get(0)).getChildren();
        if (clipboardSubList.isEmpty()) {
            return;
        }
        String className = ((Element)clipboardSubList.get(0)).getAttribute("class").getValue();
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            log.error("cannot load class " + className, (Throwable)ex);
            return;
        }
        try {
            c = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            log.error("cannot create constructor", (Throwable)ex);
            return;
        }
        try {
            Object o = c.newInstance(new Object[0]);
            if (o == null) {
                log.error("class is null");
                return;
            }
            if (!(o instanceof ClipboardManyXml)) {
                log.error("class has wrong type: " + o.getClass().getName());
                return;
            }
            LogixNG_Manager tm = InstanceManager.getDefault(LogixNG_Manager.class);
            ClipboardMany anyMany = ((ClipboardManyXml)o).loadItem((Element)clipboardList.get(0));
            ArrayList<String> errors = new ArrayList<String>();
            if (!((DefaultClipboard)tm.getClipboard()).replaceClipboardItems(anyMany, errors)) {
                for (String s : errors) {
                    log.error(s);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            log.error("cannot create object", (Throwable)ex);
        }
    }

    protected void replaceLogixNGManager() {
        ConfigureManager cmOD;
        if (InstanceManager.getDefault(LogixNG_Manager.class).getClass().getName().equals(DefaultLogixNGManager.class.getName())) {
            return;
        }
        if (InstanceManager.getNullableDefault(LogixNG_Manager.class) != null && (cmOD = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            cmOD.deregister(InstanceManager.getDefault(LogixNG_Manager.class));
        }
        ThreadingUtil.runOnGUI(() -> {
            DefaultLogixNGManager pManager = DefaultLogixNGManager.instance();
            InstanceManager.store(pManager, LogixNG_Manager.class);
            ConfigureManager cmOD = InstanceManager.getNullableDefault(ConfigureManager.class);
            if (cmOD != null) {
                cmOD.registerConfig(pManager, 290);
            }
        });
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(LogixNG_Manager.class).getXMLOrder();
    }
}

