/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation.configurexml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmri.configurexml.ConfigXmlManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.configurexml.MaleSocketXml;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManagerXml
extends AbstractNamedBeanManagerConfigXML {
    private final Map<String, Class<?>> xmlClasses = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(AbstractManagerXml.class);

    public Element storeMaleSocket(MaleSocket maleSocket) {
        Element element = new Element("MaleSocket");
        Base m = maleSocket;
        while (m instanceof MaleSocket) {
            MaleSocket ms;
            block4: {
                ms = m;
                try {
                    Element e = ConfigXmlManager.elementFromObject(ms);
                    if (e != null) {
                        element.addContent((Content)e);
                        break block4;
                    }
                    throw new RuntimeException("Cannot load xml configurator for " + ms.getClass().getName());
                }
                catch (RuntimeException e) {
                    log.error("Error storing maleSocket: {}", (Object)e, (Object)e);
                }
            }
            m = ms.getObject();
        }
        return element;
    }

    public void loadMaleSocket(Element element, MaleSocket maleSocket) {
        HashMap<String, AbstractMap.SimpleEntry<MaleSocketXml, Element>> maleSocketXmlClasses = new HashMap<String, AbstractMap.SimpleEntry<MaleSocketXml, Element>>();
        Element elementMaleSocket = element.getChild("MaleSocket");
        if (elementMaleSocket == null) {
            throw new IllegalArgumentException("maleSocket is null");
        }
        List children = elementMaleSocket.getChildren();
        log.debug("Found " + children.size() + " male sockets");
        for (Element e : children) {
            String className = e.getAttribute("class").getValue();
            Class<?> clazz = this.xmlClasses.get(className);
            if (clazz == null) {
                try {
                    clazz = Class.forName(className);
                    this.xmlClasses.put(className, clazz);
                }
                catch (ClassNotFoundException ex) {
                    log.error("cannot load class " + className, (Throwable)ex);
                }
            }
            if (clazz == null) continue;
            Constructor<?> c = null;
            try {
                c = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                log.error("cannot create constructor", (Throwable)ex);
            }
            if (c == null) continue;
            try {
                MaleSocketXml o = (MaleSocketXml)c.newInstance(new Object[0]);
                AbstractMap.SimpleEntry<MaleSocketXml, Element> entry = new AbstractMap.SimpleEntry<MaleSocketXml, Element>(o, e);
                maleSocketXmlClasses.put(className, entry);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                log.error("cannot create object", (Throwable)ex);
            }
        }
        Base m = maleSocket;
        while (m instanceof MaleSocket) {
            MaleSocket ms = m;
            String cName = ConfigXmlManager.adapterName(ms);
            Map.Entry entry = (Map.Entry)maleSocketXmlClasses.get(cName);
            try {
                ((MaleSocketXml)entry.getKey()).load((Element)entry.getValue(), ms);
            }
            catch (RuntimeException ex) {
                log.error("Error loading maleSocket: {}", (Object)ex, (Object)ex);
            }
            m = ms.getObject();
        }
    }
}

