/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation.configurexml;

import java.util.List;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.configurexml.MaleSocketXml;
import jmri.jmrit.logixng.implementation.AbstractMaleSocket;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMaleSocketXml
extends AbstractNamedBeanManagerConfigXML
implements MaleSocketXml {
    private static final Logger log = LoggerFactory.getLogger(AbstractMaleSocketXml.class);

    @Override
    public Element store(Object o) {
        AbstractMaleSocket maleSocket = (AbstractMaleSocket)o;
        Element element = new Element("AbstractMaleSocket");
        element.setAttribute("enabled", maleSocket.isEnabled() ? "yes" : "no");
        element.setAttribute("locked", maleSocket.isLocked() ? "yes" : "no");
        element.setAttribute("system", maleSocket.isSystem() ? "yes" : "no");
        element.setAttribute("catchAbortExecution", maleSocket.getCatchAbortExecution() ? "yes" : "no");
        element.setAttribute("class", this.getClass().getName());
        if (!(maleSocket.getObject() instanceof MaleSocket)) {
            element.addContent((Content)new Element("errorHandling").addContent(maleSocket.getErrorHandlingType().name()));
        }
        for (SymbolTable.VariableData data : maleSocket.getLocalVariables()) {
            Element elementVariable = new Element("LocalVariable");
            elementVariable.addContent((Content)new Element("name").addContent(data._name));
            elementVariable.addContent((Content)new Element("type").addContent(data._initialValueType.name()));
            elementVariable.addContent((Content)new Element("data").addContent(data._initialValueData));
            element.addContent((Content)elementVariable);
        }
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        return false;
    }

    @Override
    public boolean load(Element maleSocketElement, MaleSocket maleSocket) {
        if (!(maleSocket instanceof AbstractMaleSocket)) {
            throw new IllegalArgumentException("maleSocket is not an AbstractMaleSocket: " + maleSocket.getClass().getName());
        }
        String enabled = "yes";
        if (maleSocketElement.getAttribute("enabled") != null) {
            enabled = maleSocketElement.getAttribute("enabled").getValue();
        }
        ((AbstractMaleSocket)maleSocket).setEnabledFlag("yes".equals(enabled));
        String locked = "no";
        if (maleSocketElement.getAttribute("locked") != null) {
            locked = maleSocketElement.getAttribute("locked").getValue();
        }
        ((AbstractMaleSocket)maleSocket).setLocked("yes".equals(locked));
        String system = "no";
        if (maleSocketElement.getAttribute("system") != null) {
            system = maleSocketElement.getAttribute("system").getValue();
        }
        ((AbstractMaleSocket)maleSocket).setSystem("yes".equals(system));
        String catchAbortExecution = "no";
        if (maleSocketElement.getAttribute("catchAbortExecution") != null) {
            catchAbortExecution = maleSocketElement.getAttribute("catchAbortExecution").getValue();
        }
        ((AbstractMaleSocket)maleSocket).setCatchAbortExecution("yes".equals(catchAbortExecution));
        Element errorHandlingElement = maleSocketElement.getChild("errorHandling");
        if (errorHandlingElement != null) {
            maleSocket.setErrorHandlingType(MaleSocket.ErrorHandlingType.valueOf(errorHandlingElement.getTextTrim()));
        }
        List localVariableList = maleSocketElement.getChildren("LocalVariable");
        log.debug("Found " + localVariableList.size() + " male sockets");
        for (Element e : localVariableList) {
            Element elementName = e.getChild("name");
            SymbolTable.InitialValueType type = null;
            Element elementType = e.getChild("type");
            if (elementType != null) {
                type = SymbolTable.InitialValueType.valueOf(elementType.getTextTrim());
            }
            Element elementData = e.getChild("data");
            if (elementName == null) {
                throw new IllegalArgumentException("Element 'name' does not exists");
            }
            if (type == null) {
                throw new IllegalArgumentException("Element 'type' does not exists");
            }
            if (elementData == null) {
                throw new IllegalArgumentException("Element 'data' does not exists");
            }
            maleSocket.addLocalVariable(elementName.getTextTrim(), type, elementData.getTextTrim());
        }
        return true;
    }
}

