/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.Stack;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.implementation.DefaultStack;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.LocalVariableExpressionVariable;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSymbolTable
implements SymbolTable {
    private final SymbolTable _prevSymbolTable;
    private final Stack _stack;
    private final int _firstSymbolIndex;
    private final Map<String, SymbolTable.Symbol> _symbols = new HashMap<String, SymbolTable.Symbol>();
    private static final Logger log = LoggerFactory.getLogger(DefaultSymbolTable.class);

    public DefaultSymbolTable() {
        this._prevSymbolTable = null;
        this._stack = new DefaultStack();
        this._firstSymbolIndex = this._stack.getCount();
    }

    public DefaultSymbolTable(ConditionalNG currentConditionalNG) {
        this._prevSymbolTable = currentConditionalNG.getSymbolTable();
        this._stack = currentConditionalNG.getStack();
        this._firstSymbolIndex = this._stack.getCount();
    }

    public DefaultSymbolTable(SymbolTable prevSymbolTable) {
        this._prevSymbolTable = null;
        this._symbols.putAll(prevSymbolTable.getSymbols());
        this._stack = new DefaultStack();
        int i = 0;
        while (i < prevSymbolTable.getStack().getCount()) {
            this._stack.setValueAtIndex(i, prevSymbolTable.getStack().getValueAtIndex(i));
            ++i;
        }
        this._firstSymbolIndex = this._stack.getCount();
    }

    public SymbolTable getPrevSymbolTable() {
        return this._prevSymbolTable;
    }

    @Override
    public Map<String, SymbolTable.Symbol> getSymbols() {
        return Collections.unmodifiableMap(this._symbols);
    }

    @Override
    public Map<String, Object> getSymbolValues() {
        HashMap<String, Object> symbolValues = new HashMap<String, Object>();
        for (SymbolTable.Symbol symbol : this._symbols.values()) {
            Object value = this._stack.getValueAtIndex(this._firstSymbolIndex + symbol.getIndex());
            symbolValues.put(symbol.getName(), value);
        }
        return Collections.unmodifiableMap(symbolValues);
    }

    @Override
    public Object getValue(String name) {
        SymbolTable.Symbol symbol = this._symbols.get(name);
        if (symbol == null) {
            throw new SymbolTable.SymbolNotFound(String.format("Symbol '%s' does not exist in symbol table", name));
        }
        return this._stack.getValueAtIndex(this._firstSymbolIndex + symbol.getIndex());
    }

    @Override
    public boolean hasValue(String name) {
        return this._symbols.containsKey(name);
    }

    @Override
    public void setValue(String name, Object value) {
        if (this._symbols.get(name) == null) {
            throw new IllegalArgumentException("The symbol " + name + " does not exist in the symbol table");
        }
        this._stack.setValueAtIndex(this._firstSymbolIndex + this._symbols.get(name).getIndex(), value);
    }

    @Override
    public void printSymbolTable(PrintWriter stream) {
        stream.format("printSymbolTable:%n", new Object[0]);
        for (Map.Entry<String, SymbolTable.Symbol> entry : this._symbols.entrySet()) {
            stream.format("Key: %s, Name: %s, Index: %d, Value: %s%n", entry.getKey(), entry.getValue().getName(), entry.getValue().getIndex(), this._stack.getValueAtIndex(this._firstSymbolIndex + entry.getValue().getIndex()));
        }
        stream.format("printSymbolTable done%n", new Object[0]);
    }

    private RecursiveDescentParser createParser() throws ParserException {
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        for (SymbolTable.Symbol symbol : this.getSymbols().values()) {
            variables.put(symbol.getName(), new LocalVariableExpressionVariable(symbol.getName()));
        }
        return new RecursiveDescentParser(variables);
    }

    @Override
    public void createSymbols(Collection<? extends SymbolTable.VariableData> symbolDefinitions) throws JmriException {
        this.createSymbols(this, symbolDefinitions);
    }

    @Override
    public void createSymbols(SymbolTable symbolTable, Collection<? extends SymbolTable.VariableData> symbolDefinitions) throws JmriException {
        for (SymbolTable.VariableData variableData : symbolDefinitions) {
            DefaultSymbol symbol = new DefaultSymbol(variableData.getName(), this._stack.getCount() - this._firstSymbolIndex);
            Object initialValue = null;
            if (this._symbols.containsKey(symbol.getName())) {
                throw new IllegalArgumentException("Symbol table already contains the variable " + symbol.getName());
            }
            switch (variableData.getInitialValueType()) {
                case None: {
                    break;
                }
                case Integer: {
                    initialValue = Long.parseLong(variableData.getInitialValueData());
                    break;
                }
                case FloatingNumber: {
                    initialValue = Double.parseDouble(variableData.getInitialValueData());
                    break;
                }
                case String: {
                    initialValue = variableData.getInitialValueData();
                    break;
                }
                case Array: {
                    ArrayList<Object> array = new ArrayList<Object>();
                    initialValue = array;
                    String initialValueData = variableData.getInitialValueData();
                    if (initialValueData.isEmpty()) break;
                    Object data = "";
                    String[] parts = initialValueData.split(":", 2);
                    if (parts.length > 1) {
                        initialValueData = parts[0];
                        if (Character.isDigit(parts[1].charAt(0))) {
                            try {
                                data = Long.parseLong(parts[1]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                try {
                                    data = Double.parseDouble(parts[1]);
                                }
                                catch (NumberFormatException e2) {
                                    throw new IllegalArgumentException("Data is not a number", e2);
                                }
                            }
                        } else {
                            data = parts[1].charAt(0) == '\"' && parts[1].charAt(parts[1].length() - 1) == '\"' ? parts[1].substring(1, parts[1].length() - 1) : symbolTable.getValue(parts[1]).toString();
                        }
                    }
                    try {
                        int count = Character.isDigit(initialValueData.charAt(0)) ? Integer.parseInt(initialValueData) : Integer.parseInt(symbolTable.getValue(initialValueData).toString());
                        int i = 0;
                        while (i < count) {
                            array.add(data);
                            ++i;
                        }
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Initial capacity is not an integer", e);
                    }
                }
                case Map: {
                    initialValue = new HashMap();
                    break;
                }
                case LocalVariable: {
                    initialValue = symbolTable.getValue(variableData.getInitialValueData());
                    break;
                }
                case Memory: {
                    Memory m = (Memory)InstanceManager.getDefault(MemoryManager.class).getNamedBean(variableData.getInitialValueData());
                    if (m == null) break;
                    initialValue = m.getValue();
                    break;
                }
                case Reference: {
                    if (ReferenceUtil.isReference(variableData.getInitialValueData())) {
                        initialValue = ReferenceUtil.getReference(symbolTable, variableData.getInitialValueData());
                        break;
                    }
                    log.error("\"{}\" is not a reference", (Object)variableData.getInitialValueData());
                    break;
                }
                case Formula: {
                    RecursiveDescentParser parser = this.createParser();
                    ExpressionNode expressionNode = parser.parseExpression(variableData.getInitialValueData());
                    initialValue = expressionNode.calculate(symbolTable);
                    break;
                }
                default: {
                    log.error("definition._initialValueType has invalid value: {}", (Object)variableData.getInitialValueType().name());
                    throw new IllegalArgumentException("definition._initialValueType has invalid value: " + variableData.getInitialValueType().name());
                }
            }
            this._stack.push(initialValue);
            this._symbols.put(symbol.getName(), symbol);
        }
    }

    @Override
    public void removeSymbols(Collection<? extends SymbolTable.VariableData> symbolDefinitions) throws JmriException {
        symbolDefinitions.forEach(parameter -> this._symbols.remove(parameter.getName()));
    }

    @Override
    public Stack getStack() {
        return this._stack;
    }

    public static class DefaultParameter
    implements Module.Parameter {
        private String _name;
        private boolean _isInput;
        private boolean _isOutput;

        public DefaultParameter(String name, boolean isInput, boolean isOutput) {
            this._name = name;
            this._isInput = isInput;
            this._isOutput = isOutput;
        }

        public DefaultParameter(Module.Parameter parameter) {
            this._name = parameter.getName();
            this._isInput = parameter.isInput();
            this._isOutput = parameter.isOutput();
        }

        @Override
        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        @Override
        public boolean isInput() {
            return this._isInput;
        }

        public void setIsInput(boolean value) {
            this._isInput = value;
        }

        @Override
        public boolean isOutput() {
            return this._isOutput;
        }

        public void setIsOutput(boolean value) {
            this._isOutput = value;
        }
    }

    public static class DefaultSymbol
    implements SymbolTable.Symbol {
        private final String _name;
        private final int _index;

        public DefaultSymbol(String name, int index) {
            this._name = name;
            this._index = index;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public int getIndex() {
            return this._index;
        }
    }
}

