/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InvokeOnGuiThread;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.FemaleStringExpressionSocket;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.MaleStringExpressionSocket;
import jmri.jmrit.logixng.MaleStringExpressionSocketFactory;
import jmri.jmrit.logixng.StringExpressionBean;
import jmri.jmrit.logixng.StringExpressionFactory;
import jmri.jmrit.logixng.StringExpressionManager;
import jmri.jmrit.logixng.implementation.AbstractBaseManager;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleStringExpressionSocket;
import jmri.jmrit.logixng.implementation.DefaultMaleStringExpressionSocket;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStringExpressionManager
extends AbstractBaseManager<MaleStringExpressionSocket>
implements StringExpressionManager,
InstanceManagerAutoDefault {
    private final Map<Category, List<Class<? extends Base>>> expressionClassList = new HashMap<Category, List<Class<? extends Base>>>();
    private MaleSocket _lastRegisteredBean;
    static volatile DefaultStringExpressionManager _instance = null;
    private static final Logger log = LoggerFactory.getLogger(DefaultStringExpressionManager.class);

    public DefaultStringExpressionManager() {
        InstanceManager.getDefault(LogixNG_Manager.class).registerManager(this);
        for (StringExpressionFactory expressionFactory : ServiceLoader.load(StringExpressionFactory.class)) {
            expressionFactory.init();
        }
        for (Category category : Category.values()) {
            this.expressionClassList.put(category, new ArrayList());
        }
        for (StringExpressionFactory expressionFactory : ServiceLoader.load(StringExpressionFactory.class)) {
            expressionFactory.getClasses().forEach(entry -> this.expressionClassList.get(entry.getKey()).add((Class)entry.getValue()));
        }
        for (MaleStringExpressionSocketFactory maleSocketFactory : ServiceLoader.load(MaleStringExpressionSocketFactory.class)) {
            this._maleSocketFactories.add(maleSocketFactory);
        }
    }

    @Override
    public Class<? extends MaleSocket> getMaleSocketClass() {
        return DefaultMaleStringExpressionSocket.class;
    }

    protected MaleStringExpressionSocket createMaleStringExpressionSocket(StringExpressionBean expression) {
        DefaultMaleStringExpressionSocket socket = new DefaultMaleStringExpressionSocket((BaseManager<? extends NamedBean>)this, expression);
        expression.setParent(socket);
        return socket;
    }

    @Override
    public MaleSocket getLastRegisteredMaleSocket() {
        return this._lastRegisteredBean;
    }

    @Override
    public MaleStringExpressionSocket registerBean(MaleStringExpressionSocket maleSocket) {
        MaleStringExpressionSocket bean = super.registerBean(maleSocket);
        this._lastRegisteredBean = maleSocket;
        return bean;
    }

    @Override
    public MaleStringExpressionSocket registerExpression(@Nonnull StringExpressionBean expression) throws IllegalArgumentException {
        if (expression instanceof MaleStringExpressionSocket) {
            throw new IllegalArgumentException("registerExpression() cannot register a MaleStringExpressionSocket. Use the method register() instead.");
        }
        if (this.validSystemNameFormat(expression.getSystemName()) != Manager.NameValidity.VALID) {
            log.warn("SystemName " + expression.getSystemName() + " is not in the correct format");
            throw new IllegalArgumentException(String.format("System name is invalid: %s", expression.getSystemName()));
        }
        this.updateAutoNumber(expression.getSystemName());
        MaleStringExpressionSocket maleSocket = this.createMaleStringExpressionSocket(expression);
        return this.registerBean(maleSocket);
    }

    @Override
    public int getXMLOrder() {
        return 380;
    }

    @Override
    public char typeLetter() {
        return 'Q';
    }

    @Override
    public FemaleStringExpressionSocket createFemaleSocket(Base parent, FemaleSocketListener listener, String socketName) {
        return new DefaultFemaleStringExpressionSocket(parent, listener, socketName);
    }

    @Override
    public Map<Category, List<Class<? extends Base>>> getExpressionClasses() {
        return this.expressionClassList;
    }

    @Override
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameStringExpressions" : "BeanNameStringExpression");
    }

    @Override
    public void deleteStringExpression(MaleStringExpressionSocket x) {
        this.deregister(x);
        x.dispose();
    }

    @InvokeOnGuiThread
    public static DefaultStringExpressionManager instance() {
        if (!ThreadingUtil.isGUIThread()) {
            LoggingUtil.warnOnce(log, "instance() called on wrong thread", new Object[0]);
        }
        if (_instance == null) {
            _instance = new DefaultStringExpressionManager();
        }
        return _instance;
    }

    @Override
    public Class<MaleStringExpressionSocket> getNamedBeanClass() {
        return MaleStringExpressionSocket.class;
    }

    @Override
    protected MaleStringExpressionSocket castBean(MaleSocket maleSocket) {
        return (MaleStringExpressionSocket)maleSocket;
    }
}

