/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.InvokeOnGuiThread;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.FemaleStringActionSocket;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.MaleStringActionSocket;
import jmri.jmrit.logixng.MaleStringActionSocketFactory;
import jmri.jmrit.logixng.StringActionBean;
import jmri.jmrit.logixng.StringActionFactory;
import jmri.jmrit.logixng.StringActionManager;
import jmri.jmrit.logixng.implementation.AbstractBaseManager;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleStringActionSocket;
import jmri.jmrit.logixng.implementation.DefaultMaleStringActionSocket;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStringActionManager
extends AbstractBaseManager<MaleStringActionSocket>
implements StringActionManager {
    private final Map<Category, List<Class<? extends Base>>> actionClassList = new HashMap<Category, List<Class<? extends Base>>>();
    private MaleSocket _lastRegisteredBean;
    static volatile DefaultStringActionManager _instance = null;
    private static final Logger log = LoggerFactory.getLogger(DefaultStringActionManager.class);

    public DefaultStringActionManager() {
        InstanceManager.getDefault(LogixNG_Manager.class).registerManager(this);
        for (StringActionFactory actionFactory : ServiceLoader.load(StringActionFactory.class)) {
            actionFactory.init();
        }
        for (Category category : Category.values()) {
            this.actionClassList.put(category, new ArrayList());
        }
        for (StringActionFactory actionFactory : ServiceLoader.load(StringActionFactory.class)) {
            actionFactory.getClasses().forEach(entry -> this.actionClassList.get(entry.getKey()).add((Class)entry.getValue()));
        }
        for (MaleStringActionSocketFactory maleSocketFactory : ServiceLoader.load(MaleStringActionSocketFactory.class)) {
            this._maleSocketFactories.add(maleSocketFactory);
        }
    }

    @Override
    public Class<? extends MaleSocket> getMaleSocketClass() {
        return DefaultMaleStringActionSocket.class;
    }

    protected MaleStringActionSocket createMaleActionSocket(StringActionBean action) {
        DefaultMaleStringActionSocket socket = new DefaultMaleStringActionSocket((BaseManager<? extends NamedBean>)this, action);
        action.setParent(socket);
        return socket;
    }

    @Override
    public MaleSocket getLastRegisteredMaleSocket() {
        return this._lastRegisteredBean;
    }

    @Override
    public MaleStringActionSocket registerBean(MaleStringActionSocket maleSocket) {
        MaleStringActionSocket bean = super.registerBean(maleSocket);
        this._lastRegisteredBean = maleSocket;
        return bean;
    }

    @Override
    public MaleStringActionSocket registerAction(@Nonnull StringActionBean action) throws IllegalArgumentException {
        if (action instanceof MaleStringActionSocket) {
            throw new IllegalArgumentException("registerAction() cannot register a MaleStringActionSocket. Use the method register() instead.");
        }
        if (this.validSystemNameFormat(action.getSystemName()) != Manager.NameValidity.VALID) {
            log.warn("SystemName " + action.getSystemName() + " is not in the correct format");
            throw new IllegalArgumentException(String.format("System name is invalid: %s", action.getSystemName()));
        }
        this.updateAutoNumber(action.getSystemName());
        MaleStringActionSocket maleSocket = this.createMaleActionSocket(action);
        return this.registerBean(maleSocket);
    }

    @Override
    public int getXMLOrder() {
        return 390;
    }

    @Override
    public char typeLetter() {
        return 'Q';
    }

    @Override
    public FemaleStringActionSocket createFemaleSocket(Base parent, FemaleSocketListener listener, String socketName) {
        return new DefaultFemaleStringActionSocket(parent, listener, socketName);
    }

    @Override
    public Map<Category, List<Class<? extends Base>>> getActionClasses() {
        return this.actionClassList;
    }

    @Override
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameStringActions" : "BeanNameStringAction");
    }

    @Override
    public void deleteStringAction(MaleStringActionSocket x) {
        this.deregister(x);
        x.dispose();
    }

    @InvokeOnGuiThread
    public static DefaultStringActionManager instance() {
        if (!ThreadingUtil.isGUIThread()) {
            LoggingUtil.warnOnce(log, "instance() called on wrong thread", new Object[0]);
        }
        if (_instance == null) {
            _instance = new DefaultStringActionManager();
        }
        return _instance;
    }

    @Override
    public Class<MaleStringActionSocket> getNamedBeanClass() {
        return MaleStringActionSocket.class;
    }

    @Override
    protected MaleStringActionSocket castBean(MaleSocket maleSocket) {
        return (MaleStringActionSocket)maleSocket;
    }
}

