/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.InvokeOnGuiThread;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.logixng.AnonymousTable;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.implementation.AbstractNamedTable;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultAnonymousTable;
import jmri.jmrit.logixng.implementation.DefaultCsvNamedTable;
import jmri.jmrit.logixng.implementation.DefaultInternalNamedTable;
import jmri.managers.AbstractManager;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNamedTableManager
extends AbstractManager<NamedTable>
implements NamedTableManager {
    DecimalFormat paddedNumber = new DecimalFormat("0000");
    static volatile DefaultNamedTableManager _instance = null;
    private static final Logger log = LoggerFactory.getLogger(DefaultNamedTableManager.class);

    @Override
    public int getXMLOrder() {
        return 320;
    }

    @Override
    public char typeLetter() {
        return 'Q';
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(String systemName) {
        return LogixNG_Manager.validSystemNameFormat(this.getSubSystemNamePrefix(), systemName);
    }

    @Override
    public NamedTable newCSVTable(String systemName, String userName, String fileName) throws IllegalArgumentException {
        NamedTable x;
        if (userName != null && !userName.equals("") && (x = this.getByUserName(userName)) != null) {
            return null;
        }
        x = this.getBySystemName(systemName);
        if (x != null) {
            return null;
        }
        if (this.validSystemNameFormat(systemName) != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("SystemName " + systemName + " is not in the correct format");
        }
        try {
            x = AbstractNamedTable.loadTableFromCSV_File(systemName, userName, fileName, true);
        }
        catch (IOException ex) {
            log.error("Cannot load table due to I/O error", (Throwable)ex);
            return null;
        }
        this.register(x);
        this.updateAutoNumber(systemName);
        return x;
    }

    @Override
    public NamedTable newInternalTable(String systemName, String userName, int numRows, int numColumns) throws IllegalArgumentException {
        NamedTable x;
        if (userName != null && !userName.equals("") && (x = this.getByUserName(userName)) != null) {
            return null;
        }
        x = this.getBySystemName(systemName);
        if (x != null) {
            return null;
        }
        if (this.validSystemNameFormat(systemName) != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("SystemName " + systemName + " is not in the correct format");
        }
        x = new DefaultInternalNamedTable(systemName, userName, numRows, numColumns);
        this.register(x);
        this.updateAutoNumber(systemName);
        return x;
    }

    @Override
    public AnonymousTable newAnonymousTable(int numRows, int numColumns) throws IllegalArgumentException {
        return new DefaultAnonymousTable(numRows, numColumns);
    }

    @Override
    public NamedTable loadTableFromCSVData(@Nonnull String sys, @CheckForNull String user, @Nonnull String text) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        return AbstractNamedTable.loadTableFromCSV_Text(sys, user, text, true);
    }

    @Override
    public NamedTable loadTableFromCSV(@Nonnull String sys, @CheckForNull String user, @Nonnull String fileName) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException, IOException {
        return AbstractNamedTable.loadTableFromCSV_File(sys, user, fileName, true);
    }

    @Override
    public NamedTable loadTableFromCSV(@Nonnull String sys, @CheckForNull String user, @Nonnull File file) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException, IOException {
        return AbstractNamedTable.loadTableFromCSV_File(sys, user, file, true);
    }

    @Override
    public NamedTable getNamedTable(String name) {
        NamedTable x = this.getByUserName(name);
        if (x != null) {
            return x;
        }
        return this.getBySystemName(name);
    }

    @Override
    public NamedTable getByUserName(String name) {
        return (NamedTable)this._tuser.get(name);
    }

    @Override
    public NamedTable getBySystemName(String name) {
        return (NamedTable)this._tsys.get(name);
    }

    @Override
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameNamedTables" : "BeanNameNamedTable");
    }

    @Override
    public void deleteNamedTable(NamedTable x) {
        this.deregister(x);
        x.dispose();
    }

    @Override
    public void printTree(PrintWriter writer, String indent) {
        this.printTree(Locale.getDefault(), writer, indent);
    }

    @Override
    public void printTree(Locale locale, PrintWriter writer, String indent) {
        for (NamedTable namedTable : this.getNamedBeanSet()) {
            if (namedTable instanceof DefaultCsvNamedTable) {
                DefaultCsvNamedTable csvTable = (DefaultCsvNamedTable)namedTable;
                writer.append(String.format("Named table: System name: %s, User name: %s, File name: %s, Num rows: %d, Num columns: %d", csvTable.getSystemName(), csvTable.getUserName(), csvTable.getFileName(), csvTable.numRows(), csvTable.numColumns()));
            }
            if (namedTable == null) {
                throw new NullPointerException("namedTable is null");
            }
            writer.append(String.format("Named table: System name: %s, User name: %s, Num rows: %d, Num columns: %d", namedTable.getSystemName(), namedTable.getUserName(), namedTable.numRows(), namedTable.numColumns()));
            writer.println();
            writer.println();
        }
    }

    @InvokeOnGuiThread
    public static DefaultNamedTableManager instance() {
        if (!ThreadingUtil.isGUIThread()) {
            LoggingUtil.warnOnce(log, "instance() called on wrong thread", new Object[0]);
        }
        if (_instance == null) {
            _instance = new DefaultNamedTableManager();
        }
        return _instance;
    }

    @Override
    public Class<NamedTable> getNamedBeanClass() {
        return NamedTable.class;
    }

    @OverridingMethodsMustInvokeSuper
    public void fireVetoableChange(String p, Object old) throws PropertyVetoException {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, p, old, null);
        VetoableChangeListener[] vetoableChangeListenerArray = this.vetoableChangeSupport.getVetoableChangeListeners();
        int n = vetoableChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableChangeListener vc = vetoableChangeListenerArray[n2];
            vc.vetoableChange(evt);
            ++n2;
        }
    }

    @Override
    public final void deleteBean(@Nonnull NamedTable namedTable, @Nonnull String property) throws PropertyVetoException {
        this.fireVetoableChange(property, namedTable);
        if (property.equals("DoDelete")) {
            this.deregister(namedTable);
            namedTable.dispose();
        }
    }
}

