/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.Set;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.Debugable;
import jmri.jmrit.logixng.MaleStringExpressionSocket;
import jmri.jmrit.logixng.StringExpressionBean;
import jmri.jmrit.logixng.implementation.AbstractMaleSocket;
import jmri.jmrit.logixng.implementation.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMaleStringExpressionSocket
extends AbstractMaleSocket
implements MaleStringExpressionSocket {
    private Debugable.DebugConfig _debugConfig = null;
    private boolean _enabled = true;
    private static final Logger log = LoggerFactory.getLogger(DefaultMaleStringExpressionSocket.class);

    public DefaultMaleStringExpressionSocket(@Nonnull BaseManager<? extends NamedBean> manager, @Nonnull StringExpressionBean stringExpression) {
        super(manager, stringExpression);
    }

    @Override
    public boolean getTriggerOnChange() {
        return ((StringExpressionBean)this.getObject()).getTriggerOnChange();
    }

    @Override
    public void setTriggerOnChange(boolean triggerOnChange) {
        ((StringExpressionBean)this.getObject()).setTriggerOnChange(triggerOnChange);
    }

    @Override
    public String evaluate() throws JmriException {
        if (!this._enabled) {
            return "";
        }
        if (this._debugConfig != null && ((StringExpressionDebugConfig)this._debugConfig)._forceResult) {
            return ((StringExpressionDebugConfig)this._debugConfig)._result;
        }
        ConditionalNG currentConditionalNG = this.getConditionalNG();
        int currentStackPos = currentConditionalNG.getStack().getCount();
        String result = "";
        try {
            currentConditionalNG.getSymbolTable().createSymbols(this._localVariables);
            result = ((StringExpressionBean)this.getObject()).evaluate();
        }
        catch (JmriException e) {
            if (e.getErrors() != null) {
                this.handleError(this, Bundle.getMessage("ExceptionEvaluateMulti"), e.getErrors(), e, log);
            } else {
                this.handleError((Base)this, Bundle.getMessage("ExceptionEvaluate", e.getLocalizedMessage()), e, log);
            }
        }
        catch (RuntimeException e) {
            this.handleError((Base)this, Bundle.getMessage("ExceptionEvaluate", e.getLocalizedMessage()), e, log);
        }
        currentConditionalNG.getStack().setCount(currentStackPos);
        currentConditionalNG.getSymbolTable().removeSymbols(this._localVariables);
        return result;
    }

    @Override
    public int getState() {
        return ((StringExpressionBean)this.getObject()).getState();
    }

    @Override
    public String getDisplayName() {
        return ((StringExpressionBean)this.getObject()).getDisplayName();
    }

    @Override
    public void disposeMe() {
        ((StringExpressionBean)this.getObject()).dispose();
    }

    @Override
    public void registerListenersForThisClass() {
        ((StringExpressionBean)this.getObject()).registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        ((StringExpressionBean)this.getObject()).unregisterListeners();
    }

    @Override
    public void setState(int s) throws JmriException {
        ((StringExpressionBean)this.getObject()).setState(s);
    }

    @Override
    public String describeState(int state) {
        return Bundle.getMessage("BeanStateUnknown");
    }

    @Override
    public String getComment() {
        return ((StringExpressionBean)this.getObject()).getComment();
    }

    @Override
    public void setComment(String comment) {
        ((StringExpressionBean)this.getObject()).setComment(comment);
    }

    @Override
    public void setProperty(String key, Object value) {
        ((StringExpressionBean)this.getObject()).setProperty(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return ((StringExpressionBean)this.getObject()).getProperty(key);
    }

    @Override
    public void removeProperty(String key) {
        ((StringExpressionBean)this.getObject()).removeProperty(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return ((StringExpressionBean)this.getObject()).getPropertyKeys();
    }

    @Override
    public String getBeanType() {
        return ((StringExpressionBean)this.getObject()).getBeanType();
    }

    @Override
    public int compareSystemNameSuffix(String suffix1, String suffix2, NamedBean n2) {
        return ((StringExpressionBean)this.getObject()).compareSystemNameSuffix(suffix1, suffix2, n2);
    }

    @Override
    public void setDebugConfig(Debugable.DebugConfig config) {
        this._debugConfig = config;
    }

    @Override
    public Debugable.DebugConfig getDebugConfig() {
        return this._debugConfig;
    }

    @Override
    public Debugable.DebugConfig createDebugConfig() {
        return new StringExpressionDebugConfig();
    }

    @Override
    public void setEnabled(boolean enable) {
        this._enabled = enable;
        if (this.isActive()) {
            this.registerListeners();
        } else {
            this.unregisterListeners();
        }
    }

    @Override
    public void setEnabledFlag(boolean enable) {
        this._enabled = enable;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    public static class StringExpressionDebugConfig
    implements Debugable.DebugConfig {
        public boolean _forceResult = false;
        public String _result = "";

        @Override
        public Debugable.DebugConfig getCopy() {
            StringExpressionDebugConfig config = new StringExpressionDebugConfig();
            config._forceResult = this._forceResult;
            config._result = this._result;
            return config;
        }
    }
}

