/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.Set;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.Debugable;
import jmri.jmrit.logixng.DigitalExpressionBean;
import jmri.jmrit.logixng.MaleDigitalExpressionSocket;
import jmri.jmrit.logixng.implementation.AbstractMaleSocket;
import jmri.jmrit.logixng.implementation.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMaleDigitalExpressionSocket
extends AbstractMaleSocket
implements MaleDigitalExpressionSocket {
    private boolean lastEvaluationResult = false;
    private Debugable.DebugConfig _debugConfig = null;
    private boolean _enabled = true;
    private static final Logger log = LoggerFactory.getLogger(DefaultMaleDigitalExpressionSocket.class);

    public DefaultMaleDigitalExpressionSocket(@Nonnull BaseManager<? extends NamedBean> manager, @Nonnull DigitalExpressionBean expression) {
        super(manager, expression);
    }

    @Override
    public void notifyChangedResult(boolean oldResult, boolean newResult) {
        ((DigitalExpressionBean)this.getObject()).notifyChangedResult(oldResult, newResult);
    }

    private void checkChangedLastResult(boolean savedLastResult) {
        if (savedLastResult != this.lastEvaluationResult) {
            ((DigitalExpressionBean)this.getObject()).notifyChangedResult(savedLastResult, this.lastEvaluationResult);
        }
    }

    @Override
    public boolean evaluate() throws JmriException {
        boolean saveLastResult = this.lastEvaluationResult;
        if (!this._enabled) {
            this.lastEvaluationResult = false;
            this.checkChangedLastResult(saveLastResult);
            return false;
        }
        if (this._debugConfig != null && ((DigitalExpressionDebugConfig)this._debugConfig)._forceResult) {
            this.lastEvaluationResult = ((DigitalExpressionDebugConfig)this._debugConfig)._result;
            this.checkChangedLastResult(saveLastResult);
            return this.lastEvaluationResult;
        }
        ConditionalNG conditionalNG = this.getConditionalNG();
        int currentStackPos = conditionalNG.getStack().getCount();
        try {
            conditionalNG.getSymbolTable().createSymbols(this._localVariables);
            this.lastEvaluationResult = ((DigitalExpressionBean)this.getObject()).evaluate();
        }
        catch (JmriException e) {
            if (e.getErrors() != null) {
                this.handleError(this, Bundle.getMessage("ExceptionEvaluateMulti"), e.getErrors(), e, log);
            } else {
                this.handleError((Base)this, Bundle.getMessage("ExceptionEvaluateExpression", e.getLocalizedMessage()), e, log);
            }
            this.lastEvaluationResult = false;
        }
        catch (RuntimeException e) {
            this.handleError((Base)this, Bundle.getMessage("ExceptionEvaluateExpression", e.getLocalizedMessage()), e, log);
            this.lastEvaluationResult = false;
        }
        conditionalNG.getStack().setCount(currentStackPos);
        conditionalNG.getSymbolTable().removeSymbols(this._localVariables);
        this.checkChangedLastResult(saveLastResult);
        return this.lastEvaluationResult;
    }

    @Override
    public boolean getLastResult() {
        return this.lastEvaluationResult;
    }

    @Override
    public int getState() {
        return ((DigitalExpressionBean)this.getObject()).getState();
    }

    @Override
    public void setState(int s) throws JmriException {
        ((DigitalExpressionBean)this.getObject()).setState(s);
    }

    @Override
    public String describeState(int state) {
        return ((DigitalExpressionBean)this.getObject()).describeState(state);
    }

    @Override
    public void setProperty(String key, Object value) {
        ((DigitalExpressionBean)this.getObject()).setProperty(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return ((DigitalExpressionBean)this.getObject()).getProperty(key);
    }

    @Override
    public void removeProperty(String key) {
        ((DigitalExpressionBean)this.getObject()).removeProperty(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return ((DigitalExpressionBean)this.getObject()).getPropertyKeys();
    }

    @Override
    public String getBeanType() {
        return ((DigitalExpressionBean)this.getObject()).getBeanType();
    }

    @Override
    public int compareSystemNameSuffix(String suffix1, String suffix2, NamedBean n2) {
        return ((DigitalExpressionBean)this.getObject()).compareSystemNameSuffix(suffix1, suffix2, n2);
    }

    @Override
    public void setDebugConfig(Debugable.DebugConfig config) {
        this._debugConfig = config;
    }

    @Override
    public Debugable.DebugConfig getDebugConfig() {
        return this._debugConfig;
    }

    @Override
    public Debugable.DebugConfig createDebugConfig() {
        return new DigitalExpressionDebugConfig();
    }

    @Override
    public void setEnabled(boolean enable) {
        this._enabled = enable;
        if (this.isActive()) {
            this.registerListeners();
        } else {
            this.unregisterListeners();
        }
    }

    @Override
    public void setEnabledFlag(boolean enable) {
        this._enabled = enable;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public void disposeMe() {
        ((DigitalExpressionBean)this.getObject()).dispose();
    }

    @Override
    public void registerListenersForThisClass() {
        ((DigitalExpressionBean)this.getObject()).registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        ((DigitalExpressionBean)this.getObject()).unregisterListeners();
    }

    @Override
    public String getDisplayName() {
        return ((DigitalExpressionBean)this.getObject()).getDisplayName();
    }

    public static class DigitalExpressionDebugConfig
    implements Debugable.DebugConfig {
        public boolean _forceResult = false;
        public boolean _result = false;

        @Override
        public Debugable.DebugConfig getCopy() {
            DigitalExpressionDebugConfig config = new DigitalExpressionDebugConfig();
            config._forceResult = this._forceResult;
            config._result = this._result;
            return config;
        }
    }
}

