/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.Set;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.Debugable;
import jmri.jmrit.logixng.DigitalBooleanActionBean;
import jmri.jmrit.logixng.MaleDigitalBooleanActionSocket;
import jmri.jmrit.logixng.implementation.AbstractMaleSocket;
import jmri.jmrit.logixng.implementation.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMaleDigitalBooleanActionSocket
extends AbstractMaleSocket
implements MaleDigitalBooleanActionSocket {
    private Debugable.DebugConfig _debugConfig = null;
    private boolean _enabled = true;
    private static final Logger log = LoggerFactory.getLogger(DefaultMaleDigitalBooleanActionSocket.class);

    public DefaultMaleDigitalBooleanActionSocket(@Nonnull BaseManager<? extends NamedBean> manager, @Nonnull DigitalBooleanActionBean action) {
        super(manager, action);
    }

    @Override
    public void execute(boolean hasChangedToTrue, boolean hasChangedToFalse) throws JmriException {
        if (!this._enabled) {
            return;
        }
        if (this._debugConfig != null && ((DigitalBooleanActionDebugConfig)this._debugConfig)._dontExecute) {
            return;
        }
        ConditionalNG conditionalNG = this.getConditionalNG();
        int currentStackPos = conditionalNG.getStack().getCount();
        try {
            conditionalNG.getSymbolTable().createSymbols(this._localVariables);
            ((DigitalBooleanActionBean)this.getObject()).execute(hasChangedToTrue, hasChangedToFalse);
        }
        catch (JmriException e) {
            if (e.getErrors() != null) {
                this.handleError(this, Bundle.getMessage("ExceptionExecuteMulti"), e.getErrors(), e, log);
            } else {
                this.handleError((Base)this, Bundle.getMessage("ExceptionExecuteBooleanAction", e.getLocalizedMessage()), e, log);
            }
        }
        catch (RuntimeException e) {
            this.handleError((Base)this, Bundle.getMessage("ExceptionExecuteBooleanAction", e.getLocalizedMessage()), e, log);
        }
        conditionalNG.getStack().setCount(currentStackPos);
        conditionalNG.getSymbolTable().removeSymbols(this._localVariables);
    }

    @Override
    public String getDisplayName() {
        return ((DigitalBooleanActionBean)this.getObject()).getDisplayName();
    }

    @Override
    public void disposeMe() {
        ((DigitalBooleanActionBean)this.getObject()).dispose();
    }

    @Override
    public void registerListenersForThisClass() {
        ((DigitalBooleanActionBean)this.getObject()).registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        ((DigitalBooleanActionBean)this.getObject()).unregisterListeners();
    }

    @Override
    public void setState(int s) throws JmriException {
        ((DigitalBooleanActionBean)this.getObject()).setState(s);
    }

    @Override
    public int getState() {
        return ((DigitalBooleanActionBean)this.getObject()).getState();
    }

    @Override
    public String describeState(int state) {
        return ((DigitalBooleanActionBean)this.getObject()).describeState(state);
    }

    @Override
    public String getComment() {
        return ((DigitalBooleanActionBean)this.getObject()).getComment();
    }

    @Override
    public void setComment(String comment) {
        ((DigitalBooleanActionBean)this.getObject()).setComment(comment);
    }

    @Override
    public void setProperty(String key, Object value) {
        ((DigitalBooleanActionBean)this.getObject()).setProperty(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return ((DigitalBooleanActionBean)this.getObject()).getProperty(key);
    }

    @Override
    public void removeProperty(String key) {
        ((DigitalBooleanActionBean)this.getObject()).removeProperty(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return ((DigitalBooleanActionBean)this.getObject()).getPropertyKeys();
    }

    @Override
    public String getBeanType() {
        return ((DigitalBooleanActionBean)this.getObject()).getBeanType();
    }

    @Override
    public int compareSystemNameSuffix(String suffix1, String suffix2, NamedBean n2) {
        return ((DigitalBooleanActionBean)this.getObject()).compareSystemNameSuffix(suffix1, suffix2, n2);
    }

    @Override
    public void setDebugConfig(Debugable.DebugConfig config) {
        this._debugConfig = config;
    }

    @Override
    public Debugable.DebugConfig getDebugConfig() {
        return this._debugConfig;
    }

    @Override
    public Debugable.DebugConfig createDebugConfig() {
        return new DigitalBooleanActionDebugConfig();
    }

    @Override
    public void setEnabled(boolean enable) {
        this._enabled = enable;
        if (this.isActive()) {
            this.registerListeners();
        } else {
            this.unregisterListeners();
        }
    }

    @Override
    public void setEnabledFlag(boolean enable) {
        this._enabled = enable;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    public static class DigitalBooleanActionDebugConfig
    implements Debugable.DebugConfig {
        public boolean _dontExecute = false;

        @Override
        public Debugable.DebugConfig getCopy() {
            DigitalBooleanActionDebugConfig config = new DigitalBooleanActionDebugConfig();
            config._dontExecute = this._dontExecute;
            return config;
        }
    }
}

