/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.Set;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.Debugable;
import jmri.jmrit.logixng.DigitalActionBean;
import jmri.jmrit.logixng.MaleDigitalActionSocket;
import jmri.jmrit.logixng.implementation.AbstractMaleSocket;
import jmri.jmrit.logixng.implementation.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMaleDigitalActionSocket
extends AbstractMaleSocket
implements MaleDigitalActionSocket {
    private Debugable.DebugConfig _debugConfig = null;
    private boolean _enabled = true;
    private static final Logger log = LoggerFactory.getLogger(DefaultMaleDigitalActionSocket.class);

    public DefaultMaleDigitalActionSocket(@Nonnull BaseManager<? extends NamedBean> manager, @Nonnull DigitalActionBean action) {
        super(manager, action);
    }

    @Override
    public void execute() throws JmriException {
        if (!this._enabled) {
            return;
        }
        if (this._debugConfig != null && ((DigitalActionDebugConfig)this._debugConfig)._dontExecute) {
            return;
        }
        ConditionalNG conditionalNG = this.getConditionalNG();
        int currentStackPos = conditionalNG.getStack().getCount();
        try {
            conditionalNG.getSymbolTable().createSymbols(this._localVariables);
            ((DigitalActionBean)this.getObject()).execute();
        }
        catch (JmriException e) {
            if (e.getErrors() != null) {
                this.handleError(this, Bundle.getMessage("ExceptionExecuteMulti"), e.getErrors(), e, log);
            } else {
                this.handleError((Base)this, Bundle.getMessage("ExceptionExecuteAction", e.getLocalizedMessage()), e, log);
            }
        }
        catch (RuntimeException e) {
            this.handleError((Base)this, Bundle.getMessage("ExceptionExecuteAction", e.getLocalizedMessage()), e, log);
        }
        conditionalNG.getStack().setCount(currentStackPos);
        conditionalNG.getSymbolTable().removeSymbols(this._localVariables);
    }

    @Override
    public void disposeMe() {
        ((DigitalActionBean)this.getObject()).dispose();
    }

    @Override
    public void registerListenersForThisClass() {
        ((DigitalActionBean)this.getObject()).registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        ((DigitalActionBean)this.getObject()).unregisterListeners();
    }

    @Override
    public void setState(int s) throws JmriException {
        ((DigitalActionBean)this.getObject()).setState(s);
    }

    @Override
    public int getState() {
        return ((DigitalActionBean)this.getObject()).getState();
    }

    @Override
    public String describeState(int state) {
        return ((DigitalActionBean)this.getObject()).describeState(state);
    }

    @Override
    public String getComment() {
        return ((DigitalActionBean)this.getObject()).getComment();
    }

    @Override
    public void setComment(String comment) {
        ((DigitalActionBean)this.getObject()).setComment(comment);
    }

    @Override
    public void setProperty(String key, Object value) {
        ((DigitalActionBean)this.getObject()).setProperty(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return ((DigitalActionBean)this.getObject()).getProperty(key);
    }

    @Override
    public void removeProperty(String key) {
        ((DigitalActionBean)this.getObject()).removeProperty(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return ((DigitalActionBean)this.getObject()).getPropertyKeys();
    }

    @Override
    public String getBeanType() {
        return ((DigitalActionBean)this.getObject()).getBeanType();
    }

    @Override
    public int compareSystemNameSuffix(String suffix1, String suffix2, NamedBean n2) {
        return ((DigitalActionBean)this.getObject()).compareSystemNameSuffix(suffix1, suffix2, n2);
    }

    @Override
    public void setDebugConfig(Debugable.DebugConfig config) {
        this._debugConfig = config;
    }

    @Override
    public Debugable.DebugConfig getDebugConfig() {
        return this._debugConfig;
    }

    @Override
    public Debugable.DebugConfig createDebugConfig() {
        return new DigitalActionDebugConfig();
    }

    @Override
    public void setEnabled(boolean enable) {
        this._enabled = enable;
        if (this.isActive()) {
            this.registerListeners();
        } else {
            this.unregisterListeners();
        }
    }

    @Override
    public void setEnabledFlag(boolean enable) {
        this._enabled = enable;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    public static class DigitalActionDebugConfig
    implements Debugable.DebugConfig {
        public boolean _dontExecute = false;

        @Override
        public Debugable.DebugConfig getCopy() {
            DigitalActionDebugConfig config = new DigitalActionDebugConfig();
            config._dontExecute = this._dontExecute;
            return config;
        }
    }
}

