/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.Set;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.AnalogExpressionBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.Debugable;
import jmri.jmrit.logixng.MaleAnalogExpressionSocket;
import jmri.jmrit.logixng.implementation.AbstractMaleSocket;
import jmri.jmrit.logixng.implementation.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMaleAnalogExpressionSocket
extends AbstractMaleSocket
implements MaleAnalogExpressionSocket {
    private Debugable.DebugConfig _debugConfig = null;
    private boolean _enabled = true;
    private static final Logger log = LoggerFactory.getLogger(DefaultMaleAnalogExpressionSocket.class);

    public DefaultMaleAnalogExpressionSocket(@Nonnull BaseManager<? extends NamedBean> manager, @Nonnull AnalogExpressionBean expression) {
        super(manager, expression);
    }

    @Override
    public boolean getTriggerOnChange() {
        return ((AnalogExpressionBean)this.getObject()).getTriggerOnChange();
    }

    @Override
    public void setTriggerOnChange(boolean triggerOnChange) {
        ((AnalogExpressionBean)this.getObject()).setTriggerOnChange(triggerOnChange);
    }

    private double internalEvaluate() throws JmriException {
        double result = ((AnalogExpressionBean)this.getObject()).evaluate();
        if (Double.isNaN(result)) {
            throw new IllegalArgumentException("The result is NaN");
        }
        if (result == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException("The result is negative infinity");
        }
        if (result == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("The result is positive infinity");
        }
        return result;
    }

    @Override
    public double evaluate() throws JmriException {
        if (!this._enabled) {
            return 0.0;
        }
        if (this._debugConfig != null && ((AnalogExpressionDebugConfig)this._debugConfig)._forceResult) {
            return ((AnalogExpressionDebugConfig)this._debugConfig)._result;
        }
        ConditionalNG conditionalNG = this.getConditionalNG();
        int currentStackPos = conditionalNG.getStack().getCount();
        double result = 0.0;
        try {
            conditionalNG.getSymbolTable().createSymbols(this._localVariables);
            result = this.internalEvaluate();
        }
        catch (JmriException e) {
            if (e.getErrors() != null) {
                this.handleError(this, Bundle.getMessage("ExceptionEvaluateMulti"), e.getErrors(), e, log);
            } else {
                this.handleError((Base)this, Bundle.getMessage("ExceptionEvaluate", e.getLocalizedMessage()), e, log);
            }
        }
        catch (RuntimeException e) {
            this.handleError((Base)this, Bundle.getMessage("ExceptionEvaluate", e.getLocalizedMessage()), e, log);
        }
        conditionalNG.getStack().setCount(currentStackPos);
        conditionalNG.getSymbolTable().removeSymbols(this._localVariables);
        return result;
    }

    @Override
    public int getState() {
        return ((AnalogExpressionBean)this.getObject()).getState();
    }

    @Override
    public String getDisplayName() {
        return ((AnalogExpressionBean)this.getObject()).getDisplayName();
    }

    @Override
    public void disposeMe() {
        ((AnalogExpressionBean)this.getObject()).dispose();
    }

    @Override
    public void registerListenersForThisClass() {
        ((AnalogExpressionBean)this.getObject()).registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        ((AnalogExpressionBean)this.getObject()).unregisterListeners();
    }

    @Override
    public void setState(int s) throws JmriException {
        ((AnalogExpressionBean)this.getObject()).setState(s);
    }

    @Override
    public String describeState(int state) {
        return Bundle.getMessage("BeanStateUnknown");
    }

    @Override
    public String getComment() {
        return ((AnalogExpressionBean)this.getObject()).getComment();
    }

    @Override
    public void setComment(String comment) {
        ((AnalogExpressionBean)this.getObject()).setComment(comment);
    }

    @Override
    public void setProperty(String key, Object value) {
        ((AnalogExpressionBean)this.getObject()).setProperty(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return ((AnalogExpressionBean)this.getObject()).getProperty(key);
    }

    @Override
    public void removeProperty(String key) {
        ((AnalogExpressionBean)this.getObject()).removeProperty(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return ((AnalogExpressionBean)this.getObject()).getPropertyKeys();
    }

    @Override
    public String getBeanType() {
        return ((AnalogExpressionBean)this.getObject()).getBeanType();
    }

    @Override
    public int compareSystemNameSuffix(String suffix1, String suffix2, NamedBean n2) {
        return ((AnalogExpressionBean)this.getObject()).compareSystemNameSuffix(suffix1, suffix2, n2);
    }

    @Override
    public void setDebugConfig(Debugable.DebugConfig config) {
        this._debugConfig = config;
    }

    @Override
    public Debugable.DebugConfig getDebugConfig() {
        return this._debugConfig;
    }

    @Override
    public Debugable.DebugConfig createDebugConfig() {
        return new AnalogExpressionDebugConfig();
    }

    @Override
    public void setEnabled(boolean enable) {
        this._enabled = enable;
        if (this.isActive()) {
            this.registerListeners();
        } else {
            this.unregisterListeners();
        }
    }

    @Override
    public void setEnabledFlag(boolean enable) {
        this._enabled = enable;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    public static class AnalogExpressionDebugConfig
    implements Debugable.DebugConfig {
        public boolean _forceResult = false;
        public double _result = 0.0;

        @Override
        public Debugable.DebugConfig getCopy() {
            AnalogExpressionDebugConfig config = new AnalogExpressionDebugConfig();
            config._forceResult = this._forceResult;
            config._result = this._result;
            return config;
        }
    }
}

