/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.Set;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.AnalogActionBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.Debugable;
import jmri.jmrit.logixng.MaleAnalogActionSocket;
import jmri.jmrit.logixng.implementation.AbstractMaleSocket;
import jmri.jmrit.logixng.implementation.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMaleAnalogActionSocket
extends AbstractMaleSocket
implements MaleAnalogActionSocket {
    private Debugable.DebugConfig _debugConfig = null;
    private boolean _enabled = true;
    private static final Logger log = LoggerFactory.getLogger(DefaultMaleAnalogActionSocket.class);

    public DefaultMaleAnalogActionSocket(@Nonnull BaseManager<? extends NamedBean> manager, @Nonnull AnalogActionBean action) {
        super(manager, action);
    }

    private void internalSetValue(double value) throws JmriException {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("The value is NaN");
        }
        if (value == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException("The value is negative infinity");
        }
        if (value == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("The value is positive infinity");
        }
        ((AnalogActionBean)this.getObject()).setValue(value);
    }

    @Override
    public void setValue(double value) throws JmriException {
        if (!this._enabled) {
            return;
        }
        if (this._debugConfig != null && ((AnalogActionDebugConfig)this._debugConfig)._dontExecute) {
            return;
        }
        ConditionalNG conditionalNG = this.getConditionalNG();
        int currentStackPos = conditionalNG.getStack().getCount();
        try {
            conditionalNG.getSymbolTable().createSymbols(this._localVariables);
            this.internalSetValue(value);
        }
        catch (JmriException e) {
            if (e.getErrors() != null) {
                this.handleError(this, Bundle.getMessage("ExceptionExecuteMulti"), e.getErrors(), e, log);
            } else {
                this.handleError((Base)this, Bundle.getMessage("ExceptionSetValue", e.getLocalizedMessage()), e, log);
            }
        }
        catch (RuntimeException e) {
            this.handleError((Base)this, Bundle.getMessage("ExceptionSetValue", e.getLocalizedMessage()), e, log);
        }
        conditionalNG.getStack().setCount(currentStackPos);
        conditionalNG.getSymbolTable().removeSymbols(this._localVariables);
    }

    @Override
    public String getDisplayName() {
        return ((AnalogActionBean)this.getObject()).getDisplayName();
    }

    @Override
    public void registerListenersForThisClass() {
        ((AnalogActionBean)this.getObject()).registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        ((AnalogActionBean)this.getObject()).unregisterListeners();
    }

    @Override
    public void setState(int s) throws JmriException {
        ((AnalogActionBean)this.getObject()).setState(s);
    }

    @Override
    public int getState() {
        return ((AnalogActionBean)this.getObject()).getState();
    }

    @Override
    public String describeState(int state) {
        return ((AnalogActionBean)this.getObject()).describeState(state);
    }

    @Override
    public String getComment() {
        return ((AnalogActionBean)this.getObject()).getComment();
    }

    @Override
    public void setComment(String comment) {
        ((AnalogActionBean)this.getObject()).setComment(comment);
    }

    @Override
    public void setProperty(String key, Object value) {
        ((AnalogActionBean)this.getObject()).setProperty(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return ((AnalogActionBean)this.getObject()).getProperty(key);
    }

    @Override
    public void removeProperty(String key) {
        ((AnalogActionBean)this.getObject()).removeProperty(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return ((AnalogActionBean)this.getObject()).getPropertyKeys();
    }

    @Override
    public String getBeanType() {
        return ((AnalogActionBean)this.getObject()).getBeanType();
    }

    @Override
    public int compareSystemNameSuffix(String suffix1, String suffix2, NamedBean n2) {
        return ((AnalogActionBean)this.getObject()).compareSystemNameSuffix(suffix1, suffix2, n2);
    }

    @Override
    public void setDebugConfig(Debugable.DebugConfig config) {
        this._debugConfig = config;
    }

    @Override
    public Debugable.DebugConfig getDebugConfig() {
        return this._debugConfig;
    }

    @Override
    public Debugable.DebugConfig createDebugConfig() {
        return new AnalogActionDebugConfig();
    }

    @Override
    public void setEnabled(boolean enable) {
        this._enabled = enable;
        if (this.isActive()) {
            this.registerListeners();
        } else {
            this.unregisterListeners();
        }
    }

    @Override
    public void setEnabledFlag(boolean enable) {
        this._enabled = enable;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public void disposeMe() {
    }

    public static class AnalogActionDebugConfig
    implements Debugable.DebugConfig {
        public boolean _dontExecute = false;

        @Override
        public Debugable.DebugConfig getCopy() {
            AnalogActionDebugConfig config = new AnalogActionDebugConfig();
            config._dontExecute = this._dontExecute;
            return config;
        }
    }
}

