/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.prefs.Preferences;
import jmri.beans.PreferencesBean;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.MaleSocket;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;

public final class DefaultLogixNGPreferences
extends PreferencesBean
implements LogixNGPreferences {
    public static final String START_LOGIXNG_ON_LOAD = "startLogixNGOnStartup";
    public static final String USE_GENERIC_FEMALE_SOCKETS = "useGenericFemaleSockets";
    public static final String INSTALL_DEBUGGER = "installDebugger";
    public static final String SHOW_SYSTEM_USER_NAMES = "showSystemUserNames";
    public static final String ERROR_HANDLING_TYPE = "errorHandlingType";
    public static final String TREE_EDITOR_HIGHLIGHT_ROW = "treeEditorHighlightRow";
    private boolean _startLogixNGOnLoad = true;
    private boolean _showSystemUserNames = false;
    private boolean _installDebugger = true;
    private MaleSocket.ErrorHandlingType _errorHandlingType = MaleSocket.ErrorHandlingType.ShowDialogBox;
    private boolean _treeEditorHighlightRow = false;

    public DefaultLogixNGPreferences() {
        super(ProfileManager.getDefault().getActiveProfile());
        Preferences sharedPreferences = ProfileUtils.getPreferences(super.getProfile(), this.getClass(), true);
        this.readPreferences(sharedPreferences);
    }

    private void readPreferences(Preferences sharedPreferences) {
        this._startLogixNGOnLoad = sharedPreferences.getBoolean(START_LOGIXNG_ON_LOAD, this._startLogixNGOnLoad);
        this._installDebugger = sharedPreferences.getBoolean(INSTALL_DEBUGGER, this._installDebugger);
        this._showSystemUserNames = sharedPreferences.getBoolean(SHOW_SYSTEM_USER_NAMES, this._showSystemUserNames);
        this._errorHandlingType = MaleSocket.ErrorHandlingType.valueOf(sharedPreferences.get(ERROR_HANDLING_TYPE, this._errorHandlingType.name()));
        this._treeEditorHighlightRow = sharedPreferences.getBoolean(TREE_EDITOR_HIGHLIGHT_ROW, this._treeEditorHighlightRow);
        this.setIsDirty(false);
    }

    @Override
    public boolean compareValuesDifferent(LogixNGPreferences prefs) {
        if (this.getStartLogixNGOnStartup() != prefs.getStartLogixNGOnStartup()) {
            return true;
        }
        if (this.getInstallDebugger() != prefs.getInstallDebugger()) {
            return true;
        }
        if (this.getShowSystemUserNames() != prefs.getShowSystemUserNames()) {
            return true;
        }
        if (this.getTreeEditorHighlightRow() != prefs.getTreeEditorHighlightRow()) {
            return true;
        }
        return this.getErrorHandlingType() != prefs.getErrorHandlingType();
    }

    @Override
    public void apply(LogixNGPreferences prefs) {
        this.setStartLogixNGOnStartup(prefs.getStartLogixNGOnStartup());
        this.setInstallDebugger(prefs.getInstallDebugger());
        this.setShowSystemUserNames(prefs.getShowSystemUserNames());
        this.setErrorHandlingType(prefs.getErrorHandlingType());
        this.setTreeEditorHighlightRow(prefs.getTreeEditorHighlightRow());
    }

    @Override
    public void save() {
        Preferences sharedPreferences = ProfileUtils.getPreferences(this.getProfile(), this.getClass(), true);
        sharedPreferences.putBoolean(START_LOGIXNG_ON_LOAD, this.getStartLogixNGOnStartup());
        sharedPreferences.putBoolean(INSTALL_DEBUGGER, this.getInstallDebugger());
        sharedPreferences.putBoolean(SHOW_SYSTEM_USER_NAMES, this.getShowSystemUserNames());
        sharedPreferences.put(ERROR_HANDLING_TYPE, this.getErrorHandlingType().name());
        sharedPreferences.putBoolean(TREE_EDITOR_HIGHLIGHT_ROW, this.getTreeEditorHighlightRow());
    }

    @Override
    public void setStartLogixNGOnStartup(boolean value) {
        this._startLogixNGOnLoad = value;
        this.setIsDirty(true);
    }

    @Override
    public boolean getStartLogixNGOnStartup() {
        return this._startLogixNGOnLoad;
    }

    @Override
    public void setShowSystemUserNames(boolean value) {
        this._showSystemUserNames = value;
        this.setIsDirty(true);
    }

    @Override
    public boolean getShowSystemUserNames() {
        return this._showSystemUserNames;
    }

    @Override
    public void setInstallDebugger(boolean value) {
        this._installDebugger = value;
        this.setIsDirty(true);
    }

    @Override
    public boolean getInstallDebugger() {
        return this._installDebugger;
    }

    @Override
    public void setErrorHandlingType(MaleSocket.ErrorHandlingType type) {
        this._errorHandlingType = type;
        this.setIsDirty(true);
    }

    @Override
    public MaleSocket.ErrorHandlingType getErrorHandlingType() {
        return this._errorHandlingType;
    }

    @Override
    public void setTreeEditorHighlightRow(boolean value) {
        this._treeEditorHighlightRow = value;
        this.setIsDirty(true);
    }

    @Override
    public boolean getTreeEditorHighlightRow() {
        return this._treeEditorHighlightRow;
    }
}

