/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.awt.GraphicsEnvironment;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.InvokeOnGuiThread;
import jmri.Manager;
import jmri.jmrit.logixng.AnalogActionManager;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Clipboard;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.ConditionalNG_Manager;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.DigitalBooleanActionManager;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.LogixNG_InitializationManager;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.ModuleManager;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.StringActionManager;
import jmri.jmrit.logixng.StringExpressionManager;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultClipboard;
import jmri.jmrit.logixng.implementation.DefaultLogixNG;
import jmri.managers.AbstractManager;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogixNGManager
extends AbstractManager<LogixNG>
implements LogixNG_Manager {
    private final Map<String, Manager<? extends MaleSocket>> _managers = new HashMap<String, Manager<? extends MaleSocket>>();
    private final Clipboard _clipboard = new DefaultClipboard();
    private boolean _isActive = false;
    static volatile DefaultLogixNGManager _instance = null;
    private static final Logger log = LoggerFactory.getLogger(DefaultLogixNGManager.class);

    public DefaultLogixNGManager() {
        InstanceManager.getDefault(LogixNGPreferences.class);
    }

    @Override
    public int getXMLOrder() {
        return 290;
    }

    @Override
    public char typeLetter() {
        return 'Q';
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(String systemName) {
        return LogixNG_Manager.validSystemNameFormat(this.getSubSystemNamePrefix(), systemName);
    }

    @Override
    public LogixNG createLogixNG(String systemName, String userName) throws IllegalArgumentException {
        LogixNG x;
        if (userName != null && !userName.equals("") && (x = this.getByUserName(userName)) != null) {
            return null;
        }
        x = this.getBySystemName(systemName);
        if (x != null) {
            return null;
        }
        if (this.validSystemNameFormat(systemName) != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("SystemName " + systemName + " is not in the correct format");
        }
        x = new DefaultLogixNG(systemName, userName);
        this.register(x);
        this.updateAutoNumber(systemName);
        return x;
    }

    @Override
    public LogixNG createLogixNG(String userName) throws IllegalArgumentException {
        return this.createLogixNG(this.getAutoSystemName(), userName);
    }

    @Override
    public LogixNG getLogixNG(String name) {
        LogixNG x = this.getByUserName(name);
        if (x != null) {
            return x;
        }
        return this.getBySystemName(name);
    }

    @Override
    public LogixNG getByUserName(String name) {
        return (LogixNG)this._tuser.get(name);
    }

    @Override
    public LogixNG getBySystemName(String name) {
        return (LogixNG)this._tsys.get(name);
    }

    @Override
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameLogixNGs" : "BeanNameLogixNG");
    }

    @Override
    public void setupAllLogixNGs() {
        ArrayList<String> errors = new ArrayList<String>();
        boolean result = true;
        for (LogixNG logixNG : this._tsys.values()) {
            logixNG.setup();
            boolean bl = result = result && logixNG.setParentForAllChildren(errors);
        }
        for (Module module : InstanceManager.getDefault(ModuleManager.class).getNamedBeanSet()) {
            module.setup();
            boolean bl = result = result && module.setParentForAllChildren(errors);
        }
        this._clipboard.setup();
        if (errors.size() > 0) {
            this.messageDialog("SetupErrorsTitle", errors, null);
        }
        this.checkItemsHaveParents();
    }

    private void messageDialog(String titleKey, List<String> messages, String helpKey) {
        if (!GraphicsEnvironment.isHeadless() && !Boolean.getBoolean("jmri.test.no-dialogs")) {
            StringBuilder sb = new StringBuilder("<html>");
            messages.forEach(msg -> {
                sb.append((String)msg);
                sb.append("<br>");
            });
            if (helpKey != null) {
                sb.append("<br>");
                sb.append(Bundle.getMessage(helpKey));
            }
            sb.append("/<html>");
            JOptionPane.showMessageDialog(null, sb.toString(), Bundle.getMessage(titleKey), 2);
        }
    }

    private void checkItemsHaveParents(SortedSet<? extends MaleSocket> set, List<MaleSocket> beansWithoutParentList) {
        for (MaleSocket maleSocket : set) {
            if (maleSocket.getParent() != null) continue;
            beansWithoutParentList.add(maleSocket);
        }
    }

    private void checkItemsHaveParents() {
        ArrayList<MaleSocket> beansWithoutParentList = new ArrayList<MaleSocket>();
        this.checkItemsHaveParents(InstanceManager.getDefault(AnalogActionManager.class).getNamedBeanSet(), beansWithoutParentList);
        this.checkItemsHaveParents(InstanceManager.getDefault(DigitalActionManager.class).getNamedBeanSet(), beansWithoutParentList);
        this.checkItemsHaveParents(InstanceManager.getDefault(DigitalBooleanActionManager.class).getNamedBeanSet(), beansWithoutParentList);
        this.checkItemsHaveParents(InstanceManager.getDefault(StringActionManager.class).getNamedBeanSet(), beansWithoutParentList);
        this.checkItemsHaveParents(InstanceManager.getDefault(AnalogExpressionManager.class).getNamedBeanSet(), beansWithoutParentList);
        this.checkItemsHaveParents(InstanceManager.getDefault(DigitalExpressionManager.class).getNamedBeanSet(), beansWithoutParentList);
        this.checkItemsHaveParents(InstanceManager.getDefault(StringExpressionManager.class).getNamedBeanSet(), beansWithoutParentList);
        if (!beansWithoutParentList.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> msgs = new ArrayList<String>();
            for (Base base : beansWithoutParentList) {
                base.setup();
                base.setParentForAllChildren(errors);
            }
            for (Base base : beansWithoutParentList) {
                if (base.getParent() != null) continue;
                log.error("Item has no parent: {}, {}, {}", new Object[]{base.getSystemName(), base.getUserName(), base.getLongDescription()});
                msgs.add(Bundle.getMessage("NoParentMessage", base.getSystemName(), base.getUserName(), base.getLongDescription()));
                int i = 0;
                while (i < base.getChildCount()) {
                    if (base.getChild(i).isConnected()) {
                        log.error("    Child: {}, {}, {}", new Object[]{base.getChild(i).getConnectedSocket().getSystemName(), base.getChild(i).getConnectedSocket().getUserName(), base.getChild(i).getConnectedSocket().getLongDescription()});
                    }
                    ++i;
                }
                log.error("                                                                 ");
                ArrayList<String> cliperrors = new ArrayList<String>();
                this._clipboard.add((MaleSocket)base, cliperrors);
            }
            this.messageDialog("ParentErrorsTitle", msgs, "NoParentHelp");
        }
    }

    @Override
    public void activateAllLogixNGs() {
        this.activateAllLogixNGs(true, true);
    }

    @Override
    public void activateAllLogixNGs(boolean runDelayed, boolean runOnSeparateThread) {
        this._isActive = true;
        Runnable runnable = () -> {
            HashSet<LogixNG> activeLogixNGs = new HashSet<LogixNG>();
            List<LogixNG> initLogixNGs = InstanceManager.getDefault(LogixNG_InitializationManager.class).getList();
            for (LogixNG logixNG2 : initLogixNGs) {
                if (logixNG2.isActive()) {
                    logixNG2.registerListeners();
                    logixNG2.execute(false);
                    activeLogixNGs.add(logixNG2);
                    continue;
                }
                logixNG2.unregisterListeners();
            }
            this._tsys.values().stream().sorted().filter(logixNG -> !activeLogixNGs.contains(logixNG)).forEachOrdered(logixNG -> {
                if (logixNG.isActive()) {
                    logixNG.registerListeners();
                    logixNG.execute();
                } else {
                    logixNG.unregisterListeners();
                }
            });
        };
        if (runOnSeparateThread) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    @Override
    public void deActivateAllLogixNGs() {
        for (LogixNG logixNG : this._tsys.values()) {
            logixNG.unregisterListeners();
        }
        this._isActive = false;
    }

    @Override
    public boolean isActive() {
        return this._isActive;
    }

    @Override
    public void deleteLogixNG(LogixNG x) {
        this.deregister(x);
        x.dispose();
    }

    @Override
    public void setLoadDisabled(boolean s) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, PrintWriter writer, String indent, MutableInt lineNumber) {
        this.printTree(settings, Locale.getDefault(), writer, indent, lineNumber);
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String indent, MutableInt lineNumber) {
        for (LogixNG logixNG : this.getNamedBeanSet()) {
            logixNG.printTree(settings, locale, writer, indent, "", lineNumber);
            writer.println();
        }
        InstanceManager.getDefault(ModuleManager.class).printTree(settings, locale, writer, indent, lineNumber);
        InstanceManager.getDefault(NamedTableManager.class).printTree(locale, writer, indent);
        InstanceManager.getDefault(LogixNG_InitializationManager.class).printTree(locale, writer, indent);
    }

    @InvokeOnGuiThread
    public static DefaultLogixNGManager instance() {
        if (!ThreadingUtil.isGUIThread()) {
            LoggingUtil.warnOnce(log, "instance() called on wrong thread", new Object[0]);
        }
        if (_instance == null) {
            _instance = new DefaultLogixNGManager();
        }
        return _instance;
    }

    @Override
    public Class<LogixNG> getNamedBeanClass() {
        return LogixNG.class;
    }

    @Override
    public Clipboard getClipboard() {
        return this._clipboard;
    }

    @Override
    public void registerManager(Manager<? extends MaleSocket> manager) {
        this._managers.put(manager.getClass().getName(), manager);
    }

    @Override
    public Manager<? extends MaleSocket> getManager(String className) {
        return this._managers.get(className);
    }

    @OverridingMethodsMustInvokeSuper
    public void fireVetoableChange(String p, Object old) throws PropertyVetoException {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, p, old, null);
        VetoableChangeListener[] vetoableChangeListenerArray = this.vetoableChangeSupport.getVetoableChangeListeners();
        int n = vetoableChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableChangeListener vc = vetoableChangeListenerArray[n2];
            vc.vetoableChange(evt);
            ++n2;
        }
    }

    @Override
    public final void deleteBean(@Nonnull LogixNG logixNG, @Nonnull String property) throws PropertyVetoException {
        int i = 0;
        while (i < logixNG.getNumConditionalNGs()) {
            ConditionalNG child = logixNG.getConditionalNG(i);
            InstanceManager.getDefault(ConditionalNG_Manager.class).deleteBean(child, property);
            ++i;
        }
        this.fireVetoableChange(property, logixNG);
        if (property.equals("DoDelete")) {
            this.deregister(logixNG);
            logixNG.dispose();
        }
    }
}

