/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.implementation.AbstractNamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.ConditionalNG_Manager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.implementation.Bundle;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogixNG
extends AbstractNamedBean
implements LogixNG {
    private final LogixNG_Manager _manager = InstanceManager.getDefault(LogixNG_Manager.class);
    private boolean _enabled = false;
    private final List<ConditionalNG_Entry> _conditionalNG_Entries = new ArrayList<ConditionalNG_Entry>();
    private static final Logger log = LoggerFactory.getLogger(DefaultLogixNG.class);

    public DefaultLogixNG(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        Manager.NameValidity isNameValid = InstanceManager.getDefault(LogixNG_Manager.class).validSystemNameFormat(this.mSystemName);
        if (isNameValid != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("system name is not valid");
        }
    }

    @Override
    public Base getParent() {
        return null;
    }

    @Override
    public void setParent(Base parent) {
        throw new UnsupportedOperationException("A LogixNG cannot have a parent");
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameLogixNG");
    }

    @Override
    public void setState(int s) throws JmriException {
        log.warn("Unexpected call to setState in DefaultLogixNG.");
    }

    @Override
    public int getState() {
        log.warn("Unexpected call to getState in DefaultLogixNG.");
        return 1;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return "LogixNG";
    }

    @Override
    public String getLongDescription(Locale locale) {
        return "LogixNG: " + this.getDisplayName();
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Category getCategory() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public final void setup() {
        for (ConditionalNG_Entry entry : this._conditionalNG_Entries) {
            if (entry._conditionalNG == null || !entry._conditionalNG.getSystemName().equals(entry._systemName)) {
                String systemName = entry._systemName;
                if (systemName == null) continue;
                entry._conditionalNG = InstanceManager.getDefault(ConditionalNG_Manager.class).getBySystemName(systemName);
                if (entry._conditionalNG != null) {
                    entry._conditionalNG.setup();
                    continue;
                }
                log.error("cannot load conditionalNG " + systemName);
                continue;
            }
            entry._conditionalNG.setup();
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        this._enabled = enable;
        if (this.isActive()) {
            this.registerListeners();
            this.execute(true);
        } else {
            this.unregisterListeners();
        }
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public String getConditionalNG_SystemName(int index) {
        return this._conditionalNG_Entries.get(index)._systemName;
    }

    @Override
    public void setConditionalNG_SystemName(int index, String systemName) {
        if (index == this._conditionalNG_Entries.size()) {
            this._conditionalNG_Entries.add(new ConditionalNG_Entry(systemName));
        } else {
            ConditionalNG_Entry entry = this._conditionalNG_Entries.get(index);
            entry._systemName = systemName;
            entry._conditionalNG = null;
        }
    }

    @Override
    public int getNumConditionalNGs() {
        return this._conditionalNG_Entries.size();
    }

    @Override
    public void swapConditionalNG(int nextInOrder, int row) {
        if (row <= nextInOrder) {
            return;
        }
        ConditionalNG_Entry temp = this._conditionalNG_Entries.get(row);
        int i = row;
        while (i > nextInOrder) {
            this._conditionalNG_Entries.set(i, this._conditionalNG_Entries.get(i - 1));
            --i;
        }
        this._conditionalNG_Entries.set(nextInOrder, temp);
    }

    @Override
    public ConditionalNG getConditionalNG(int order) {
        try {
            return this._conditionalNG_Entries.get(order)._conditionalNG;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public boolean addConditionalNG(ConditionalNG conditionalNG) {
        ConditionalNG_Entry entry2;
        for (ConditionalNG_Entry entry2 : this._conditionalNG_Entries) {
            if (!conditionalNG.getSystemName().equals(entry2._systemName)) continue;
            if (entry2._conditionalNG == null) {
                entry2._conditionalNG = conditionalNG;
                return true;
            }
            log.error("ConditionalNG '{}' has already been added to LogixNG '{}'", (Object)conditionalNG.getSystemName(), (Object)this.getSystemName());
            return false;
        }
        entry2 = new ConditionalNG_Entry(conditionalNG, conditionalNG.getSystemName());
        this._conditionalNG_Entries.add(entry2);
        conditionalNG.setParent(this);
        return true;
    }

    @Override
    public ConditionalNG getConditionalNG(String systemName) {
        int i = 0;
        while (i < this.getNumConditionalNGs()) {
            if (systemName.equals(this._conditionalNG_Entries.get(i)._systemName)) {
                return this._conditionalNG_Entries.get(i)._conditionalNG;
            }
            ++i;
        }
        return null;
    }

    @Override
    public ConditionalNG getConditionalNGByUserName(String userName) {
        for (ConditionalNG_Entry entry : this._conditionalNG_Entries) {
            if (!userName.equals(entry._conditionalNG.getUserName())) continue;
            return entry._conditionalNG;
        }
        return null;
    }

    @Override
    public void deleteConditionalNG(ConditionalNG conditionalNG) {
        if (this._conditionalNG_Entries.size() <= 0) {
            log.error("attempt to delete ConditionalNG not in LogixNG: {}", (Object)conditionalNG.getSystemName());
            return;
        }
        boolean found = false;
        for (ConditionalNG_Entry entry : this._conditionalNG_Entries) {
            if (conditionalNG != entry._conditionalNG) continue;
            this._conditionalNG_Entries.remove(entry);
            found = true;
            break;
        }
        if (!found) {
            log.error("attempt to delete ConditionalNG not in LogixNG: {}", (Object)conditionalNG.getSystemName());
        }
    }

    @Override
    public boolean isActive() {
        return this._enabled && this._manager.isActive();
    }

    @Override
    public void execute() {
        for (ConditionalNG_Entry entry : this._conditionalNG_Entries) {
            entry._conditionalNG.execute();
        }
    }

    @Override
    public void execute(boolean allowRunDelayed) {
        for (ConditionalNG_Entry entry : this._conditionalNG_Entries) {
            entry._conditionalNG.execute(allowRunDelayed);
        }
    }

    @Override
    public ConditionalNG getConditionalNG() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public LogixNG getLogixNG() {
        return this;
    }

    @Override
    public final Base getRoot() {
        return this;
    }

    @Override
    public boolean setParentForAllChildren(List<String> errors) {
        boolean result = true;
        for (ConditionalNG_Entry entry : this._conditionalNG_Entries) {
            if (entry._conditionalNG == null) continue;
            entry._conditionalNG.setParent(this);
            boolean bl = result = result && entry._conditionalNG.setParentForAllChildren(errors);
        }
        return result;
    }

    @Override
    public void registerListeners() {
        for (ConditionalNG_Entry entry : this._conditionalNG_Entries) {
            entry._conditionalNG.registerListeners();
        }
    }

    @Override
    public void unregisterListeners() {
        for (ConditionalNG_Entry entry : this._conditionalNG_Entries) {
            entry._conditionalNG.unregisterListeners();
        }
    }

    protected void printTreeRow(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String currentIndent, MutableInt lineNumber) {
        if (settings._printLineNumbers) {
            writer.append(String.format("%8d:  ", lineNumber.addAndGet(1)));
        }
        writer.append(currentIndent);
        writer.append(this.getLongDescription(locale));
        writer.println();
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, PrintWriter writer, String indent, MutableInt lineNumber) {
        this.printTree(settings, Locale.getDefault(), writer, indent, "", lineNumber);
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String indent, MutableInt lineNumber) {
        this.printTree(settings, locale, writer, indent, "", lineNumber);
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String indent, String currentIndent, MutableInt lineNumber) {
        this.printTreeRow(settings, locale, writer, currentIndent, lineNumber);
        int i = 0;
        while (i < this.getNumConditionalNGs()) {
            this.getConditionalNG(i).printTree(settings, locale, writer, indent, String.valueOf(currentIndent) + indent, lineNumber);
            ++i;
        }
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Base deepCopyChildren(Base original, Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            this.getUsageTree(0, bean, report, null);
        }
        return report;
    }

    @Override
    public void getUsageTree(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("** {} :: {}", (Object)level, (Object)this.getClass().getName());
        ++level;
        int i = 0;
        while (i < this.getNumConditionalNGs()) {
            this.getConditionalNG(i).getUsageTree(level, bean, report, this.getConditionalNG(i));
            ++i;
        }
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
    }

    @Override
    public void getListenerRefsIncludingChildren(List<String> list) {
        list.addAll(this.getListenerRefs());
        int i = 0;
        while (i < this.getNumConditionalNGs()) {
            this.getConditionalNG(i).getListenerRefsIncludingChildren(list);
            ++i;
        }
    }

    private static class ConditionalNG_Entry {
        private String _systemName;
        private ConditionalNG _conditionalNG;

        private ConditionalNG_Entry(ConditionalNG conditionalNG, String systemName) {
            this._systemName = systemName;
            this._conditionalNG = conditionalNG;
        }

        private ConditionalNG_Entry(ConditionalNG conditionalNG) {
            this._conditionalNG = conditionalNG;
        }

        private ConditionalNG_Entry(String systemName) {
            this._systemName = systemName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ConditionalNG_Entry: name =");
            sb.append(this._systemName);
            sb.append(", cdl = ");
            sb.append(this._conditionalNG == null ? "----" : this._conditionalNG.getDisplayName());
            return sb.toString();
        }
    }
}

