/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InvokeOnGuiThread;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionBean;
import jmri.jmrit.logixng.DigitalExpressionFactory;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleDigitalExpressionSocket;
import jmri.jmrit.logixng.MaleDigitalExpressionSocketFactory;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.implementation.AbstractBaseManager;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.implementation.DefaultMaleDigitalExpressionSocket;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDigitalExpressionManager
extends AbstractBaseManager<MaleDigitalExpressionSocket>
implements DigitalExpressionManager,
InstanceManagerAutoDefault {
    private final Map<Category, List<Class<? extends Base>>> expressionClassList = new HashMap<Category, List<Class<? extends Base>>>();
    private MaleSocket _lastRegisteredBean;
    static volatile DefaultDigitalExpressionManager _instance = null;
    private static final Logger log = LoggerFactory.getLogger(DefaultDigitalExpressionManager.class);

    public DefaultDigitalExpressionManager() {
        InstanceManager.getDefault(LogixNG_Manager.class).registerManager(this);
        for (DigitalExpressionFactory expressionFactory : ServiceLoader.load(DigitalExpressionFactory.class)) {
            expressionFactory.init();
        }
        for (Category category : Category.values()) {
            this.expressionClassList.put(category, new ArrayList());
        }
        for (DigitalExpressionFactory expressionFactory : ServiceLoader.load(DigitalExpressionFactory.class)) {
            expressionFactory.getExpressionClasses().forEach(entry -> this.expressionClassList.get(entry.getKey()).add((Class)entry.getValue()));
        }
        for (MaleDigitalExpressionSocketFactory maleSocketFactory : ServiceLoader.load(MaleDigitalExpressionSocketFactory.class)) {
            this._maleSocketFactories.add(maleSocketFactory);
        }
    }

    @Override
    public Class<? extends MaleSocket> getMaleSocketClass() {
        return DefaultMaleDigitalExpressionSocket.class;
    }

    protected MaleDigitalExpressionSocket createMaleExpressionSocket(DigitalExpressionBean expression) {
        DefaultMaleDigitalExpressionSocket socket = new DefaultMaleDigitalExpressionSocket((BaseManager<? extends NamedBean>)this, expression);
        expression.setParent(socket);
        return socket;
    }

    @Override
    public MaleSocket getLastRegisteredMaleSocket() {
        return this._lastRegisteredBean;
    }

    @Override
    public MaleDigitalExpressionSocket registerBean(MaleDigitalExpressionSocket maleSocket) {
        MaleDigitalExpressionSocket bean = super.registerBean(maleSocket);
        this._lastRegisteredBean = maleSocket;
        return bean;
    }

    @Override
    public MaleDigitalExpressionSocket registerExpression(@Nonnull DigitalExpressionBean expression) throws IllegalArgumentException {
        if (expression instanceof MaleDigitalExpressionSocket) {
            throw new IllegalArgumentException("registerExpression() cannot register a MaleDigitalExpressionSocket. Use the method register() instead.");
        }
        if (this.validSystemNameFormat(expression.getSystemName()) != Manager.NameValidity.VALID) {
            log.warn("SystemName " + expression.getSystemName() + " is not in the correct format");
            throw new IllegalArgumentException("System name is invalid: " + expression.getSystemName());
        }
        this.updateAutoNumber(expression.getSystemName());
        MaleDigitalExpressionSocket maleSocket = this.createMaleExpressionSocket(expression);
        return this.registerBean(maleSocket);
    }

    @Override
    public int getXMLOrder() {
        return 330;
    }

    @Override
    public char typeLetter() {
        return 'Q';
    }

    @Override
    public FemaleDigitalExpressionSocket createFemaleSocket(Base parent, FemaleSocketListener listener, String socketName) {
        return new DefaultFemaleDigitalExpressionSocket(parent, listener, socketName);
    }

    @Override
    public Map<Category, List<Class<? extends Base>>> getExpressionClasses() {
        return this.expressionClassList;
    }

    @Override
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameDigitalExpressions" : "BeanNameDigitalExpression");
    }

    @Override
    public void deleteDigitalExpression(MaleDigitalExpressionSocket x) {
        this.deregister(x);
        x.dispose();
    }

    @InvokeOnGuiThread
    public static DefaultDigitalExpressionManager instance() {
        if (!ThreadingUtil.isGUIThread()) {
            LoggingUtil.warnOnce(log, "instance() called on wrong thread", new Object[0]);
        }
        if (_instance == null) {
            _instance = new DefaultDigitalExpressionManager();
        }
        return _instance;
    }

    @Override
    public Class<MaleDigitalExpressionSocket> getNamedBeanClass() {
        return MaleDigitalExpressionSocket.class;
    }

    @Override
    protected MaleDigitalExpressionSocket castBean(MaleSocket maleSocket) {
        return (MaleDigitalExpressionSocket)maleSocket;
    }
}

