/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.InstanceManager;
import jmri.InvokeOnGuiThread;
import jmri.Manager;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.ConditionalNG_Manager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultConditionalNG;
import jmri.managers.AbstractManager;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConditionalNGManager
extends AbstractManager<ConditionalNG>
implements ConditionalNG_Manager {
    static volatile DefaultConditionalNGManager _instance = null;
    private static final Logger log = LoggerFactory.getLogger(DefaultConditionalNGManager.class);

    public DefaultConditionalNGManager() {
        InstanceManager.getDefault(LogixNGPreferences.class);
    }

    @Override
    public int getXMLOrder() {
        return 300;
    }

    @Override
    public char typeLetter() {
        return 'Q';
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(String systemName) {
        return LogixNG_Manager.validSystemNameFormat(this.getSubSystemNamePrefix(), systemName);
    }

    @Override
    public ConditionalNG createConditionalNG(LogixNG logixNG, String systemName, String userName) throws IllegalArgumentException {
        return this.createConditionalNG(logixNG, systemName, userName, 0);
    }

    @Override
    public ConditionalNG createConditionalNG(LogixNG logixNG, String systemName, String userName, int threadID) throws IllegalArgumentException {
        ConditionalNG x;
        if (userName != null && !userName.isEmpty() && (x = this.getByUserName(logixNG, userName)) != null) {
            log.error("username '{}' already exists, conditionalNG is '{}'", (Object)userName, (Object)x.getDisplayName());
            return null;
        }
        x = this.getBySystemName(systemName);
        if (x != null) {
            log.error("systemname '{}' already exists, conditionalNG is '{}'", (Object)systemName, (Object)x.getDisplayName());
            return null;
        }
        if (this.validSystemNameFormat(systemName) != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("SystemName '" + systemName + "' is not in the correct format");
        }
        x = new DefaultConditionalNG(systemName, userName, threadID);
        logixNG.addConditionalNG(x);
        this.updateAutoNumber(systemName);
        return x;
    }

    @Override
    public ConditionalNG createConditionalNG(LogixNG logixNG, String userName) throws IllegalArgumentException {
        return this.createConditionalNG(logixNG, this.getAutoSystemName(), userName);
    }

    @Override
    public ConditionalNG createConditionalNG(LogixNG logixNG, String userName, int threadID) throws IllegalArgumentException {
        return this.createConditionalNG(logixNG, this.getAutoSystemName(), userName, threadID);
    }

    @Override
    public ConditionalNG getConditionalNG(LogixNG logixNG, String name) {
        ConditionalNG x;
        if (logixNG != null && (x = this.getByUserName(logixNG, name)) != null) {
            return x;
        }
        return this.getBySystemName(name);
    }

    @Override
    public LogixNG getParentLogixNG(String systemName) {
        if (systemName == null || systemName.isEmpty()) {
            return null;
        }
        for (LogixNG logixNG : InstanceManager.getDefault(LogixNG_Manager.class).getNamedBeanSet()) {
            int i = 0;
            while (i < logixNG.getNumConditionalNGs()) {
                if (systemName.equals(logixNG.getConditionalNG_SystemName(i))) {
                    return logixNG;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public ConditionalNG getByUserName(LogixNG logixNG, String name) {
        if (logixNG != null && name != null && !name.isEmpty()) {
            int i = 0;
            while (i < logixNG.getNumConditionalNGs()) {
                ConditionalNG conditionalNG = logixNG.getConditionalNG(i);
                if (conditionalNG != null && name.equals(conditionalNG.getUserName())) {
                    return conditionalNG;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public ConditionalNG getBySystemName(String name) {
        LogixNG logixNG = this.getParentLogixNG(name);
        if (logixNG != null) {
            int i = 0;
            while (i < logixNG.getNumConditionalNGs()) {
                if (name.equals(logixNG.getConditionalNG_SystemName(i))) {
                    return logixNG.getConditionalNG(i);
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameConditionalNGs" : "BeanNameConditionalNG");
    }

    @Override
    public void deleteConditionalNG(ConditionalNG x) {
        this.deregister(x);
        x.dispose();
    }

    @Override
    public void setLoadDisabled(boolean s) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRunOnGUIDelayed(boolean value) {
        InstanceManager.getDefault(LogixNG_Manager.class).getNamedBeanSet().forEach(logixNG -> {
            int i = 0;
            while (i < logixNG.getNumConditionalNGs()) {
                if (logixNG.getConditionalNG(i) != null) {
                    logixNG.getConditionalNG(i).setRunDelayed(false);
                }
                ++i;
            }
        });
    }

    @InvokeOnGuiThread
    public static DefaultConditionalNGManager instance() {
        if (!ThreadingUtil.isGUIThread()) {
            LoggingUtil.warnOnce(log, "instance() called on wrong thread", new Object[0]);
        }
        if (_instance == null) {
            _instance = new DefaultConditionalNGManager();
        }
        return _instance;
    }

    @Override
    public Class<ConditionalNG> getNamedBeanClass() {
        return ConditionalNG.class;
    }

    @OverridingMethodsMustInvokeSuper
    public void fireVetoableChange(String p, Object old) throws PropertyVetoException {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, p, old, null);
        VetoableChangeListener[] vetoableChangeListenerArray = this.vetoableChangeSupport.getVetoableChangeListeners();
        int n = vetoableChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableChangeListener vc = vetoableChangeListenerArray[n2];
            vc.vetoableChange(evt);
            ++n2;
        }
    }

    @Override
    public final void deleteBean(@Nonnull ConditionalNG conditionalNG, @Nonnull String property) throws PropertyVetoException {
        int i = 0;
        while (i < conditionalNG.getChildCount()) {
            FemaleSocket child = conditionalNG.getChild(i);
            if (child.isConnected()) {
                MaleSocket maleSocket = child.getConnectedSocket();
                maleSocket.getManager().deleteBean(maleSocket, property);
            }
            ++i;
        }
        this.fireVetoableChange(property, conditionalNG);
        if (property.equals("DoDelete")) {
            if (conditionalNG.getLogixNG() != null) {
                conditionalNG.getLogixNG().deleteConditionalNG(conditionalNG);
            }
            conditionalNG.dispose();
        }
    }
}

