/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.logixng.AbortConditionalNGExecutionException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.ConditionalNG_Manager;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.Stack;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleDigitalActionSocket;
import jmri.jmrit.logixng.implementation.DefaultStack;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import jmri.jmrit.logixng.implementation.ExecuteLock;
import jmri.jmrit.logixng.util.LogixNG_Thread;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConditionalNG
extends AbstractBase
implements ConditionalNG,
FemaleSocketListener {
    private final LogixNG_Thread _thread;
    private int _startupThreadId;
    private Base _parent = null;
    private String _socketSystemName = null;
    private final FemaleDigitalActionSocket _femaleSocket;
    private boolean _enabled = true;
    private final ExecuteLock _executeLock = new ExecuteLock();
    private boolean _runDelayed = true;
    private final Stack _stack = new DefaultStack();
    private SymbolTable _symbolTable;
    private static final Logger log = LoggerFactory.getLogger(DefaultConditionalNG.class);

    public DefaultConditionalNG(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        this(sys, user, 0);
    }

    public DefaultConditionalNG(String sys, String user, int threadID) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._startupThreadId = threadID;
        this._thread = LogixNG_Thread.getThread(threadID);
        this._thread.setThreadInUse();
        Manager.NameValidity isNameValid = InstanceManager.getDefault(ConditionalNG_Manager.class).validSystemNameFormat(this.mSystemName);
        if (isNameValid != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("system name is not valid");
        }
        this._femaleSocket = new DefaultFemaleDigitalActionSocket(this, this, "A");
    }

    @Override
    public LogixNG_Thread getCurrentThread() {
        return this._thread;
    }

    @Override
    public int getStartupThreadId() {
        return this._startupThreadId;
    }

    @Override
    public void setStartupThreadId(int threadId) {
        int oldStartupThreadId = this._startupThreadId;
        this._startupThreadId = threadId;
        this.firePropertyChange("Thread", oldStartupThreadId, this._startupThreadId);
    }

    @Override
    public Base getParent() {
        return this._parent;
    }

    @Override
    public void setParent(Base parent) {
        this._parent = parent;
        if (this.isActive()) {
            this.registerListeners();
        } else {
            this.unregisterListeners();
        }
    }

    @Override
    public FemaleDigitalActionSocket getFemaleSocket() {
        return this._femaleSocket;
    }

    @Override
    public void setRunDelayed(boolean value) {
        this._runDelayed = value;
    }

    @Override
    public boolean getRunDelayed() {
        return this._runDelayed;
    }

    private void runOnLogixNG_Thread(@Nonnull ThreadingUtil.ThreadAction ta, boolean allowRunDelayed) {
        if (this._runDelayed && allowRunDelayed) {
            this._thread.runOnLogixNGEventually(ta);
        } else {
            this._thread.runOnLogixNG(ta);
        }
    }

    @Override
    public void execute() {
        if (this._executeLock.once()) {
            this.runOnLogixNG_Thread(new ExecuteTask(this, this._executeLock, null), true);
        }
    }

    @Override
    public void execute(boolean allowRunDelayed) {
        if (this._executeLock.once()) {
            this.runOnLogixNG_Thread(new ExecuteTask(this, this._executeLock, null), allowRunDelayed);
        }
    }

    @Override
    public void execute(FemaleDigitalActionSocket socket) {
        this.runOnLogixNG_Thread(() -> DefaultConditionalNG.internalExecute(this, socket), true);
    }

    private static void internalExecute(ConditionalNG conditionalNG, FemaleDigitalActionSocket femaleSocket) {
        if (conditionalNG.isEnabled()) {
            DefaultSymbolTable newSymbolTable = new DefaultSymbolTable(conditionalNG);
            try {
                conditionalNG.setSymbolTable(newSymbolTable);
                if (femaleSocket != null) {
                    femaleSocket.execute();
                } else {
                    conditionalNG.getFemaleSocket().execute();
                }
            }
            catch (AbortConditionalNGExecutionException e) {
                log.warn("ConditionalNG {} was aborted during execute: {}", new Object[]{conditionalNG.getSystemName(), e.getCause(), e.getCause()});
            }
            catch (RuntimeException | JmriException e) {
                log.warn("ConditionalNG {} got an exception during execute: {}", new Object[]{conditionalNG.getSystemName(), e, e});
            }
            conditionalNG.setSymbolTable(newSymbolTable.getPrevSymbolTable());
        }
    }

    @Override
    public Stack getStack() {
        return this._stack;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this._symbolTable;
    }

    @Override
    public void setSymbolTable(SymbolTable symbolTable) {
        this._symbolTable = symbolTable;
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameConditionalNG");
    }

    @Override
    public void setState(int s) throws JmriException {
        log.warn("Unexpected call to setState in DefaultConditionalNG.");
    }

    @Override
    public int getState() {
        log.warn("Unexpected call to getState in DefaultConditionalNG.");
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        this._socketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        this._socketSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return "ConditionalNG: " + this.getDisplayName();
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this._thread.getThreadId() != 0) {
            return "ConditionalNG: " + this.getDisplayName() + " on thread " + this._thread.getThreadName();
        }
        return "ConditionalNG: " + this.getDisplayName();
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        if (index != 0) {
            throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
        }
        return this._femaleSocket;
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public Category getCategory() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setSocketSystemName(String systemName) {
        if (systemName == null || !systemName.equals(this._socketSystemName)) {
            this._femaleSocket.disconnect();
        }
        this._socketSystemName = systemName;
    }

    public String getSocketSystemName() {
        return this._socketSystemName;
    }

    @Override
    public final void setup() {
        if (!this._femaleSocket.isConnected() || !this._femaleSocket.getConnectedSocket().getSystemName().equals(this._socketSystemName)) {
            this._femaleSocket.disconnect();
            if (this._socketSystemName != null) {
                try {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(this._socketSystemName);
                    if (maleSocket != null) {
                        this._femaleSocket.connect(maleSocket);
                        maleSocket.setup();
                    }
                    log.error("digital action is not found: " + this._socketSystemName);
                }
                catch (SocketAlreadyConnectedException socketAlreadyConnectedException) {
                    throw new RuntimeException("socket is already connected");
                }
            }
        } else {
            this._femaleSocket.setup();
        }
    }

    @Override
    public final void disposeMe() {
        this._femaleSocket.dispose();
    }

    @Override
    public void setEnabled(boolean enable) {
        this._enabled = enable;
        if (this.isActive()) {
            LogixNG logixNG = this.getLogixNG();
            if (logixNG != null && logixNG.isActive()) {
                this.registerListeners();
                this.execute();
            }
        } else {
            this.unregisterListeners();
        }
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static class ExecuteTask
    implements ThreadingUtil.ThreadAction {
        private final ConditionalNG _conditionalNG;
        private final ExecuteLock _executeLock;
        private final FemaleDigitalActionSocket _localFemaleSocket;

        public ExecuteTask(ConditionalNG conditionalNG, ExecuteLock executeLock, FemaleDigitalActionSocket femaleSocket) {
            this._conditionalNG = conditionalNG;
            this._executeLock = executeLock;
            this._localFemaleSocket = femaleSocket;
        }

        @Override
        public void run() {
            while (this._executeLock.loop()) {
                DefaultConditionalNG.internalExecute(this._conditionalNG, this._localFemaleSocket);
            }
        }
    }
}

