/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InvokeOnGuiThread;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.logixng.AnalogExpressionBean;
import jmri.jmrit.logixng.AnalogExpressionFactory;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleAnalogExpressionSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleAnalogExpressionSocket;
import jmri.jmrit.logixng.MaleAnalogExpressionSocketFactory;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.implementation.AbstractBaseManager;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleAnalogExpressionSocket;
import jmri.jmrit.logixng.implementation.DefaultMaleAnalogExpressionSocket;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnalogExpressionManager
extends AbstractBaseManager<MaleAnalogExpressionSocket>
implements AnalogExpressionManager,
InstanceManagerAutoDefault {
    private final Map<Category, List<Class<? extends Base>>> expressionClassList = new HashMap<Category, List<Class<? extends Base>>>();
    private MaleSocket _lastRegisteredBean;
    static volatile DefaultAnalogExpressionManager _instance = null;
    private static final Logger log = LoggerFactory.getLogger(DefaultAnalogExpressionManager.class);

    public DefaultAnalogExpressionManager() {
        InstanceManager.getDefault(LogixNG_Manager.class).registerManager(this);
        for (AnalogExpressionFactory expressionFactory : ServiceLoader.load(AnalogExpressionFactory.class)) {
            expressionFactory.init();
        }
        for (Category category : Category.values()) {
            this.expressionClassList.put(category, new ArrayList());
        }
        for (AnalogExpressionFactory expressionFactory : ServiceLoader.load(AnalogExpressionFactory.class)) {
            expressionFactory.getClasses().forEach(entry -> this.expressionClassList.get(entry.getKey()).add((Class)entry.getValue()));
        }
        for (MaleAnalogExpressionSocketFactory maleSocketFactory : ServiceLoader.load(MaleAnalogExpressionSocketFactory.class)) {
            this._maleSocketFactories.add(maleSocketFactory);
        }
    }

    @Override
    public Class<? extends MaleSocket> getMaleSocketClass() {
        return DefaultMaleAnalogExpressionSocket.class;
    }

    protected MaleAnalogExpressionSocket createMaleAnalogExpressionSocket(AnalogExpressionBean expression) {
        DefaultMaleAnalogExpressionSocket socket = new DefaultMaleAnalogExpressionSocket((BaseManager<? extends NamedBean>)this, expression);
        expression.setParent(socket);
        return socket;
    }

    @Override
    public MaleSocket getLastRegisteredMaleSocket() {
        return this._lastRegisteredBean;
    }

    @Override
    public MaleAnalogExpressionSocket registerBean(MaleAnalogExpressionSocket maleSocket) {
        MaleAnalogExpressionSocket bean = super.registerBean(maleSocket);
        this._lastRegisteredBean = maleSocket;
        return bean;
    }

    @Override
    public MaleAnalogExpressionSocket registerExpression(@Nonnull AnalogExpressionBean expression) throws IllegalArgumentException {
        if (expression instanceof MaleAnalogExpressionSocket) {
            throw new IllegalArgumentException("registerExpression() cannot register a MaleAnalogExpressionSocket. Use the method register() instead.");
        }
        if (this.validSystemNameFormat(expression.getSystemName()) != Manager.NameValidity.VALID) {
            log.warn("SystemName " + expression.getSystemName() + " is not in the correct format");
            throw new IllegalArgumentException(String.format("System name is invalid: %s", expression.getSystemName()));
        }
        this.updateAutoNumber(expression.getSystemName());
        MaleAnalogExpressionSocket maleSocket = this.createMaleAnalogExpressionSocket(expression);
        return this.registerBean(maleSocket);
    }

    @Override
    public int getXMLOrder() {
        return 360;
    }

    @Override
    public String getBeanTypeHandled() {
        return Bundle.getMessage("BeanNameAnalogExpression");
    }

    @Override
    public void deleteAnalogExpression(MaleAnalogExpressionSocket x) {
        this.deregister(x);
        x.dispose();
    }

    @Override
    public char typeLetter() {
        return 'Q';
    }

    @Override
    public FemaleAnalogExpressionSocket createFemaleSocket(Base parent, FemaleSocketListener listener, String socketName) {
        return new DefaultFemaleAnalogExpressionSocket(parent, listener, socketName);
    }

    @Override
    public Map<Category, List<Class<? extends Base>>> getExpressionClasses() {
        return this.expressionClassList;
    }

    @Override
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameAnalogExpressions" : "BeanNameAnalogExpression");
    }

    @InvokeOnGuiThread
    public static DefaultAnalogExpressionManager instance() {
        if (!ThreadingUtil.isGUIThread()) {
            LoggingUtil.warnOnce(log, "instance() called on wrong thread", new Object[0]);
        }
        if (_instance == null) {
            _instance = new DefaultAnalogExpressionManager();
        }
        return _instance;
    }

    @Override
    public Class<MaleAnalogExpressionSocket> getNamedBeanClass() {
        return MaleAnalogExpressionSocket.class;
    }

    @Override
    protected MaleAnalogExpressionSocket castBean(MaleSocket maleSocket) {
        return (MaleAnalogExpressionSocket)maleSocket;
    }
}

