/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleAnySocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleAnySocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClipboardMany
extends AbstractBase
implements FemaleSocketListener {
    private Base _parent;
    private final List<ItemEntry> _itemEntries = new ArrayList<ItemEntry>();
    private boolean disableCheckForUnconnectedSocket = false;
    private static final Logger log = LoggerFactory.getLogger(ClipboardMany.class);

    public ClipboardMany(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._itemEntries.add(new ItemEntry(new DefaultFemaleAnySocket(this, this, this.getNewSocketName())));
    }

    public ClipboardMany(String sys, String user, List<ItemData> itemSystemNames) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this.setItemSystemNames(itemSystemNames);
    }

    private void setItemSystemNames(List<ItemData> systemNamesAndClasses) {
        if (!this._itemEntries.isEmpty()) {
            throw new RuntimeException("action system names cannot be set more than once");
        }
        for (ItemData itemData : systemNamesAndClasses) {
            DefaultFemaleAnySocket socket = new DefaultFemaleAnySocket(this, this, itemData._socketName);
            this._itemEntries.add(new ItemEntry(socket, itemData._className, itemData._systemName));
        }
    }

    public String getItemSystemName(int index) {
        return this._itemEntries.get(index)._socketSystemName;
    }

    @Override
    public void setup() {
        this.disableCheckForUnconnectedSocket = true;
        for (ItemEntry ae : this._itemEntries) {
            try {
                if (!ae._socket.isConnected() || !ae._socket.getConnectedSocket().getSystemName().equals(ae._socketSystemName)) {
                    String socketSystemName = ae._socketSystemName;
                    ae._socket.disconnect();
                    if (socketSystemName == null) continue;
                    MaleSocket namedBean = InstanceManager.getDefault(LogixNG_Manager.class).getManager(ae._itemManagerClass).getBySystemName(socketSystemName);
                    if (namedBean != null) {
                        if (namedBean instanceof MaleSocket) {
                            MaleSocket maleSocket = namedBean;
                            ae._socket.connect(maleSocket);
                            maleSocket.setup();
                            continue;
                        }
                        log.error("item " + socketSystemName + " is not a male socket");
                        continue;
                    }
                    log.error("cannot load item " + socketSystemName);
                    continue;
                }
                ae._socket.getConnectedSocket().setup();
            }
            catch (SocketAlreadyConnectedException socketAlreadyConnectedException) {
                throw new RuntimeException("socket is already connected");
            }
        }
        this.disableCheckForUnconnectedSocket = false;
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        return this._itemEntries.get(index)._socket;
    }

    @Override
    public int getChildCount() {
        return this._itemEntries.size();
    }

    public void ensureFreeSocketAtTop() {
        if (this._itemEntries.get(0)._socket.isConnected()) {
            DefaultFemaleAnySocket socket = new DefaultFemaleAnySocket(this, this, this.getNewSocketName());
            this._itemEntries.add(0, new ItemEntry(socket));
            ArrayList<DefaultFemaleAnySocket> list = new ArrayList<DefaultFemaleAnySocket>();
            list.add(socket);
            this.firePropertyChange("ChildCount", null, list);
        }
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (this.disableCheckForUnconnectedSocket) {
            return;
        }
        for (ItemEntry entry : this._itemEntries) {
            if (socket != entry._socket) continue;
            entry._socketSystemName = socket.getConnectedSocket().getSystemName();
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        int i = 0;
        while (i < this._itemEntries.size()) {
            ItemEntry entry = this._itemEntries.get(i);
            if (socket == entry._socket) {
                entry._socketSystemName = null;
                if (i <= 0) break;
                ArrayList<FemaleSocket> list = new ArrayList<FemaleSocket>();
                list.add(socket);
                this._itemEntries.remove(i);
                this.firePropertyChange("ChildCount", list, null);
                break;
            }
            ++i;
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Many_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "Many_Long");
    }

    @Override
    public void setState(int s) throws JmriException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getState() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getBeanType() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Base getParent() {
        return this._parent;
    }

    @Override
    public void setParent(Base parent) {
        this._parent = parent;
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Base deepCopyChildren(Base original, Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    private String getNewSocketName() {
        int x = 1;
        while (x < 10000) {
            boolean validName = true;
            int i = 0;
            while (i < this.getChildCount()) {
                String name = "X" + Integer.toString(x);
                if (name.equals(this.getChild(i).getName())) {
                    validName = false;
                    break;
                }
                ++i;
            }
            if (validName) {
                return "X" + Integer.toString(x);
            }
            ++x;
        }
        throw new RuntimeException("Unable to find a new socket name");
    }

    @Override
    public void disposeMe() {
    }

    public static class ItemData {
        public final String _systemName;
        public final String _className;
        public final String _socketName;

        public ItemData(String socketName, String systemName, String className) {
            this._systemName = systemName;
            this._className = className;
            this._socketName = socketName;
        }
    }

    private static class ItemEntry {
        private String _socketSystemName;
        private String _itemManagerClass;
        private final FemaleAnySocket _socket;

        private ItemEntry(FemaleAnySocket socket, String itemManagerClass, String socketSystemName) {
            this._socketSystemName = socketSystemName;
            this._itemManagerClass = itemManagerClass;
            this._socket = socket;
        }

        private ItemEntry(FemaleAnySocket socket) {
            this._socket = socket;
        }
    }
}

