/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.implementation.AbstractNamedBean;
import jmri.jmrit.logixng.AnonymousTable;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultAnonymousTable;
import jmri.jmrit.logixng.implementation.DefaultCsvNamedTable;
import jmri.util.FileUtil;

public abstract class AbstractNamedTable
extends AbstractNamedBean
implements NamedTable {
    private int _state = 1;
    protected final AnonymousTable _internalTable;

    public AbstractNamedTable(@Nonnull String sys, @CheckForNull String user, int numRows, int numColumns) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._internalTable = new DefaultAnonymousTable(numRows, numColumns);
    }

    public AbstractNamedTable(@Nonnull String systemName, @CheckForNull String userName, @Nonnull Object[][] data) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(systemName, userName);
        Manager.NameValidity isNameValid = InstanceManager.getDefault(NamedTableManager.class).validSystemNameFormat(this.mSystemName);
        if (isNameValid != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("system name is not valid");
        }
        this._internalTable = new DefaultAnonymousTable(data);
    }

    public AbstractNamedTable(@Nonnull String systemName, @CheckForNull String userName, @Nonnull String fileName, @Nonnull Object[][] data) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(systemName, userName);
        Manager.NameValidity isNameValid = InstanceManager.getDefault(NamedTableManager.class).validSystemNameFormat(this.mSystemName);
        if (isNameValid != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("system name is not valid");
        }
        this._internalTable = new DefaultAnonymousTable(data);
    }

    @Nonnull
    private static NamedTable loadFromCSV(@Nonnull String systemName, @CheckForNull String userName, @CheckForNull String fileName, @Nonnull List<String> lines, boolean registerInManager) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        NamedTableManager manager = InstanceManager.getDefault(NamedTableManager.class);
        if (userName != null && userName.isEmpty()) {
            userName = null;
        }
        int numRows = lines.size() - 1;
        if (lines.get(lines.size() - 1).isEmpty()) {
            --numRows;
        }
        int numColumns = 0;
        Object[][] csvCells = new String[numRows + 1][];
        int rowCount = 0;
        while (rowCount < numRows + 1) {
            String[] columns = lines.get(rowCount).split("\t");
            if (numColumns < columns.length) {
                numColumns = columns.length;
            }
            csvCells[rowCount] = columns;
            ++rowCount;
        }
        rowCount = 0;
        while (rowCount < numRows + 1) {
            String[] cells = csvCells[rowCount];
            if (cells.length < numColumns) {
                String[] newCells = new String[numColumns];
                System.arraycopy(cells, 0, newCells, 0, cells.length);
                csvCells[rowCount] = newCells;
                int i = cells.length;
                while (i < numColumns) {
                    newCells[i] = "";
                    ++i;
                }
                csvCells[rowCount] = newCells;
            }
            ++rowCount;
        }
        DefaultCsvNamedTable table = new DefaultCsvNamedTable(systemName, userName, fileName, csvCells);
        if (registerInManager) {
            manager.register(table);
        }
        return table;
    }

    @Nonnull
    public static NamedTable loadTableFromCSV_Text(@Nonnull String systemName, @CheckForNull String userName, @Nonnull String text, boolean registerInManager) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        List<String> lines = Arrays.asList(text.split("\\r?\\n", -1));
        return AbstractNamedTable.loadFromCSV(systemName, userName, null, lines, registerInManager);
    }

    @Nonnull
    public static NamedTable loadTableFromCSV_File(@Nonnull String systemName, @CheckForNull String userName, @Nonnull String fileName, boolean registerInManager) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException, IOException {
        List<String> lines = Files.readAllLines(FileUtil.getFile(fileName).toPath(), StandardCharsets.UTF_8);
        return AbstractNamedTable.loadFromCSV(systemName, userName, fileName, lines, registerInManager);
    }

    @Nonnull
    public static NamedTable loadTableFromCSV_File(@Nonnull String systemName, @CheckForNull String userName, @Nonnull File file, boolean registerInManager) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException, IOException {
        List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
        return AbstractNamedTable.loadFromCSV(systemName, userName, file.getPath(), lines, registerInManager);
    }

    @Override
    public void storeTableAsCSV(@Nonnull File file) throws FileNotFoundException {
        this._internalTable.storeTableAsCSV(file, this.getSystemName(), this.getUserName());
    }

    @Override
    public void storeTableAsCSV(@Nonnull File file, @CheckForNull String systemName, @CheckForNull String userName) throws FileNotFoundException {
        this._internalTable.storeTableAsCSV(file, systemName, userName);
    }

    @Override
    public void setState(int s) throws JmriException {
        this._state = s;
    }

    @Override
    public int getState() {
        return this._state;
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameTable");
    }

    @Override
    public Object getCell(int row, int column) {
        return this._internalTable.getCell(row, column);
    }

    @Override
    public void setCell(Object value, int row, int column) {
        this._internalTable.setCell(value, row, column);
    }

    @Override
    public int numRows() {
        return this._internalTable.numRows();
    }

    @Override
    public int numColumns() {
        return this._internalTable.numColumns();
    }

    @Override
    public int getRowNumber(String rowName) {
        return this._internalTable.getRowNumber(rowName);
    }

    @Override
    public int getColumnNumber(String columnName) {
        return this._internalTable.getColumnNumber(columnName);
    }
}

